.\"Copyright 1988 by Chris Lewis 2.1 90/07/18
.TH DUMPFT 1 local
.SH NAME
dumpft \- Look at troff font width files
.SH SYNOPSIS
.B dumpft
.B "[-s]"
.B "[-t]"
.B "[-w]"
.B "[-f]"
.B "[-d]"
.BI "[-h" skip "]"
.BI "[" options "]"
< width
.SH DESCRIPTION
The
.B dumpft
program allows you to look at CAT troff width files.
It produces on standard output a ditroff-like width table.
The unitwidth is 6 and the resolution is 432, so the numbers
you see are precisely the same as are in the CAT file.
.P
The produced width table can be modified and used with
.B dit2catwid
to generate new width tables, but you should specify
the
.B -d
option.
The
.B -d
option tells dumpft to generate the widths with a unitwidth of 10
and resolution 300 which matches the
.B dit2catwid
defaults.
.RB ( dit2catwid
doesn't support changing unitwidth (yet)).
.P
The
.B -s
option tells
.B dumpft
that the width table it's reading is for the
symbol font
(usually
.BR ftS ")."
.P
The
.B -t
option tells
.B dumpft
to dump the names of each of the characters in the font table
a form suitable for wrapping .TS/.TE around to generate a full
set of CAT troff character tables.
.P
The
.B -w
option tells
.B dumpft
to dump all of the characters in the font table
as a set of strings for inclusion in troff
documents.
.P
Similarly, the
.B -f
option tells psroff to generate a formatted example of all CAT troff
characters in the R, I, B and S fonts.
.P
For various reasons, you might want to look at CAT troff width tables
from systems that have different width file formats.
CAT troff width files vary from system to system by how much extraneous
junk is prepended to the actual 224 byte table.
Often, width tables are generated by compiling a C char array.
Some vendors remove the a.out header from the beginning of the resultant
object file, and others leave it there.
In order to interpret the width tables the program must skip over
the junk (if any).
.P
The
.BI "-h" skip
tells
.B dumpft
to skip \fIskip\fP bytes before reading the table.
The default
skip is set to what you built
.B psroff
with (HEADERSIZE define), you only need to specify
.B -h
if you're reading width files from another system.
.P
FYI: Xenix usually has HEADERSIZE 0.
Sun and Ultrix (and probably other BSD derived systems)
should have HEADERSIZE 32.
.P
If you have difficulties setting HEADERSIZE correctly, you might
want to use this option with varying settings
on /usr/lib/font/ftR (as supplied by your vendor) until
.B dumpft
stops screeching about missing widths.
.P
.B Dumpft
provides error messages on stderr if width entries are
missing or extra ones are found.
If you get lots of error messages, you're probably looking at a S
font file without
the
.B -s
option or vice-versa, or HEADERSIZE is wrong.
.P
For the curious, the full set of width table entries are in the
source for
.B cattab.c
in the psroff source directory.
.SH FILES
.if t .ta 2.5i
.if n .ta 3.5i
%%FONTDIR%%/<width>/ft*	psroff-built width tables.
.br
%%FONTDIR%%/ft*	CAT width tables from your vendor.
.SH "SEE ALSO"
troff2ps(1L), troff(1), cat(5L) and
cattab.c source.
.SH AUTHOR
Written by Chris Lewis
