/*	Copyright 1985, 1986, 1987, 1988 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		lj.c
	Author: 	Chris Lewis
	Specs:		LaserJet driver, hacked from ps.c and lcat.c

			Without font downloading, this is LJ compatible.
			Font downloading will require a LJ+, LJ500+ or
			LJ II.

*/

#include "defs.h"

#ifdef	LJ
#include "lj.h"

#ifndef	LJF
char *LJF;
#endif

#ifdef	PK
#include "pk.h"
#endif

#if	defined(PARTIAL)
#include "pkc.h"
#endif

#ifndef	lint
static char SCCSid[] =
    "@(#)lj.c: 2.1 Copyright 90/07/18 16:51:32 Chris Lewis";
#endif

struct troff2befont ljStdFont[108] = {

/*	Note on X-shift, Y-shift and point scale factor:
	The first two are shifts in the baseline position of the
	character, and the third is a multiplier of the point size.
	If they are zero, nothing happens.  If they are non-zero,
	they are first multiplied by .01, then (in the case of the
	shifts), multiplied by the current points to get a shift
	value in TROFF2LJ[XY] coordinates.  In the case of point scale
	factor, it is multiplied by <currentpointsize> * .01 and becomes
	the pointsize of the sequence to be emitted.
 */
/*          +-------------------------------- Troff character number
	    |
            |    +--------------------------- N: standard fonts
            |    |                            S: symbol font
            |    |                            D: draw macro
            |    |                            n: new font
            |    |
            |    |  +------------------------ X-shift: scale by deci-point*100
            |    |  |
            |    |  |  +--------------------- Y-shift: scale by deci-point*100
            |    |  |  |
            |    |  |  |  +------------------ Point-scale
            |    |  |  |  |
            |    |  |  |  |   +-------------- Sequence
            |    |  |  |  |   |
            v    v  v  v  v   v */
	/*  0*/	{N, 0, 0, 0, "h"},
	/*  1*/	{N, 0, 0, 0, "t"},
	/*  2*/	{N, 0, 0, 0, "n"},
	/*  3*/	{N, 0, 0, 0, "m"},
	/*  4*/	{N, 0, 0, 0, "l"},
	/*  5*/	{N, 0, 0, 0, "i"},
	/*  6*/	{N, 0, 0, 0, "z"},
	/*  7*/	{N, 0, 0, 0, "s"},
	/*  8*/	{N, 0, 0, 0, "d"},
	/*  9*/	{N, 0, 0, 0, "b"},
	/* 10*/	{N, 0, 0, 0, "x"},
	/* 11*/	{N, 0, 0, 0, "f"},
	/* 12*/	{N, 0, 0, 0, "j"},
	/* 13*/	{N, 0, 0, 0, "u"},
	/* 14*/	{N, 0, 0, 0, "k"},
	/* 15*/	{N, 0, 0, 0, NOC},
	/* 16*/	{N, 0, 0, 0, "p"},
	/* 17*/	{S, 0, 0, 0, "\366"},
	/* 18*/	{N, 0, 0, 0, ";"},
	/* 19*/	{N, 0, 0, 0, NOC},
	/* 20*/	{N, 0, 0, 0, "a"},
	/* 21*/	{N, 0, -200, 0, "_"},
	/* 22*/	{N, 0, 0, 0, "c"},
	/* 23*/	{N, 0, 0, 0, "`"},
	/* 24*/	{N, 0, 0, 0, "e"},
	/* 25*/	{N, 0, 0, 0, "'"},
	/* 26*/	{N, 0, 0, 0, "o"},
	/* 27*/	{N, 0, 0, 0, "\367"},
	/* 28*/	{N, 0, 0, 0, "r"},
	/* 29*/	{N, 0, 0, 0, "\370"},
	/* 30*/	{N, 0, 0, 0, "v"},
	/* 31*/	{N, 0, 0, 0, "-"},
	/* 32*/	{N, 0, 0, 0, "w"},
	/* 33*/	{N, 0, 0, 0, "q"},
	/* 34*/	{N, 0, 0, 0, "/"},
	/* 35*/	{N, 0, 0, 0, "."},
	/* 36*/	{N, 0, 0, 0, "g"},
	/* 37*/	{N, 0, 0, 0, "3/4"},
	/* 38*/	{N, 0, 0, 0, ","},
	/* 39*/	{N, 0, 0, 0, "&"},
	/* 40*/	{N, 0, 0, 0, "y"},
	/* 41*/	{N, 0, 0, 0, NOC},
	/* 42*/	{N, 0, 0, 0, "%"},
	/* 43*/	{N, 0, 0, 0, NOC},
	/* 44*/	{N, 0, 0, 0, "Q"},
	/* 45*/	{N, 0, 0, 0, "T"},
	/* 46*/	{N, 0, 0, 0, "O"},
	/* 47*/	{N, 0, 0, 0, "H"},
	/* 48*/	{N, 0, 0, 0, "N"},
	/* 49*/	{N, 0, 0, 0, "M"},
	/* 50*/	{N, 0, 0, 0, "L"},
	/* 51*/	{N, 0, 0, 0, "R"},
	/* 52*/	{N, 0, 0, 0, "G"},
	/* 53*/	{N, 0, 0, 0, "I"},
	/* 54*/	{N, 0, 0, 0, "P"},
	/* 55*/	{N, 0, 0, 0, "C"},
	/* 56*/	{N, 0, 0, 0, "V"},
	/* 57*/	{N, 0, 0, 0, "E"},
	/* 58*/	{N, 0, 0, 0, "Z"},
	/* 59*/	{N, 0, 0, 0, "D"},
	/* 60*/	{N, 0, 0, 0, "B"},
	/* 61*/	{N, 0, 0, 0, "S"},
	/* 62*/	{N, 0, 0, 0, "Y"},
	/*from here on are actually code 1-45, upper half of font */
	/* 63*/	{N, 0, 0, 0, "F"},
	/* 64*/	{N, 0, 0, 0, "X"},
	/* 65*/	{N, 0, 0, 0, "A"},
	/* 66*/	{N, 0, 0, 0, "W"},
	/* 67*/	{N, 0, 0, 0, "J"},
	/* 68*/	{N, 0, 0, 0, "U"},
	/* 69*/	{N, 0, 0, 0, "K"},
	/* 70*/	{N, 0, 0, 0, "0"},
	/* 71*/	{N, 0, 0, 0, "1"},
	/* 72*/	{N, 0, 0, 0, "2"},
	/* 73*/	{N, 0, 0, 0, "3"},
	/* 74*/	{N, 0, 0, 0, "4"},
	/* 75*/	{N, 0, 0, 0, "5"},
	/* 76*/	{N, 0, 0, 0, "6"},
	/* 77*/	{N, 0, 0, 0, "7"},
	/* 78*/	{N, 0, 0, 0, "8"},
	/* 79*/	{N, 0, 0, 0, "9"},
	/* 80*/	{N, 0, 0, 0, "*"},
	/* 81*/	{N, 0, 0, 0, "\366"},
	/* 82*/	{N, 0, 0, 0, "fi"},
	/* 83*/	{N, 0, 0, 0, "fl"},
	/* 84*/	{N, 0, 0, 0, "ff"},
	/* 85*/	{N, 0, 0, 0, "\277"},
	/* 86*/	{N, 0, 0, 0, "ffl"},
	/* 87*/	{N, 0, 0, 0, "ffi"},
	/* 88*/	{N, 0, 0, 0, "("},
	/* 89*/	{N, 0, 0, 0, ")"},
	/* 90*/	{N, 0, 0, 0, "["},
	/* 91*/	{N, 0, 0, 0, "]"},
	/* 92*/	{N, 0, 0, 0, "\263"},
	/* 93*/	{S, 0, 0, 0, "\316"},
	/* 94*/	{N, 0, 0, 0, "="},
	/* 95*/	{N, 0, 0, 0, "O\br"},
	/* 96*/	{N, 0, 0, 0, ":"},
	/* 97*/	{N, 0, 0, 0, "+"},
	/* 98*/	{N, 0, 0, 0, NOC},
	/* 99*/	{N, 0, 0, 0, "!"},
	/*100*/ {S, 0, 0, 0, "\314"},
	/*101*/	{N, 0, 0, 0, "?"},
	/*102*/ {N, 0, 0, 0, "\250"},
	/*103*/	{N, 0, 0, 0, "|"},
	/*104*/	{N, 0, 0, 0, NOC},
	/*105*/	{S, 0, 0, 0, "\331"},
	/*106*/	{S, 0, 0, 0, "\332"},
	/*107*/	{N, 0, 0, 0, "$"}
};

struct troff2befont ljSymFont[] = {
/*          +-------------------------------- Troff character number
	    |
            |    +--------------------------- N: standard fonts
            |    |                            S: symbol font
            |    |                            D: draw macro
            |    |                            n: new font
            |    |
            |    |  +------------------------ X-shift: scale by deci-point*100
            |    |  |
            |    |  |  +--------------------- Y-shift: scale by deci-point*100
            |    |  |  |
            |    |  |  |  +------------------ Point-scale (scaled by 100)
            |    |  |  |  |
            |    |  |  |  |   +-------------- Sequence
            |    |  |  |  |   |
            v    v  v  v  v   v */
	/*  0*/	{S, 0, 0, 0, "\167"},
	/*  1*/	{S, 0, 0, 0, "\150"},
	/*  2*/	{S, 0, 0, 0, "\155"},
	/*  3*/	{S, 0, 0, 0, "\154"},
	/*  4*/	{S, 0, 0, 0, "\153"},
	/*  5*/	{S, 0, 0, 0, "\151"},
	/*  6*/	{S, 0, 0, 0, "\146"},
	/*  7*/	{S, 0, 0, 0, "\162"},
	/*  8*/	{S, 0, 0, 0, "\144"},
	/*  9*/	{S, 0, 0, 0, "\142"},
	/* 10*/	{S, 0, 0, 0, "\156"},
	/* 11*/	{S, 0, 0, 0, "\147"},
	/* 12*/	{S, 0, 0, 0, "\165"},
	/* 13*/	{S, 0, 0, 0, "\164"},
	/* 14*/	{S, 0, 0, 0, "\152"},
	/* 15*/	{S, 0, 0, 0, NOC},
	/* 16*/	{S, 0, 0, 0, "\160"},
	/* 17*/	{N, 0, 0, 0, "@"},
	/* 18*/	{S, 0, 0, 0, "\243"},
	/* 19*/	{S, 0, 0, 0, NOC},
	/* 20*/	{S, 0, 0, 0, "\141"},
	/* 21*/	{N, 0, 0, 0, "|"},
	/* 22*/	{S, 0, 0, 0, "\166"},
	/* 23*/	{N, 0, 0, 0, "\042"},
	/* 24*/	{S, 0, 0, 0, "\145"},
	/* 25*/	{N, 0, 0, 0, "="},
	/* 26*/	{S, 0, 0, 0, "o"},
	/* 27*/	{S, 0, 0, 0, "\244"},
	/* 28*/	{S, 0, 0, 0, "\161"},
	/* 29*/	{S, 0, 0, 0, "\241"},
	/* 30*/	{S, 0, 0, 0, "\163"},
	/* 31*/	{N, 0, 0, 0, "_"},
	/* 32*/	{N, 0, 0, 0, "\\"},
	/* 33*/	{S, 0, 0, 0, "\127"},
	/* 34*/	{S, 0, 0, 0, "\177"},
	/* 35*/	{S, 0, 0, 0, "\044"},
	/* 36*/	{S, 0, 0, 0, "\143"},
	/* 37*/	{S, 0, 0, 0, "\277"},
	/* 38*/	{S, 0, 0, 0, "\046"},
	/* 39*/ {S, 0, 0, 0, "\375"},
	/* 40*/	{S, 0, 0, 0, "\170"},
	/* 41*/	{S, 0, 0, 0, NOC},
	/* 42*/	{S, 0, 0, 0, "\131"},
	/* 43*/	{S, 0, 0, 0, NOC},
	/* 44*/	{S, 0, 0, 0, "\125"},
	/* 45*/	{S, 0, 0, 0, "\110"},
	/* 46*/	{S, 0, 0, 0, "\130"},
	/* 47*/	{S, 0, 0, 0, "\265"},
	/* 48*/	{S, 0, 0, 0, "\260"},
	/* 49*/	{S, 0, 0, 0, "\123"},
	/* 50*/	{S, 0, 0, 0, "\113"},
	/* 51*/	{N, 0, 0, 0, "\366"},
	/* 52*/	{S, 0, 0, 0, "\103"},
	/* 53*/	{S, 0, 0, 0, "\325"},
	/* 54*/	{S, 0, 0, 0, "\120"},
	/* 55*/	{S, 0, 0, 0, "\272"},
	/* 56*/	{S, 0, 0, 0, "\273"},
	/* 57*/	{N, 0, 0, 0, "~"},
	/* 58*/	{S, 0, 0, 0, "\132"},
	/* 59*/	{S, 0, 0, 0, "\104"},
	/* 60*/	{S, 0, 0, 0, "\041"},
	/* 61*/	{S, 0, 0, 0, "\122"},
	/* 62*/	{S, 0, 0, 0, "\174"},
	/* 63*/	{N, 0, 0, 0, ">"},
	/* 64*/	{S, 0, 0, 0, "\116"},
	/* 65*/	{N, 0, 0, 0, "<"},
	/* 66*/	{N, 0, 0, 0, "/"},
	/* 67*/	{S, 0, 0, 0, "\266"},
	/* 68*/	{S, 0, 0, 0, "\124"},
	/* 69*/	{S, 0, 0, 0, "\310"},
	/* 70*/	{S, 0, 0, 0, "\360"},
	/* 71*/	{S, 0, 0, 0, "\342"},
	/* 72*/	{S, 0, 0, 0, "\365"},
	/* 73*/	{S, 0, 0, 0, "\343"},
	/* 74*/	{S, 0, 0, 0, "\344"},
	/* 75*/	{S, 0, 0, 0, "\362"},
	/* 76*/	{S, 0, 0, 0, "\363"},
	/* 77*/	{S, 0, 0, 0, "\364"},
	/* 78*/	{S, 0, 0, 0, "\361"},
	/* 79*/	{S, 0, 0, 0, "\341"},
	/* 80*/	{S, 0, 0, 0, "\340"},
	/* 81*/	{S, 0, 0, 0, "\052"},
	/* 82*/	{S, 0, 0, 0, "\045"},
	/* 83*/	{S, 0, 0, 0, "\376"},
	/* 84*/	{S, 0, 0, 0, "\134"},
	/* 85*/	{S, 0, 0, 0, "\136"},
	/* 86*/	{S, 0, 0, 0, "\175"},
	/* 87*/	{N, 0, 0, 0, "=\b/"},
	/* 88*/	{N, 0, 0, 0, "{"},
	/* 89*/	{N, 0, 0, 0, "}"},
	/* 90*/	{N, 0, 0, 0, "\250"},
	/* 91*/	{N, 0, 0, 0, "\251"},
	/* 92*/	{N, 0, 0, 0, "^"},
	/* 93*/	{N, 0, 0, 0, "#"},
	/* 94*/	{S, 0, 0, 0, "\373"},
	/* 95*/	{S, 0, 0, 0, "\267"},
	/* 96*/	{N, 0, 0, 0, "~"},
	/* 97*/	{N, 0, 0, 0, "\322"},
	/* 98*/	{N, 0, 0, 0, NOC},
	/* 99*/	{S, 0, 0, 0, "\317"},
	/*100*/	{N, -220, 0, 0, "|"},
	/*101*/	{N, 0, 2, 0, "*"},
	/*102*/	{S, 0, 0, 0, "\276"},
	/*103*/	{S, 0, 0, 0, "\315"},
	/*104*/	{S, 0, 0, 0, NOC},
	/*105*/	{N, 0, 0, 0, "+"},
	/*106*/	{S, 0, 0, 0, "\242"},
	/*107*/	{N, 0, 0, 0, "\275"}
};

int fontCount = 0;

ljPage() {
    printf("\033&l0H");
    pagePending = 1;
}

static
doPageStart() {
    currentPage++;
    fontCount = 0;
    pagePending = 0;
}

static
putoct(s)
char *s; {
    int d;
    if (strlen(s) < 3) {
	fprintf(stderr, "%s: octal sequence in fonts.l[kj] bad\n", progname);
	exit(1);
    }
    d = (*s - '0') * 64 + (*(s+1) - '0') * 8 + *(s+2) - '0';
    putchar(d);
}

static
int
ptcvt(points)
int  points; {
    register int r;
    switch (points) {
	case 6:  r = 0; break;
	case 7:  r = 1; break;
	case 8:  r = 2; break;
	case 9:  r = 3; break;
	case 10: r = 4; break;
	case 11: r = 5; break;
	case 12: r = 6; break;
	case 14: r = 7; break;
	case 16: r = 8; break;
	case 18: r = 9; break;
	case 20: r = 10; break;
	case 22: r = 11; break;
	case 24: r = 12; break;
	case 28: r = 13; break;
	case 36: r = 14; break;
	default: r = 15; break;
    }
    return(r);
}

/*	This function originally from Ronald Florence (ron@mlfarm),
	but extensively modified for new fontFlags mechanisms.

	We'll go at most 4 points up or down.  If this fails,
	we'll let the printer decide...  You may want to tweak
	these arrays.

	We go up first for requested pointsizes > 10, and down
	first for requested pointsizes < 10.  Seems to work best
	with EQN.
 */

static int
bestmatch(font, points)
int font, points;  {

    static int smalltry[ ] = { 0, -1, 1, -2, 2, -3, 3, -4, 4, 100 },
                 bigtry[ ] = { 0, 1, 2, -1, -2, 3, 4, -4, 100 };

    register char *p;
    register int *ip;

    ip = (points < 10) ? smalltry : bigtry;
    p = fonttable[font].fontFlags;

    for ( ; *ip < 100; ip++)
	if (p[ptcvt(points + *ip)] != 'n')
	    return(points + *ip);

    return (points);
}

#ifdef	INCR
dumpseq(font, pointidx, seq)
int font, pointidx;
register char *seq; {
    int fn = (font << 4) + pointidx;
    static int lastftid = -1;
    register int c;
    register struct pkc *pc = (struct pkc *) NULL;

    DBP((D_FONT, "dumpseq font: %d, idx: %d, seq: %s\n", font,
	pointidx, seq));

    for (;c = (*seq)&0xff; seq++) {
	if (!downchar(font, c, pointidx)) {

	    for (pc = fonttable[font].map->pkfont[pointidx]->pkp_chars;
		pc; pc = pc->pkc_next)
		if (pc->pkc_char == c)
		    break;

	    setdown(font, c, pointidx);

	    if (!pc)
		continue;

	    if (lastftid != fn) {
		DBP((D_FONT,"Emitting download font select (%d)\n", fn));
		printf("\033*c%dD", fn);
		lastftid = fn;
	    }

	    DBP((D_FONT,"Downloading %02x\n", pc->pkc_char));
	    epkc_desc(pc, stdout);
	} else
	    DBP((D_FONT,"Already downloaded %02x\n", c));
    }
}
#endif

ljSetFont(font, selpoints, fontcode, sequence)
int font, selpoints, fontcode;
char *sequence; {
    int points, pointidx;
    register char *pf, *p;
    register struct pkp *pk;
#if	!defined(INCR) && defined(PK)
    register struct pkc *pc;
#endif
    char buf[BUFSIZ];
#ifndef	PARTIAL
    FILE *fontfile;
#endif
    int count;
    int ftid;

#ifdef	COMPRESS
    int compressed = 0;
#endif


#ifndef	INCR
    if (lastPoints == selpoints && font == lastFont)
	return;
#endif

    points = bestmatch(font, selpoints);
    pointidx = ptcvt(points);

    pf = &fonttable[font].fontFlags[pointidx];
    ftid = (font << 4) + pointidx;

#ifdef	INCR
#ifdef	SFP
    if (*pf == 'S' || *pf == 'P') {
#else
    if (*pf == 'P') {
#endif
	/* header downloaded, check and download individual characters */
	dumpseq(font, pointidx, sequence);

	if (lastPoints != points || font != lastFont) {
	    DBP((D_FONT, "Selecting font %d\n", ftid));
	    lastPoints = points;
	    lastFont = font;
	    printf("\033(%dX", ftid);
	}

	return;

    }

    if (lastPoints == selpoints && font == lastFont)
	return;
#endif

    lastPoints = selpoints;
    lastFont = font;

    switch(*pf) {
#ifdef	PK
	case 'p':
#ifdef	PARTIAL
	case 's':
#endif
	    sprintf(buf, "%s/%s.%d.%s", LJF,
		fonttable[font].troffName, points,
		    (*pf == 's') ? "sfp":"pk");

	    fontCount++;
	    if (fontCount >= MAXDLFONTS) {
#ifdef	INCR
		pkflush(font, pointidx);
#else
		fprintf(stderr, "Too many fonts (page %d), simplify!\n",
		    currentPage);
#endif
	    }
	    DBP((D_FONT,"FONTLOAD PK font (ftid: %d) %s.%d via '%s'\n",
		ftid, fonttable[font].troffName,
		points, buf));

	    /* Read the PK file in-core */
	    pk = pk_read(buf,fontcode);

	    /* Set the fontid we'll use */
	    printf("\033*c%dd4F", ftid);

	    /* Emit the SFP header */
	    epk_desc(pk, stdout);

#ifndef	INCR
	    /* Emit each character */
	    for (pc = pk->pkp_chars; pc; pc = pc->pkc_next) {
		DBP((D_FONT,"Downloading ch %02x\n", pc->pkc_char);
		epkc_desc(pc, stdout));
	    }

	    /* Clobber in-core PK */
	    pk_destroy(pk);
#else
	    fonttable[font].map->pkfont[pointidx] = pk;
	    dumpseq(font, pointidx, sequence);
#endif

	    *pf = toupper(*pf);

	    /* buf */
	    goto setdownloaded;
#else
	case 'p':
	    fprintf(stderr,
		"%s: Font %s, size: %d is a PK - PK not defined in defs.h\n",
		progname, fonttable[font].troffName, selpoints);
	    goto setbuiltin;
#endif

#ifndef	PARTIAL
	case 's':
	    sprintf(buf, "%s/lj/%s.%d.sfp", LIBDIR, fonttable[font].troffName,
		points);

	    fontfile = fopen(buf, "r");

#ifdef	COMPRESS
	    if (!fontfile) {
		sprintf(buf, "%s %s/lj/%s.%d.sfp.Z",
		    COMPRESS, LIBDIR, fonttable[font].troffName, points);
		fontfile = popen(buf, "r");
		compressed = 1;
	    }
#endif

	    if (!fontfile) {
		fprintf(stderr, "%s: cannot open fontfile\n(%s)\n", progname,
		    buf);
		goto setbuiltin;
	    }

	    fontCount++;
	    if (fontCount >= MAXDLFONTS) {
#ifdef	INCR
		pkflush(font, pointidx);
#else
		fprintf(stderr, "Too many fonts (page %d), simplify!\n",
		    currentPage);
#endif
	    }

	    DBP((D_FONT,"Loading font (ftid: %d) %s.%d via '%s'\n",
		ftid, fonttable[font].troffName,
		points, buf));

	    printf("\033*c%dd4F", ftid);

	    while(0 < (count = fread(buf, sizeof(char), sizeof(buf), fontfile)))
		fwrite(buf, sizeof(char), count, stdout);

#ifdef	COMPRESS
	    if (compressed) {
		if (!pclose(fontfile)) {
		    fprintf(stderr, "%s: compress failed!\n", progname);
		    exit(1);
		}
	    } else
#endif
		fclose(fontfile);

	    *pf = toupper(*pf);
#endif
	    /* Fall Thru */

	case 'S': case 'P':
	    /* Select primary font by font id */
	setdownloaded:
	    DBP((D_FONT, "Selecting font2 %d\n", ftid));
	    printf("\033(%dX", ftid);
	    break;

	default:
	setbuiltin:
	    *pf = 'b';

	case 'b':
	    /* if builtin font, select it by characteristic */
	    for (p = fonttable[font].fontSeq; *p; p++) {
		if (*p == '\\') {
		    putoct(p+1);
		    p+=3;
		} else
		    putchar(*p);
	    }
	    printf("\033(s%dV", points);
	    break;
    }
}

ljChar(x, y, font, points, troffChar, sequence)
int x, y;
int font, points, troffChar;
char *sequence; {
    register int nx = TROFF2LJX(x), ny = TROFF2LJY(y);
    register struct troff2befont *rp;

#ifndef	OPT
    sequence = (char *) NULL;
#endif

    if (pagePending) {
	resetState();
	doPageStart();
    }

    DBP((D_BEND,"BEFORE (troffChar,x,y,font,points) = (%d,%d,%d,%d,%d)\n",
	troffChar, x, y, font, points));

    if (font == 3) {
	rp = &be->besymfont[troffChar];
    } else {
	rp = &be->bestdfont[troffChar];
    }

    switch(rp->t2b_font) {
	/* Only fonts with "N" are subject to font translation */
	case N:
	    if (font == 3)
		font = 0;	/* Special chars are Roman */
	    else {
		DBP((D_BEND,"ljSetChar %d->%s (%s)\n", font,
		    xlatetable[font]->troffName,
		    xlatetable[font]->fontName));
		font = xlatetable[font] - fonttable;
	    }
	    break;
	case S:
	    font = 3;
	    break;
	case D:
	    break;
	default:
	    /* Typically used when the R and S fonts don't have the
	       character desired, so select the font via the index
	       in the fonts.?? file */
	    font = rp->t2b_font;
	    break;
    }

    if (!sequence)
	sequence = rp->t2b_charseq;

    if (!sequence) {
	fprintf(stderr, "%s: No coding for char %d in %d font\n",
	    progname, troffChar, font);
	return;
    }

    /*	We're committed now - the "if" statements avoid floating
	arithmetic on slow machines */

    if (rp->t2b_scale) points *= (.01 * rp->t2b_scale);
    if (rp->t2b_xc) nx += points * (.01 * rp->t2b_xc);
    if (rp->t2b_yc) ny += points * (.01 * rp->t2b_yc);

    ljSetFont(font, points, rp->t2b_font, sequence);

    DBP((D_BEND,"AFTER (sequence,x,y,font,points) = (%s,%d,%d,%d,%d)\n",
	sequence, nx, ny, font, points));

/*	Egads, I discovered that 42% of the time in troff2ps was spent
	doing these damn conversions! */

#define	XYS	"\033&a%dh%dV%s"
#define	XS	"\033&a%dH%s"

    if (lastYPos != ny) {
	printf(XYS, nx, ny, sequence);
	lastYPos = ny;
    } else
	printf(XS, nx, sequence);
}

ljProlog() {
    extern char *ctime();
    FILE *library;
    int c;
    register char *p;

#ifndef	LJF
    LJF = mustmalloc(strlen(LIBDIR) + 5, "ljprolog");
    sprintf(LJF, "%s/lj", LIBDIR);
#endif

    /* to ensure that the strings are long enough for indexing and
       are sufficiently initialized */

    for (c = 0; fonttable[c].troffName; c++) {
	register int i;
	p = mustmalloc(20, "ljfontflags");
	strncpy(p, fonttable[c].fontFlags, 16);
	p[16] = '\0';
	free(fonttable[c].fontFlags);
	for (i = strlen(p); i < 16; i++)
	    p[i] = 'n';
	fonttable[c].fontFlags = p;
    }

#if	defined(INCR)
    /* create empty downloaded-yet arrays */
    for (c = 0; fonttable[c].troffName; c++) {
	register int i;
	for (i = 0, p = fonttable[c].fontFlags; *p; p++, i++)
#ifdef	SFP
	    if (*p == 'p' || *p == 's') {
#else
	    if (*p == 'p') {
#endif
		DBP((D_FONT, "Allocating font %d, size %d\n",
		    c, i));
		if (!fonttable[c].map) {
		    fonttable[c].map = (struct downmaps *)
			mustmalloc(sizeof(struct downmaps), "downmaps");
		}
		fonttable[c].map->nm[i] = (ETYP *) mustmalloc(ELEN *
		    sizeof(ETYP), "Nmaps");
		fonttable[c].map->lastpage[i] = 0;
	    }
    }

#ifdef	DEBUG
    dumpmaps(1);
#endif

#endif

#if	defined(PARTIAL)
    /* create need-arrays */
    for (c = 0; c < 108; c++)
	if (ljStdFont[c].t2b_charseq != NOC)
	    for (p = ljStdFont[c].t2b_charseq; *p; p++)
		addneedchar(ljStdFont[c].t2b_font, *p);

    for (c = 0; c < 108; c++)
	if (ljSymFont[c].t2b_charseq != NOC)
	    for (p = ljSymFont[c].t2b_charseq; *p; p++)
		addneedchar(ljSymFont[c].t2b_font, *p);
#endif

#if	defined(DEBUG) && defined(PARTIAL)
    dumpmaps(0);
#endif

    currentPage = 0;
    pagePending = 1;

    library = libopen(printer, "lib");

    ljXlate(library);
    fclose(library);
    doprologs();
}

ljEpilog() {
#if	defined(INCR)
    register struct fonttable *fp;
    register int i;
    /* delete fonts still active that we downloaded */
    for (fp = fonttable; fp->troffName; fp++)
	if (fp->map)
	    for (i = 0; i < 14; i++)
		if (fp->map->pkfont[i])
		    printf("\033*c%dd2F", ((fp - fonttable) << 4) + i);
#endif

#if	defined(DEBUG) && defined(INCR)
    dumpmaps(1);
#endif
}

/*	Copy the library file to the standard output, stripping
	%line\n
	%%%<something> is a metadirective
	and converting \nnn and \xnn as you go.
	Strip out line termination.
*/

ljXlate(library)
FILE *library; {
    char buf[4];
    int c, i;
    c = getc(library);
    while(!feof(library)) {

      nextchar:

	switch(c) {
	    case '%':
		/* strip from percent sign to end of line */
		/* If line is %%%<something> pass onto interp */
		if (((c = getc(library)) == '%') &&
		    ((c = getc(library)) == '%')) {
		    char buf2[4];
		    sprintf(buf2, ".%s", be->bename);
		    fgets(buf, strlen(buf), library);
		    interp(buf, ljXlate, buf2);
		    break;
		}
		while ((c = getc(library)) != EOF && c != '\n');
		break;
	    case '\n':	/* throw away real newlines. */
		break;
	    case '\\':
		c = getc(library);
		if (c == 'x' || c == 'X') {
		    i = 0;
		    while(1) {
			c = getc(library);

			if (c == EOF || !((c >= '0' && c <= '9') ||
					  (c >= 'A' && c <= 'F') ||
					  (c >= 'a' && c <= 'f')))
			    goto nextchar;

			buf[i++] = c;
			if (i == 2) {
			    buf[i] = '\0';
			    sscanf(buf, "%x", &i);
			    putchar(i);
			    i = 0;
			}
		    }
		} else {
		    buf[0] = c;
		    i = 1;
		    while(1) {
			c = getc(library);
			if (c == EOF || c < '0' || c > '7')
			    goto nextchar;
			buf[i++] = c;
			if (i == 3) {
			    buf[i] = '\0';
			    sscanf(buf, "%o", &i);
			    putchar(i);
			    i = 0;
			}
		    }
		}
		/* NOTREACHED */

	    case ' ': case '\t':
		break;

	    case EOF:
		fprintf(stderr, "%s: Unexpected eof on ljlib\n", progname);
		break;

	    default:
		putchar(c);
	}
	c = getc(library);
    }
}
#endif
