/*	Copyright 1988, 1989 16:51:24 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		defs.h 2.1 90/07/18 16:51:24
	Author: 	Chris Lewis
	Specs:		Main header file - contains some customization
 */

/*	Official Release and Patch level:	*/
#define	T2VERSION	"@(#)PSROFF Copyright 90/07/18 Chris Lewis - R2 P0"

#ifndef	LIBDIR
/*	Don't touch this */
#define	LIBDIR	"/usr/lib/troff2"
#endif

/*	Configuration parameters:
 */

#undef	BSD		/* Define if you are a V7 or BSD machine */
			/* strchr vs. index etc.... */

#define	ATT		/* Define if you are some sort of SIII or SV system */

#undef	BCOPY		/* Define if you don't have memcpy and friends - eg:
			   oldish BSD systems */

#undef	UNSIGNEDCHAR	/* Define if chars are unsigned on your machine */

/*	The name of a routine that can be called thusly:
	VFPRINTF(stream, format, ap)
	FILE *stream;
	char *format;
	va_list ap;
    (eg: you have varargs.h and you have a routine functionally compatible
    with System V vfprintf.  I think BSD has one too)

    undef if you don't got, and maybe my fakeout will work.
 */

#define VFPRINTF	vfprintf

/*	Font width file configuration:

	- If HEADERSIZE defined, use that many bytes as a prefix to the
	  compiled font width table.  HEADERSIZE 0 is the correct definition
	  for Xenix and most System V Troffs.  HEADERSIZE=32 works for Ultrix.
	  HEADERSIZE=0 works properly for Suns (I think).
	- If COFF is defined instead, use a COFF header on the beginning of
	  the file.  I personally know of no machine that supports these.
	- If neither are defined, use a BSD/V7 style a.out.h header, this
	  is appropriate for V7 and BSD troffs

    The headers I write out do not have anything in them, so some
    troff's may blow.  Please let me know if they work for you...
    If you do need the headers, and these doesn't work for you, enable
    the COMPILE option in gfnttab.  I know of no troff that *needs*
    COMPILE on.

 */

#define	HEADERSIZE 0	/* size of header in bytes */
#undef	COFF		/* systems using COFF headers */

/* What do your CAT codes look like?

   If BSDHACK defined, the code to magnify the next lead by 64 replaces the
   codes to set the tilt (tilt used only on 8-font CATs, which most CAT troff
   programs don't support).

   Both FONT8 and BSDHACK code are *untested*.  FONT8 probably does *not*
   work.
 */

#undef	BSDHACK		/* Has magnify lead opcode - untested */
#undef	FONT8		/* 8 Font device - untested */
#define FONT4		/* Normal 4 font device */

			/* define a command for decompressing an argument
			   file to stdout - allows you to compress SFP's.
			   undef if you don't got.  The -d option may be
			   undocumented, but means decompress.  "-dc"
			   is equivalent to zcat.  -dc appears to be
			   in most versions of compress (eg: v3 & v4) */
#define	COMPRESS	"/usr/lbin/compress -dc"

/*	Some postscript printers don't accept control-D as job termination
	(DEC scriptwriters for instance).  In that case, define this
	macro.  Alternately, if you have a proper printer manager that
	does this sort of stuff, define it too.
 */
#undef	NOCONTROLD

/*	define if you don't want your Postscript printer talking to you */
#undef	NOCHATTER

/*	The only advantage to commenting-out one of these is to make the
	binary executable of troff2?? smaller.
 */

/*	Basic drivers: */
#define	PS	/* Postscript */
#define	LJ	/* Laserjet */
#define	DT	/* ditroff */

/*	Laserjet driver config: */
#define	PK	/* enable PK font downloading (needs LJ) */

#define	SFP	/* enable SFP incremental font downloading (needs PK).
		   You can still use SFP's without this turned on, but
		   you won't get incremental downloading */

#define	PARTIAL	/* partial (not incremental) font downloading */

#define	INCR	/* enable incremental font downloading (needs PARTIAL) */

#define	MDLF	16	/* Max # downloaded fonts permitted by your laserjet
			   per *page*.  16 is correct for HPLJ+ and most II's.
			   IIP's are 32 I think.  Some newer ones have higher
			   restrictions (don't put this too high even if
			   your printer supports it, you may run out of
			   memory) */

#define	PRELOAD	0	/* set to number of LJ fonts permanently
			   downloaded to printer.  The backend will
			   make sure that you don't go over the number
			   of fonts permitted by the printer */

#define	DEBUG		/* Do you want the debugger in?  If you encounter
			   problems and you want help from me, you'll have
			   to have this turned on */

#define	OPT		/* Experimental code */

#define	DEFPL  11	/* Default page length (11 inches).
			   DO NOT change unless you absolutely HAVE to.
			   You should only need to change this if you
			   desire your printer to use something different
			   as default.  If so, you'll HAVE to change
			   your macro package to agree on the default - RT
			   owners take note! (the man macros are wrong) */

#define	DEFOFF 0.5	/* Default page offset.  DO NOT change unless you
			   absolutely HAVE to.  You should only need this
			   if: your vendor has buggered your macros to
			   have a different default .po offset (Xenix),
			   and you aren't using the macro adapter
			   libraries that come with psroff (eg: you're
			   using troff2ps directly).  See README/TROUBLE/
			   psroff(1) (-O vs. -rO options) */

#define	DEFYOFF   0	/* Default page vertical offset.  See README/TROUBLE/
			   psroff(1) -Y options too */

/*	Edit no more .... */

#define	MAXDLFONTS (MDLF - PRELOAD)	/* # fonts troff2ps can download */

/*	configuration verification */

#if	defined(BSDHACK) && defined(FONT8)
#include	"BSDHACK and FONT8 cannot be defined at the same time"
#endif
#if	defined(FONT4) && defined(FONT8)
#include	"FONT4 and FONT8 cannot be defined at the same time"
#endif

#if	!defined(LJ) && defined(PK)
#include	"Pointless to define PK without LJ"
#endif

#if	!defined(PK) && (defined(INCR) || defined(PARTIAL))
#include	"Pointless to define INCR or PARTIAL without PK"
#endif

#if	defined(INCR) && !defined(PARTIAL)
#include	"Don't support INCR without PARTIAL"
#endif

#if	defined(SFP) && !defined(PK)
#include	"Can't define SFP without PK"
#endif

#include <stdio.h>
#include <ctype.h>

#ifdef BSD
#include <strings.h>
#define	strchr	index
#define	strrchr	rindex
#else
#include <string.h>
#endif

#ifdef	BCOPY
#define	memcpy(to, from, len)	bcopy(from, to, len)
#define	clrarray(array, len)	bzero(array, len)
#else
#define	clrarray(array, len)	memset(array, '\0', len)
#endif

#ifdef	UNSIGNEDCHAR
/* Ah heck, and this is probably not ANSI C either... */
#define	SIGNED(x) (((x)&0x80) ? ((x) - 256) : (x))
#endif

#define	ESC	0x80
#define	FLASH	0x00
#define	CONTROL	0x40
#define	LEAD	0x60
#define	SIZE	0x50

#define	DOWN	0
#define	UP	1
#define	LOWER	2
#define	UPPER	3
#define	FORWARD	4
#define	BACKWARD 5

#define	TROFFRESOLUTION	432

#define	SPECIAL		/* define if you want to supports special directives */
#define	FORM		/* define if you want the forms facility */

FILE	*diagFile;

#ifdef DEBUG
#define	DBP(x)	if (diagFile) dprintf x
extern dprintf();
#else
#define	DBP(x)
#endif

typedef int(*FUNC)();

#define	FNULL	(FUNC) NULL

struct	troff2befont {
	short	t2b_font;	/* font (troff nomenclature) S=don't change */
	short	t2b_xc;		/* X-shift */
	short	t2b_yc;		/* Y-shift */
	short	t2b_scale;	/* point size scale adjust */
	char 	*t2b_charseq;	/* character sequence - may include PS */
};

struct cattab {
    char *ch_name;
    char ch_set;
    unsigned char ch_catidx;
    unsigned char ch_wididx;
    unsigned char ch_info;	/* used by some auxiliary programs */
    char *ch_desc;
};

struct backend {
    char	*bename;
    FUNC	beprolog,
		beepilog,
		beputchar,
		bepage,
		befontsel,	/* special function F */
		beoverlay,	/* special function O */
		bepassthru,	/* special function P */
		bexlat;		/* Xlate function */
    struct troff2befont
		*bestdfont,	/* standard font translate table */
		*besymfont;	/* symbol font translate table */
};

#define	MAXFONTS	50

struct fonttable {
    char *tab[4];
    long flags;
#ifdef	INCR
    struct downmaps *map;
#endif
#ifdef	OPT
    char *widthtable;
#endif
};

/*	Symbolic names for tab entries in fonttable	*/
#define	troffName	tab[0]	/* troff name */
#define	fontName	tab[1]	/* back-end name (if used) */
#define	fontSeq		tab[2]	/* sequence to emit to shift to it
				   lj builtin's mostly */

/*	fontFlags is 16 characters that reflect the state of the font
	at a particular pointsize - mainly for lj */

/*	Use of flags:
	s:	unloaded SFP
	S:	loaded SFP
	p:	unloaded PK
	P:	loaded PK
	n:	non-existant
	b:	builtin.
 */
#define	fontFlags	tab[3]



extern struct fonttable fonttable[MAXFONTS+1];
extern struct fonttable *xlatetable[8];

struct backend *be;
#define	BNULL	(struct backend *) NULL

extern char *skipblanks();

/*	Common Back-end definitions */

#define	N	(unsigned char) (0xff)	/* Use standard font */
#define	S	(unsigned char) (0xfe)	/* Use symbol font */
#define	D	(unsigned char) (0xfd)	/* Draw macro exists - use string directly */
#define	NTC	(unsigned char) (0xfc)	/* No font/Special flag */

#define	NOC	NULL

extern int currentPage;
extern int pageoffset;
extern int pageyoffset;
extern int pagelength;
extern int pagePending;

#ifdef	OPT
extern char *widthtables;
extern char *widthptr;
extern int optimize;
#endif

extern int lastFont, lastPoints;
extern int lastYPos, lastXPos;
extern char *progname, *printer, *device;
extern char **prologs;

int metrics;

FILE *libopen();

/*	Encoding format for generating width tables from font files */
/*	Used by pk2ditwid and friends */
struct enctab {
    char *e_name;
    char *e_seq;
    char e_wid;
};

/*	Points in an inch */
#define	POINT	72.27

#define	min(a,b)	((a) < (b) ? (a) : (b))
#define	max(a,b)	((a) > (b) ? (a) : (b))

/* debug flags */
#define	D_CAT	1
#define	D_SPEC	2
#define	D_CHAR	4
#define	D_FONT	8
#define	D_BEND	0x10
#define	D_PK	0x20
#define	D_VERB	0x40

extern int debug;

extern char username[];

extern char *mustmalloc();

extern char *version, *shortversion;
