/*	Copyright 1985, 1986, 1987, 1988 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		cattab.c
	Author: 	Chris Lewis
	Specs:		CAT Translation tables.

    Notes:
	- There are two tables, one for normal and one for symbol fonts.
	- The CAT code is calculated in the following way from the CAT
	  flash codes (see cat(5L)):
	    1) if lower flash, the code is the flash code minus 1.
	    2) if upper flash, the code is the flash code + 62
	  (codes go from 0 to 107)
	- Some CAT codes are not allocated - they are denoted as "NOC"
	  in the backend translation tables, but NTC here.
	  (the backend translation tables are indexed by CAT code).
	- CAT codes of "NTC" in this table are "pseudo characters" which
	  are here so that a width entry index can be specified.  For example,
	  "-" and \(hy are really the *same* CAT code, but have different
	  widths.  Ditto _ and \ul.  Another is that space isn't really
	  a character, but you gotta put its width somewhere.
	- The width table index is the offset from the beginning of the
	  table (eg: not including any headers that your troff may
	  require).
	- This table is primarily used for debugging and auxiliary purposes
	  and is scanned at most once per troff2ps run (-z dumps, during
	  *.fonts loading, and possibly in LJ w.r.t. font downloading), but
	  other programs use it more extensively.  The backends have
	  the tables that are referenced on each character to obtain
	  printer-specific translations.
 */


#ifndef lint
static char SCCSid[] =
    "@(#)cattab.c: 2.1 Copyright 90/07/18 16:52:56 Chris Lewis";
#endif

#include "defs.h"

/*	 +------------------------------------	Troff character name
	 |                                      (NOC means no character only
	 |					used here to terminate list)
	 |
	 |	+-----------------------------	N: standard font
	 |	|                             	S: symbol font
	 |	|
	 |	|    +------------------------	CAT Output Code table index
	 |	|    |				(must be sorted on this field!)
	 |	|    |
	 |	|    |    +-------------------	Width table index
	 |	|    |    |
	 |	|    |    |  +----------------	Dummy used by dit2catwid
	 |	|    |    |  |
	 |	|    |    |  |   +------------	Character description.
	 |	|    |    |  |   |
	 v	v    v    v  v   v	*/

struct cattab tabN[] = {
	{"h",	N,   0,  72, 0, "h"},
	{"t",	N,   1,  84, 0, "t"},
	{"n",	N,   2,  78, 0, "n"},
	{"m",	N,   3,  77, 0, "m"},
	{"l",	N,   4,  76, 0, "l"},
	{"i",	N,   5,  73, 0, "i"},
	{"z",	N,   6,  90, 0, "z"},
	{"s",	N,   7,  83, 0, "s"},
	{"d",	N,   8,  68, 0, "d"},
	{"b",	N,   9,  66, 0, "b"},
	{"x",	N,  10,  88, 0, "x"},
	{"f",	N,  11,  70, 0, "f"},
	{"j",	N,  12,  74, 0, "j"},
	{"u",	N,  13,  85, 0, "u"},
	{"k",	N,  14,  75, 0, "k"},
	{"",	N,  15,  -1, 0, NOC},
	{"p",	N,  16,  80, 0, "p"},
	{"em",	N,  17,  99, 0, "3/4 em"},
	{";",	N,  18,  27, 0, ";"},
	{"",	N,  19,  -1, 0, NOC},
	{"a",	N,  20,  65, 0, "a"},
	{"ru",	N,  21, 100, 0, "horizontal rule"},
	{"c",	N,  22,  67, 0, "c"},
	{"`",	N,  23,  64, 0, "` open"},
	{"e",	N,  24,  69, 0, "e"},
	{"'",	N,  25,   7, 0, "' close"},
	{"o",	N,  26,  79, 0, "o"},
	{"14",	N,  27, 101, 0, "1/4"},
	{"r",	N,  28,  82, 0, "r"},
	{"12",	N,  29, 102, 0, "1/2"},
	{"v",	N,  30,  86, 0, "v"},
	{"hy",	N,  31,  96, 0, "hy hyphen"},
	{"w",	N,  32,  87, 0, "w"},
	{"q",	N,  33,  81, 0, "q"},
	{"/",	N,  34,  15, 0, "/"},
	{".",	N,  35,  14, 0, "."},
	{"g",	N,  36,  71, 0, "g"},
	{"34",	N,  37, 103, 0, "3/4"},
	{",",	N,  38,  12, 0, ","},
	{"&",	N,  39,   6, 0, "&"},
	{"y",	N,  40,  89, 0, "y"},
	{"",	N,  41,  -1, 0, NOC},
	{"%",	N,  42,   5, 0, "%"},
	{"",	N,  43,  -1, 0, NOC},
	{"Q",	N,  44,  49, 0, "Q"},
	{"T",	N,  45,  52, 0, "T"},
	{"O",	N,  46,  47, 0, "O"},
	{"H",	N,  47,  40, 0, "H"},
	{"N",	N,  48,  46, 0, "N"},
	{"M",	N,  49,  45, 0, "M"},
	{"L",	N,  50,  44, 0, "L"},
	{"R",	N,  51,  50, 0, "R"},
	{"G",	N,  52,  39, 0, "G"},
	{"I",	N,  53,  41, 0, "I"},
	{"P",	N,  54,  48, 0, "P"},
	{"C",	N,  55,  35, 0, "C"},
	{"V",	N,  56,  54, 0, "V"},
	{"E",	N,  57,  37, 0, "E"},
	{"Z",	N,  58,  58, 0, "Z"},
	{"D",	N,  59,  36, 0, "D"},
	{"B",	N,  60,  34, 0, "B"},
	{"S",	N,  61,  51, 0, "S"},
	{"Y",	N,  62,  57, 0, "Y"},
	{"F",	N,  63,  38, 0, "F"},
	{"X",	N,  64,  56, 0, "X"},
	{"A",	N,  65,  33, 0, "A"},
	{"W",	N,  66,  55, 0, "W"},
	{"J",	N,  67,  42, 0, "J"},
	{"U",	N,  68,  53, 0, "U"},
	{"K",	N,  69,  43, 0, "K"},
	{"0",	N,  70,  16, 0, "0"},
	{"1",	N,  71,  17, 0, "1"},
	{"2",	N,  72,  18, 0, "2"},
	{"3",	N,  73,  19, 0, "3"},
	{"4",	N,  74,  20, 0, "4"},
	{"5",	N,  75,  21, 0, "5"},
	{"6",	N,  76,  22, 0, "6"},
	{"7",	N,  77,  23, 0, "7"},
	{"8",	N,  78,  24, 0, "8"},
	{"9",	N,  79,  25, 0, "9"},
	{"*",	N,  80,  10, 0, "*"},
	{"\\-", N,  81, 104, 0, "minus"},
	{"fi",	N,  82, 105, 0, "fi"},
	{"fl",	N,  83, 106, 0, "fl"},
	{"ff",	N,  84, 107, 0, "ff"},
	{"ct",	N,  85, 192, 0, "cent sign"},
	{"Fl",	N,  86, 109, 0, "ffl"},
	{"Fi",	N,  87, 108, 0, "ffi"},
	{"(",	N,  88,   8, 0, "("},
	{")",	N,  89,   9, 0, ")"},
	{"[",	N,  90,  59, 0, "["},
	{"]",	N,  91,  61, 0, "]"},
	{"de",	N,  92, 110, 0, "degree"},
	{"dg",	N,  93, 111, 0, "dagger"},
	{"=",	N,  94,  29, 0, "="},
	{"rg",	N,  95, 189, 0, "registered"},
	{":",	N,  96,  26, 0, ":"},
	{"+",	N,  97,  11, 0, "+"},
	{"",	N,  98,  -1, 0, NOC},
	{"!",	N,  99,   1, 0, "!"},
	{"bu",	N, 100,  97, 0, "bullet"},
	{"?",	N, 101,  31, 0, "?"},
	{"fm",	N, 102, 113, 0, "foot mark (minute)"},
	{"|",	N, 103,  92, 0, "|"},
	{"",	N, 104,  -1, 0, NOC},
	{"co",	N, 105, 190, 0, "copyright"},
	{"sq",	N, 106,  98, 0, "square"},
	{"$",	N, 107,   4, 0, "$"},
	{" ",	N, NTC,   0, 0, "space"},
	{"\\|",	N, NTC,  95, 0, "narrow space"},
	{"\\^",	N, NTC, 118, 0, "half narrow space"},
	{"-",   N, NTC,  13, 0, "hyphen character"},
	{NOC}
};

struct cattab tabS[] = {
	{"*q",	S,   0, 142, 0, "psi"},
	{"*h",	S,   1, 127, 0, "theta"},
	{"*n",	S,   2, 132, 0, "nu"},
	{"*m",	S,   3, 131, 0, "mu"},
	{"*l",	S,   4, 130, 0, "lambda"},
	{"*i",	S,   5, 128, 0, "iota"},
	{"*z",	S,   6, 125, 0, "zeta"},
	{"*s",	S,   7, 137, 0, "sigma"},
	{"*d",	S,   8, 123, 0, "delta"},
	{"*b",	S,   9, 121, 0, "beta"},
	{"*c",	S,  10, 133, 0, "xi"},
	{"*y",	S,  11, 126, 0, "eta"},
	{"*f",	S,  12, 140, 0, "phi"},
	{"*u",	S,  13, 139, 0, "upsilon"},
	{"*k",	S,  14, 129, 0, "kappa"},
	{"",	S,  15,  -1, 0, NOC},
	{"*p",	S,  16, 135, 0, "pi"},
	{"@",	S,  17,  32, 0, "@"},
	{"da",	S,  18, 169, 0, "down arrow"},
	{"",	S,  19,  -1, 0, NOC},
	{"*a",	S,  20, 120, 0, "alpha"},
	{"or",	S,  21, 198, 0, "or (was star)"},
	{"*x",	S,  22, 141, 0, "chi"},
	{"\"",	S,  23,   2, 0, "double quote"},
	{"*e",	S,  24, 124, 0, "epsilon"},
	{"eq",	S,  25, 170, 0, "equation equal"},
	{"*o",	S,  26, 134, 0, "omicron"},
	{"<-",	S,  27, 167, 0, "left arrow"},
	{"*r",	S,  28, 136, 0, "rho"},
	{"ua",	S,  29, 168, 0, "up arrow"},
	{"*t",	S,  30, 138, 0, "tau"},
	{"ul",	S,  31, 116, 0, "ul"},
	{"\\",	S,  32,  60, 0, "back slash"},
	{"*Q",	S,  33, 154, 0, "Psi"},
	{"bs",	S,  34, 197, 0, "bell system sign"},
	{"if",	S,  35, 180, 0, "infinity"},
	{"*g",	S,  36, 122, 0, "gamma"},
	{"ip",	S,  37, 179, 0, "improper superset"},
	{"pt",	S,  38, 185, 0, "proportional to"},
	{"rh",	S,  39, 194, 0, "right hand"},
	{"*w",	S,  40, 143, 0, "omega"},
	{"",	S,  41,  -1, 0, NOC},
	{"gr",	S,  42, 182, 0, "gradient"},
	{"",	S,  43,  -1, 0, NOC},
	{"*F",	S,  44, 153, 0, "Phi"},
	{"*H",	S,  45, 146, 0, "Theta"},
	{"*W",	S,  46, 155, 0, "Omega"},
	{"cu",	S,  47, 174, 0, "union"},
	{"rn",	S,  48, 158, 0, "root en"},
	{"ts",	S,  49, 157, 0, "terminal sigma"},
	{"*L",	S,  50, 147, 0, "Lambda"},
	{"mi",	S,  51, 162, 0, "equation minus"},
	{"*G",	S,  52, 144, 0, "Gamma"},
	{"is",	S,  53, 184, 0, "integral sign"},
	{"*P",	S,  54, 149, 0, "Pi"},
	{"sb",	S,  55, 176, 0, "subset of"},
	{"sp",	S,  56, 177, 0, "superset of"},
	{"ap",	S,  57, 164, 0, "approximates"},
	{"pd",	S,  58, 181, 0, "partial derivative"},
	{"*D",	S,  59, 145, 0, "Delta"},
	{"sr",	S,  60, 156, 0, "square root"},
	{"*S",	S,  61, 150, 0, "Sigma"},
	{"~=",	S,  62, 163, 0, "approx ="},
	{">",	S,  63,  30, 0, ">"},
	{"*C",	S,  64, 148, 0, "Xi"},
	{"<",	S,  65,  28, 0, "<"},
	{"sl",	S,  66, 117, 0, "slash"},
	{"ca",	S,  67, 175, 0, "intersect"},
	{"*U",	S,  68, 152, 0, "Upsilon"},
	{"no",	S,  69, 183, 0, "logical not"},
	{"rc",	S,  70, 210, 0, "right ceiling"},
	{"lt",	S,  71, 200, 0, "left top brace"},
	{"bv",	S,  72, 206, 0, "bold vertical"},
	{"lk",	S,  73, 204, 0, "left ctr brace"},
	{"lb",	S,  74, 201, 0, "left bot brace"},
	{"rt",	S,  75, 202, 0, "right top brace"},
	{"rk",	S,  76, 205, 0, "right ctr brace"},
	{"rb",	S,  77, 203, 0, "right bot brace"},
	{"rf",	S,  78, 208, 0, "right floor"},
	{"lf",	S,  79, 207, 0, "left floor"},
	{"lc",	S,  80, 209, 0, "left ceiling"},
	{"mu",	S,  81, 171, 0, "multiply"},
	{"di",	S,  82, 172, 0, "divide"},
	{"+-",	S,  83, 173, 0, "plus-minus"},
	{"<=",	S,  84, 160, 0, "<="},
	{">=",	S,  85, 159, 0, ">="},
	{"==",	S,  86, 161, 0, "identically equal"},
	{"!=",	S,  87, 165, 0, "not equal"},
	{"{",	S,  88,  91, 0, "{"},
	{"}",	S,  89,  93, 0, "}"},
	{"aa",	S,  90, 114, 0, "acute accent"},
	{"ga",	S,  91, 115, 0, "grave accent"},
	{"^",	S,  92,  62, 0, "^"},
	{"#",	S,  93,   3, 0, "#"},
	{"lh",	S,  94, 195, 0, "left hand"},
	{"mo",	S,  95, 187, 0, "member of"},
	{"~",	S,  96,  94, 0, "~"},
	{"es",	S,  97, 186, 0, "empty set"},
	{"",	S,  98,  -1, 0, NOC},
	{"dd",	S,  99, 193, 0, "dbl dagger"},
	{"br",	S, 100, 191, 0, "box rule (was parallel sign)"},
	{"**",	S, 101, 196, 0, "math *"},
	{"ib",	S, 102, 178, 0, "improper subset"},
	{"ci",	S, 103, 199, 0, "circle"},
	{"",	S, 104, -1, 0, NOC},
	{"pl",	S, 105, 188, 0, "equation plus"},
	{"->",	S, 106, 166, 0, "right arrow"},
	{"sc",	S, 107, 112, 0, "section"},
	{"_",	S, NTC,  63, 0, "_"},
	{NOC}
};
