/*	Copyright 1985, 1986, 1987, 1988 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		psxlate.c
	Author: 	Chris Lewis
	Specs:		Generic Postscript filter (page reversal etc.)
 */

#ifndef	lint
static char SCCSid[] =
    "@(#)psxlate.c: 2.1 Copyright 90/07/18 16:49:52 Chris Lewis";
#endif

#include "defs.h"

int	xlate = 0;
#define	MAXPAGE	1000
#define	BUFFERSIZE	512

/* define if you want to page flip %! documents (eg: some TeX out stuff)
   not recommended....
 */
#undef	TRYPERBANG

struct headers {
    char *hptr;
    struct headers *next;
};

struct pagedesc {
    unsigned long start;
    unsigned long end;
    char *type;
    struct headers *comments;
} pageidx[MAXPAGE];

char *tmp = "/tmp/psxXXXXXX";
int page = 0;
char *progname;
int debug, verbose;


main(argc, argv)
int argc; char **argv; {
    extern int optind;
    char buffer[BUFFERSIZE];
    int c;
    progname = argv[0];
    while ((c = getopt(argc, argv, "drxv")) != EOF)
	switch(c) {
	    case 'r': xlate = 0; break;
	    case 'x': xlate = 1; break;
	    case 'd': debug = 1; break;
	    case 'v': verbose = 1; break;
	    default:
		usage();
		exit(1);
	}
    if (fgets(buffer, BUFFERSIZE, stdin)) {
	if (strncmp(buffer, "%!PS-Adobe-", 11) == 0) {
	    if (verbose)
		fprintf(stderr, "DEBUG: conformant file %s\n", buffer);
	    mktemp(tmp);
	    scan(stdin, tmp, buffer);
	    transform();
	    emit(tmp);
#ifdef	TRYPERBANG
	} else if (strncmp(buffer, "%!", 2) == 0) {
	    if (verbose)
		fprintf(stderr, "DEBUG: hopefully conformant file %s\n", buffer);
	    mktemp(tmp);
	    scan(stdin, tmp, buffer);
	    transform();
	    emit(tmp);
#endif
	} else {
	    if (verbose)
		fprintf(stderr, "DEBUG: nonconformant file %s\n", buffer);
	    fputs(buffer, stdout);
	    while ((c = fread(buffer, 1, sizeof(buffer), stdin)) > 0)
		fwrite(buffer, 1, c, stdout);
	}
    }
    if (!debug)
	cleanup();
    exit(0);
}

scan(f, file, buffer)
FILE *f;
char *file, *buffer; {
    FILE *t;
    extern char *malloc();
    int state = 1;
    long ind = 0;
    int c;

    if ((t = fopen(file, "w")) == NULL) {
	fprintf(stderr, "Cannot open temporary file %s\n", file);
	exit(1);
    }
    fputs(buffer, t);
    ind += strlen(buffer);
    pageidx[page].start = 0;
    strcpy(pageidx[page].type = malloc(strlen(buffer)+1), buffer);
    add(page, buffer);
    page = 1;
    while((c = getc(f)) != EOF) {
	putc(c, t);
	ind++;
	switch(state) {
	    case 0:
		if (c == '\n') {
		    state = 1;
		}
		break;
	    case 1:	/* seen \n */
		if (c == '%') {
		    fgets(buffer, BUFFERSIZE, f);
		    fputs(buffer, t);
		    if (0 == strncmp(buffer, "%Page:", 6) ||
			0 == strncmp(buffer, "%Page ", 6) ||
			0 == strncmp(buffer, "%Trailer", 8)) {
			pageidx[page-1].end = ind - 2;
			pageidx[page].start = ind - 1;
			strcpy(pageidx[page].type = malloc(strlen(buffer)+1),
			    buffer);
			add(page, buffer);
			page++;
		    } else
			add(page, buffer);
		    ind += strlen(buffer);
		    break;
		}
		state = 0;
		break;
	}
    }
    if (page)
	pageidx[page-1].end = ind - 1;
    fclose(t);
}

cleanup() {
    unlink(tmp);
}

emit(file)
char *file; {
    FILE *t;
    register int i;
    if ((t = fopen(file, "r")) == NULL) {
	fprintf(stderr, "Panic\n");
	exit(1);
    }
    for(i = 0; i < page; i++) {
	register long start, end, cnt;
	register int c;

	start = pageidx[i].start;
	end = pageidx[i].end;
	cnt = end - start + 1;
	fseek(t, start, 0);
	while(cnt--)
	    putchar(getc(t));
    }
}


usage() {
    fprintf(stderr, "Usage: %s [-r|-x] < file > file\n", progname);
}

dumppg() {
    register int i;
    register struct headers *h;
    if (debug) {
	for (i = 0; i < page; i++) {
	    fprintf(stderr, "Page: %d %d %d %s\n", i, pageidx[i].start,
		pageidx[i].end, pageidx[i].type);
	    for (h = pageidx[i].comments; h; h=h->next)
		fprintf(stderr, "  %s", h->hptr);
	}
    }
}

transform() {
    dumppg();
    switch(xlate) {
	case 0:
	    revpages();
	    break;
	case 1:
	    xpages();
	    break;
    }
    dumppg();
}

fstart() {
    register int i;
    for (i = 0; i < page; i++)
	if (0 == strncmp(pageidx[i].type, "%Page", 5))
	    break;
    return(i);
}
fend() {
    register int i;
    for (i = page-1; i >= 0; i--)
	if (0 == strncmp(pageidx[i].type, "%Page:", 5))
	    break;
    return(i);
}

revpages() {
    register int i, j;
    struct pagedesc t;
    i = fstart();

    if (i == page)
	return;

    j = fend();

    while(i < j) {
	t = pageidx[i];
	pageidx[i] = pageidx[j];
	pageidx[j] = t;
	i++;j--;
    }
}

xpages() {
    register int i, j, mid, first, last;
    struct pagedesc t;
    struct pagedesc *p =
	(struct pagedesc *) malloc(sizeof(struct pagedesc) * page);
    revpages();
    first = fstart();

    if (first == page)
	return;

    last = fend();

    if (debug)
	fprintf(stderr, "first: %d, last: %d, page: %d\n", first, last, page);
    if ((last - first + 1) < 3)
	return;

    if (first)
	memcpy(p, pageidx, sizeof(struct pagedesc) * first);	/* prolog */
    if (page - last)	/* copy epilog */
	memcpy(p+last+1,
	    &pageidx[last+1], sizeof(struct pagedesc) * (page - last - 1));
    mid = (last + first + 1) / 2 ;	/* offset of middle */
    for (i = first; i < mid; i++)
	p[first + (i - first) * 2] = pageidx[i];
    for (i = mid; i <= last; i++)
	p[first + (i - mid) * 2 + 1] = pageidx[i];
    memcpy(pageidx, p, sizeof(struct pagedesc) * page);
    free(p);
}

add(page, buf)
int page; char *buf; {
    struct headers *hdr, *hp, *ohp;
    extern char *malloc();
    char *p;
    if (debug)
	fprintf(stderr, "Adding %s\n", buf);
    hdr = (struct headers *) malloc(sizeof(struct headers));
    if (hdr == 0 || !(hdr->hptr = malloc(strlen(buf) + 2))) {
	fprintf(stderr, "psxlate: Out of space\n");
	exit(1);
    }
    strcpy(hdr->hptr, "%");
    strcat(hdr->hptr, buf);
    hdr->next = NULL;
    for (ohp = hp = pageidx[page].comments; ; hp = hp->next) {
	if (!hp) {
	    if (ohp == pageidx[page].comments)
		pageidx[page].comments = hdr;
	    else
		ohp->next = hdr;
	    break;
	}
	ohp = hp;
    }
    return;
}
