%%STARTSHELL%%
#	Most of this program was written by Michael Rourke (see below)
#	to generate ditroff width tables from Postscript.  The original
#	name (as distributed in tpscript) was genftable.  It has been
#	extended to support more fonts than the original, plus attempt
#	to handle non-builtin fonts.  This shell script's output should
#	be sent to your postscript printer, and the printer will send
#	back up the serial link a series of shars containing the
#	width tables.
#
#	The program goes through all existing characters in the font
#	to print width information in ditroff format.  The name of each
#	character's drawing routine is used to look up how to print the
#	width information.  There are three tables: the standard-encoding,
#	symbol-encoding and ascii-map.  The first two are dictionaries,
#	the third is an array.  If the font you've asked for is "Symbol",
#	the symbol-encoding dictionary is used, otherwise standard-encoding.
#	If the drawing routine isn't in the selected dictionary, the
#	character code is used to look up in ascii-map for a new name.
#	The new name is then searched for in standard-encoding to print the
#	width information.
#
#	This latter kludge is necessary for fonts that don't use the
#	standard naming conventions, and will work sanely only for characters
#	32 (space) thru 126 (tilde).
#
#	usage: psdtwd <arguments>
#
#	if there are no arguments, pstdwd will generate widths for
#	all of the fonts that are listed at the end of this shell
#	script.  Arguments are usually repeated quoted
#	strings of the form:
#		/psname /intname /catname fontinfo
#	Where psname is the Postscript name of the font.  intname is
#	a shortened name (which psroff doesn't care about, but ditroff
#	does apparently), catname is the one or two character name that
#	cat will know it by (and will be the name of the resultant shar),
#	and fontinfo is itself.
#	If the argument is a readable filename instead, it is inserted.
#	For example:
#	./psdtwd hwfont "/HaeberliWriting /HaeberliW /HW fontinfo" \
#		"/Times-Roman /Roman /R fontinfo"
#	will insert file hwfont (usually containing the definition of the
#	subsequent argument), and generate the widths in a file HW of
#	the HaeberliWriting font, plus the widths for the "Times-Roman"
#	font in R.
if [ $# = 0 ]
then
    all=1
else
    while [ $# != 0 ]
    do
	if [ -r $1 ]
	then
	    files="$files $1"
	else
	    lines="$lines $1"
	fi
	shift
    done
fi
cat <<'END'
%!
% psdtwd -    Postcript program to produce font tables for ditroff.
%	      Tables are output on the standard output file - which
%	      needs to be captured by the host computer.
%
%	      Note the routine "commondefs" which outputs local
%	      defined (hand built) characters.
%
% Michael Rourke, University of N.S.W., Australia
% (included in troff2: 2.1 90/07/18)
/SAVEOBJ save def

/t 30 string def

(Starting psdtwd.ps `date`\n) print
flush

/ps
% string ->
{
	print
} def

/pr
% any -->
{
	t cvs ps
} def

/prsp
{
	(\t) ps
} def

/prnl
{
	(\n) ps
} def

/pro
% int -->
{
	dup 0 eq
	{ pr }
	{ dup 8 idiv pro 8 mod pr }
	ifelse
} def

/charsize
% string --> bot top
{
	gsave
	newpath 0 0 moveto false charpath flattenpath pathbbox
	exch pop 3 -1 roll pop
	grestore
} def

/strwidth
% string --> width
{
	stringwidth pop round cvi
} def

/prsize
% string -->
{
	dup strwidth pr prsp
	dup charsize
	top gt { 2 } { 0 } ifelse
	exch bot lt { 1 or } if
	pr prsp
	0 get pro
} def

/fontinfo
% fontname troffinternal troffname
{
	(\ncat <<"!" > ) ps dup pr prnl
	(# ) ps 2 index pr prnl
	(name ) ps pr prnl
	(internalname ) ps pr prnl
	dup findfont 100 scalefont setfont
	/fixedwidth false def
	/Symbol eq
	{
		/actions symbol-encoding def
		(special\n) ps
	}
	{
		/actions standard-encoding def
		currentfont /FontInfo get /isFixedPitch get
		{
			(# fixed width\n) ps
			/fixedwidth true def
		}
		{
			(ligatures fi fl ff ffi ffl 0\n) ps
		}
		ifelse
	}
	ifelse
	% use "o" to get top and bottom on a normal char
	(o) charsize /top exch def /bot exch def
	% some non ascending chars slightly higher than "o"
	% and some lower so adjust slightly
	/top top 2 add def
	/bot bot 4 sub def
	/encoding currentfont /Encoding get def
	/s 1 string def
	0 1 255
	{
		dup /id exch def
		s 0 2 index put
		encoding exch get dup /.notdef ne
		{
			s 1 index actions exch
			% actions charfuncname
			2 copy known
			{
				get
				% charname charstr /type
				exec
				flush
			}
			{
				% actions charfuncname
				pop
				ascii-map id get
				2 copy known
				{
					get
					% charname charstr /type
					exec
					flush
				}
				{
					% charname charstr
					pop
					pop
				}
				ifelse
			}
			ifelse
		}
		{
			pop
		}
		ifelse
	} for
	actions standard-encoding eq { commondefs } if
	(!\n) ps flush
} def

/commondefs
{
	/fracsize (0) strwidth (\244) strwidth add def		% \244 = '/'
	/Fisize (f) strwidth (\256) strwidth add 5 sub def	% \256 = 'fi'
	/ffsize (f) strwidth 2 mul 5 sub def
	/fl { flush } def
	fixedwidth not
	{
		(ff) ps prsp ffsize pr (\t2\t0100\tff ligature - faked\n) ps fl
		(Fi) ps prsp Fisize pr (\t2\t0100\tffi ligature - faked\n) ps fl
		(Fl) ps prsp Fisize pr (\t2\t0100\tffl ligature - faked\n) ps fl
	} if
	(12) ps prsp fracsize pr (\t2\t0100\t1/2 - faked\n) ps fl
	(13) ps prsp fracsize pr (\t2\t0100\t1/3 - faked\n) ps fl
	(14) ps prsp fracsize pr (\t2\t0100\t1/4 - faked\n) ps fl
	(18) ps prsp fracsize pr (\t2\t0100\t1/8 - faked\n) ps fl
	(23) ps prsp fracsize pr (\t2\t0100\t2/3 - faked\n) ps fl
	(34) ps prsp fracsize pr (\t2\t0100\t3/4 - faked\n) ps fl
	(38) ps prsp fracsize pr (\t2\t0100\t3/8 - faked\n) ps fl
	(58) ps prsp fracsize pr (\t2\t0100\t5/8 - faked\n) ps fl
	(78) ps prsp fracsize pr (\t2\t0100\t7/8 - faked\n) ps fl
	(sq\t100\t3\t0100\tsquare box - faked\n) ps fl
} def

/space
% charname charstr -->
{
	(spacewidth ) ps
	strwidth pr pop prnl
	(charset\n) ps
} def

/norm
% charname charstr -->
{
	dup pr prsp prsize pop prnl
} def

/normdup
% charname charstr dupname -->
{
	3 1 roll norm
	pr prsp (") ps prnl
} def

/gnorm
% charname charstr -->
{
	(*) ps norm
} def

/map
% charname charstr mapname -->
{
	pr prsp prsize prsp pr prnl
} def

/mapdup
% charname charstr mapname dupname -->
{
	4 1 roll map
	pr prsp (") ps prnl
} def

/mapdupdup
% charname charstr mapname dupname dupname -->
{
	5 1 roll mapdup
	pr prsp (") ps prnl
} def

/cmap
% charname charstr mapname -->
{
	fixedwidth { 3 { pop } repeat } { map } ifelse
} def

/ascii-map 256 array def
0 1 255 {ascii-map exch /exclam put} for

ascii-map 32 /space put
ascii-map 33 /exclam put
ascii-map 34 /quotedbl put
ascii-map 35 /numbersign put
ascii-map 36 /dollar put
ascii-map 37 /percent put
ascii-map 38 /ampersand put
ascii-map 39 /quoteright put
ascii-map 40 /parenleft put
ascii-map 41 /parenright put
ascii-map 42 /asterisk put
ascii-map 43 /plus put
ascii-map 44 /comma put
ascii-map 45 /hyphen put
ascii-map 46 /period put
ascii-map 47 /slash put
ascii-map 48 /zero put
ascii-map 49 /one put
ascii-map 50 /two put
ascii-map 51 /three put
ascii-map 52 /four put
ascii-map 53 /five put
ascii-map 54 /six put
ascii-map 55 /seven put
ascii-map 56 /eight put
ascii-map 57 /nine put
ascii-map 58 /colon put
ascii-map 59 /semicolon put
ascii-map 60 /less put
ascii-map 61 /equal put
ascii-map 62 /greater put
ascii-map 63 /question put
ascii-map 64 /at put
ascii-map 65 /A put
ascii-map 66 /B put
ascii-map 67 /C put
ascii-map 68 /D put
ascii-map 69 /E put
ascii-map 70 /F put
ascii-map 71 /G put
ascii-map 72 /H put
ascii-map 73 /I put
ascii-map 74 /J put
ascii-map 75 /K put
ascii-map 76 /L put
ascii-map 77 /M put
ascii-map 78 /N put
ascii-map 79 /O put
ascii-map 80 /P put
ascii-map 81 /Q put
ascii-map 82 /R put
ascii-map 83 /S put
ascii-map 84 /T put
ascii-map 85 /U put
ascii-map 86 /V put
ascii-map 87 /W put
ascii-map 88 /X put
ascii-map 89 /Y put
ascii-map 90 /Z put
ascii-map 91 /bracketleft put
ascii-map 92 /backslash put
ascii-map 93 /bracketright put
ascii-map 94 /asciicircum put
ascii-map 95 /underscore put
ascii-map 96 /quoteleft put
ascii-map 97 /a put
ascii-map 98 /b put
ascii-map 99 /c put
ascii-map 100 /d put
ascii-map 101 /e put
ascii-map 102 /f put
ascii-map 103 /g put
ascii-map 104 /h put
ascii-map 105 /i put
ascii-map 106 /j put
ascii-map 107 /k put
ascii-map 108 /l put
ascii-map 109 /m put
ascii-map 110 /n put
ascii-map 111 /o put
ascii-map 112 /p put
ascii-map 113 /q put
ascii-map 114 /r put
ascii-map 115 /s put
ascii-map 116 /t put
ascii-map 117 /u put
ascii-map 118 /v put
ascii-map 119 /w put
ascii-map 120 /x put
ascii-map 121 /y put
ascii-map 122 /z put
ascii-map 123 /braceleft put
ascii-map 124 /bar put
ascii-map 125 /braceright put
ascii-map 126 /asciitilde put

/standard-encoding 149 dict def
standard-encoding begin
	/space		{ space }		def
	/exclam		{ norm }		def
	/quotedbl	{ norm }		def
	/numbersign	{ norm }		def
	/dollar		{ norm }		def
	/percent	{ norm }		def
	/ampersand	{ norm }		def
	/quoteright	{ norm }		def
	/parenleft	{ norm }		def
	/parenright	{ norm }		def
	/asterisk	{ norm }		def
	/plus		{ norm }		def
	/comma		{ norm }		def
	/hyphen		{ (hy) normdup }	def
	/period		{ norm }		def
	/slash		{ (sl) dup }		def
	/zero		{ norm }		def
	/one		{ norm }		def
	/two		{ norm }		def
	/three		{ norm }		def
	/four		{ norm }		def
	/five		{ norm }		def
	/six		{ norm }		def
	/seven		{ norm }		def
	/eight		{ norm }		def
	/nine		{ norm }		def
	/colon		{ norm }		def
	/semicolon	{ norm }		def
	/less		{ norm }		def
	/equal		{ norm }		def
	/greater	{ norm }		def
	/question	{ norm }		def
	/at		{ norm }		def
	/A		{ norm }		def
	/B		{ norm }		def
	/C		{ norm }		def
	/D		{ norm }		def
	/E		{ norm }		def
	/F		{ norm }		def
	/G		{ norm }		def
	/H		{ norm }		def
	/I		{ norm }		def
	/J		{ norm }		def
	/K		{ norm }		def
	/L		{ norm }		def
	/M		{ norm }		def
	/N		{ norm }		def
	/O		{ norm }		def
	/P		{ norm }		def
	/Q		{ norm }		def
	/R		{ norm }		def
	/S		{ norm }		def
	/T		{ norm }		def
	/U		{ norm }		def
	/V		{ norm }		def
	/W		{ norm }		def
	/X		{ norm }		def
	/Y		{ norm }		def
	/Z		{ norm }		def
	/bracketleft	{ norm }		def
	/backslash	{ norm }		def
	/bracketright	{ norm }		def
	/asciicircum	{ (a^) map }		def
	/underscore	{ (ru) normdup }	def
	/quoteleft	{ norm }		def
	/a		{ norm }		def
	/b		{ norm }		def
	/c		{ norm }		def
	/d		{ norm }		def
	/e		{ norm }		def
	/f		{ norm }		def
	/g		{ norm }		def
	/h		{ norm }		def
	/i		{ norm }		def
	/j		{ norm }		def
	/k		{ norm }		def
	/l		{ norm }		def
	/m		{ norm }		def
	/n		{ norm }		def
	/o		{ norm }		def
	/p		{ norm }		def
	/q		{ norm }		def
	/r		{ norm }		def
	/s		{ norm }		def
	/t		{ norm }		def
	/u		{ norm }		def
	/v		{ norm }		def
	/w		{ norm }		def
	/x		{ norm }		def
	/y		{ norm }		def
	/z		{ norm }		def
	/braceleft	{ norm }		def
	/bar		{ norm }		def
	/braceright	{ norm }		def
	/asciitilde	{ (a~) map }		def
	/exclamdown	{ (I!) map }		def
	/cent		{ (ct) map }		def
	/sterling	{ (po) map }		def
	/fraction	{ }			def
	/yen		{ ($J) map }		def
	/florin		{ }			def
	/section	{ (sc) map }		def
	/currency	{ }			def
	/quotesingle	{ (fm) (n') mapdup }	def
	/quotedblleft	{ (lq) map }		def
	/guillemotleft	{ (d<) map }		def
	/guilsinglleft	{ (l<) map }		def
	/guilsinglright	{ (r>) map }		def
	/fi		{ (fi) cmap }		def
	/fl		{ (fl) cmap }		def
	/endash		{ (\\-) map }		def
	/dagger		{ (dg) map }		def
	/daggerdbl	{ (dd) map }		def
	/periodcentered	{ }			def
	/paragraph	{ (pp) map }		def
	/bullet		{ (bu) map }		def
	/quotesinglbase	{ } 			def
	/quotedblbase	{ }			def
	/quotedblright	{ (rq) map }		def
	/guillemotright	{ (d>) map }		def
	/ellipsis	{ }			def
	/perthousand	{ (pm) cmap }		def
	/questiondown	{ (I?) map }		def
	/grave		{ (ga) (\\`) mapdup }	def
	/acute		{ (aa) (\\') mapdup }	def
	/circumflex	{ (^) map }		def
	/tilde		{ (~) map }		def
	/macron		{ (ma) map }		def
	/breve		{ (be) map }		def
	/dotaccent	{ (dt) map }		def
	/dieresis	{ (..) (um) mapdup }	def
	/ring		{ (ri) map }		def
	/cedilla	{ (cd) map }		def
	/hungarumlaut	{ ('') map }		def
	/ogonek		{ (og) map }		def
	/caron		{ (hc) map }		def
	/emdash		{ (em) map }		def
	/AE		{ (AE) cmap }		def
	/ordfeminine	{ }			def
	/Lslash		{ (PL) map }		def
	/Oslash		{ (O/) map }		def
	/OE		{ (OE) cmap }		def
	/ordmasculine	{ }			def
	/ae		{ (ae) cmap }		def
	/dotlessi	{ (ui) map }		def
	/lslash		{ (Pl) map }		def
	/oslash		{ (o/) map }		def
	/oe		{ (oe) cmap }		def
	/germandbls	{ (ss) map }		def
end

/symbol-encoding 189 dict def
symbol-encoding begin
	/space		{ space }		def
	/exclam		{ norm }		def
	/universal	{ (fa) map }		def
	/numbersign	{ norm }		def
	/existential	{ (te) map }		def
	/percent	{ norm }		def
	/ampersand	{ norm }		def
	/suchthat	{ (cm) map }		def
	/parenleft	{ norm }		def
	/parenright	{ norm }		def
	/asteriskmath	{ (**) map }		def
	/plus		{ (pl) map }		def
	/comma		{ norm }		def
	/minus		{ (mi) normdup }	def
	/period		{ norm }		def
	/slash		{ (sl) map }		def
	/zero		{ norm }		def
	/one		{ norm }		def
	/two		{ norm }		def
	/three		{ norm }		def
	/four		{ norm }		def
	/five		{ norm }		def
	/six		{ norm }		def
	/seven		{ norm }		def
	/eight		{ norm }		def
	/nine		{ norm }		def
	/colon		{ norm }		def
	/semicolon	{ norm }		def
	/less		{ norm }		def
	/equal		{ (eq) normdup }	def
	/greater	{ norm }		def
	/question	{ norm }		def
	/congruent	{ (=~) map }		def
	/Alpha		{ gnorm }		def
	/Beta		{ gnorm }		def
	/Chi		{ (*X) map }		def
	/Delta		{ gnorm }		def
	/Epsilon	{ gnorm }		def
	/Phi		{ gnorm }		def
	/Gamma		{ gnorm }		def
	/Eta		{ (*Y) map }		def
	/Iota		{ gnorm }		def
	/theta1		{ }			def
	/Kappa		{ gnorm }		def
	/Lambda		{ gnorm }		def
	/Mu		{ gnorm }		def
	/Nu		{ gnorm }		def
	/Omicron	{ gnorm }		def
	/Pi		{ gnorm }		def
	/Theta		{ (*H) map }		def
	/Rho		{ gnorm }		def
	/Sigma		{ gnorm }		def
	/Tau		{ gnorm }		def
	/Upsilon	{ gnorm }		def
	/sigma1		{ (ts) map }		def
	/Omega		{ (*W) map }		def
	/Xi		{ (*C) map }		def
	/Psi		{ (*Q) map }		def
	/Zeta		{ gnorm }		def
	/bracketleft	{ norm }		def
	/therefore	{ (tf) map }		def
	/bracketright	{ norm }		def
	/perpendicular	{ (bt) map }		def
	/underscore	{ (ul) map }		def
	/radicalex	{ }			def
	/alpha		{ gnorm }		def
	/beta		{ gnorm }		def
	/chi		{ (*x) map }		def
	/delta		{ gnorm }		def
	/epsilon	{ gnorm }		def
	/phi		{ gnorm }		def
	/gamma		{ gnorm }		def
	/eta		{ (*y) map }		def
	/iota		{ gnorm }		def
	/phi1		{ }			def
	/kappa		{ gnorm }		def
	/lambda		{ gnorm }		def
	/mu		{ gnorm }		def
	/nu		{ gnorm }		def
	/omicron	{ gnorm }		def
	/pi		{ gnorm }		def
	/theta		{ (*h) map }		def
	/rho		{ gnorm }		def
	/sigma		{ gnorm }		def
	/tau		{ gnorm }		def
	/upsilon	{ gnorm }		def
	/omega1		{ }			def
	/omega		{ (*w) map }		def
	/xi		{ (*c) map }		def
	/psi		{ (*q) map }		def
	/zeta		{ gnorm }		def
	/braceleft	{ norm }		def
	/bar		{ (or) normdup }	def
	/braceright	{ norm }		def
	/similar	{ (ap) map }		def
	/Upsilon1	{ }			def
	/minute		{ (mt) map }		def
	/lessequal	{ (<=) map }		def
	/fraction	{ (/) map }		def
	/infinity	{ (if) map }		def
	/florin		{ }			def
	/club		{ (Cc) map }		def
	/diamond	{ (Cd) map }		def
	/heart		{ (Ch) map }		def
	/spade		{ (Cs) map }		def
	/arrowboth	{ (<>) map }		def
	/arrowleft	{ (<-) map }		def
	/arrowup	{ (ua) map }		def
	/arrowright	{ (->) map }		def
	/arrowdown	{ (da) map }		def
	/degree		{ (de) map }		def
	/plusminus	{ (+-) map }		def
	/second		{ (sd) map }		def
	/greaterequal	{ (>=) map }		def
	/multiply	{ (mu) map }		def
	/proportional	{ (pt) map }		def
	/partialdiff	{ (pd) map }		def
	/bullet		{ }			def
	/divide		{ (di) map }		def
	/notequal	{ (!=) map }		def
	/equivalence	{ (==) map }		def
	/approxequal	{ (~=) map }		def
	/ellipsis	{ }			def
	/arrowvertex	{ }			def
	/arrowhorizex	{ }			def
	/carriagereturn	{ (cr) map }		def
	/aleph		{ (al) map }		def
	/Ifraktur	{ }			def
	/Rfraktur	{ }			def
	/weierstrass	{ }			def
	/circlemultiply	{ (ax) map }		def
	/circleplus	{ (a+) map }		def
	/emptyset	{ (es) map }		def
	/intersection	{ (ca) map }		def
	/union		{ (cu) map }		def
	/propersuperset	{ (sp) map }		def
	/reflexsuperset	{ (ip) map }		def
	/notsubset	{ (!s) map }		def
	/propersubset	{ (sb) map }		def
	/reflexsubset	{ (ib) map }		def
	/element	{ (mo) map }		def
	/notelement	{ (!m) (nm) mapdup }	def
	/angle		{ (ag) map }		def
	/gradient	{ (gr) map }		def
	/registerserif	{ }			def
	/copyrightserif	{ }			def
	/trademarkserif	{ }			def
	/product	{ }			def
	/radical	{ (sr) map }		def
	/dotmath	{ (m.) map }		def
	/logicalnot	{ (no) map }		def
	/logicaland	{ (an) (la) mapdup }	def
	/logicalor	{ (lo) map }		def
	/arrowdblboth	{ (io) map }		def
	/arrowdblleft	{ (<:) (lh) mapdup }	def
	/arrowdblup	{ (u=) map }		def
	/arrowdblright	{ (:>) (rh) (im) mapdupdup } def
	/arrowdbldown	{ (d=) map }		def
	/lozenge	{ (dm) map }		def
	/angleleft	{ (L<) map }		def
	/registersans	{ (rg) map }		def
	/copyrightsans	{ (co) map }		def
	/trademarksans	{ (tm) map }		def
	/summation	{ }			def
	/parenlefttp	{ }			def
	/parenleftex	{ }			def
	/parenleftbt	{ }			def
	/bracketlefttp	{ }			def
	/bracketleftex	{ }			def
	/bracketleftbt	{ }			def
	/bracelefttp	{ }			def
	/braceleftmid	{ }			def
	/braceleftbt	{ }			def
	/braceex	{ }			def
	/apple		{ (AL) map }		def
	/angleright	{ (R>) map }		def
	/integral	{ (is) map }		def
	/integraltp	{ }			def
	/integralex	{ }			def
	/integralbt	{ }			def
	/parenrighttp	{ }			def
	/parenrightex	{ }			def
	/parenrightbt	{ }			def
	/bracketrighttp	{ }			def
	/bracketrightex	{ }			def
	/bracketrightbt	{ }			def
	/bracerighttp	{ }			def
	/bracerightmid	{ }			def
	/bracerightbt	{ }			def
end
END
if [ -n "$all" ]
then
cat <<'END'
	/Times-Roman		/Roman		/R	fontinfo
	/Helvetica		/Helvetica	/H	fontinfo
	/Courier		/Courier	/C	fontinfo
	/Symbol			/Symbol		/S	fontinfo
	/Times-Italic		/Italic		/I	fontinfo
	/Times-Bold		/Bold		/B	fontinfo
	/Times-BoldItalic	/BoldI		/BI	fontinfo
	/Helvetica-Bold		/HelveticaB	/HB	fontinfo
	/Helvetica-Oblique	/HelveticaO	/HO	fontinfo
	/Helvetica-BoldOblique	/HelveticaBO	/HX	fontinfo
	/Courier-Bold		/CourierB	/CB	fontinfo
	/Courier-Oblique	/CourierO	/CO	fontinfo
	/Courier-BoldOblique	/CourierBO	/CX	fontinfo
	/Helvetica-Narrow	/HelvNarHn	/Hn	fontinfo
	/Helvetica-Narrow-Oblique /HelvNarHo	/Ho	fontinfo
	/Helvetica-Narrow-BoldOblique	/HelvNarHx	/Hx	fontinfo
	/Helvetica-Narrow-Bold	/HelvNarHb	/Hb	fontinfo
	/ZapfChancery-MediumItalic	/ZapfC	/ZC	fontinfo
	/ZapfDingbats		/ZapfD		/ZD	fontinfo
	/AvantGarde-Book	/AvantAR	/AR	fontinfo
	/AvantGarde-BookOblique	/AvantAX	/AX	fontinfo
	/AvantGarde-Demi	/AvantAB	/AB	fontinfo
	/AvantGarde-DemiOblique	/AvantAI	/AI	fontinfo
	/Palatino-Roman		/PalatPR	/PR	fontinfo
	/Palatino-Bold		/PalatPB	/PB	fontinfo
	/Palatino-BoldItalic 	/PalatPX	/PX	fontinfo
	/Palatino-Italic 	/PalatPI	/PI	fontinfo
	/NewCenturySchlbk-Bold	/NewCB	/NB	fontinfo
	/NewCenturySchlbk-BoldItalic /NewCX	/NX	fontinfo
	/NewCenturySchlbk-Italic	/NewCI	/NI	fontinfo
	/NewCenturySchlbk-Roman	/NewCR	/NR	fontinfo
END
else
    if [ -n "$files" ]
    then
	cat $files
    fi
    if [ -n "$lines" ]
    then
	echo $lines
    fi
fi
echo "SAVEOBJ restore"
echo "\004\c"
