/*	Copyright 1985, 1986, 1987, 1988 16:49:37 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		pk2ditwid.c
	Author: 	Chris Lewis
	Specs:		Generates ditroff width tables from PK's
 */

#ifndef	lint
static char SCCSID[] =
    "@(#)pk2ditwid.c 2.1 Copyright 90/07/18 16:49:37 Chris Lewis";
#endif

#include "defs.h"
#include "pk.h"

/*	Dummied out for pk.c */
needchar(a, b)
int a, b; {
    return(1);
}

extern struct cattab tabN[], tabS[];
extern struct enctab encNormal[], encSymbol[];

int silent = 0;
int symbol = 0;

FILE *fout = NULL;
char *progname;

#define	UNITWIDTH	10

main(argc, argv)
int argc;
char **argv; {
    char buf[512];
    extern int optind;
    extern char *optarg;
    int c;
    register int i;
    struct enctab *et;

    progname = argv[0];
    while((c = getopt(argc, argv, "D:sS")) != EOF) {
	switch(c) {
	    case 's':
		silent = 1;
		break;
	    case 'S':
		symbol = 1;
		break;
	    case 'D':
#ifdef	DEBUG
		setdebug(optarg, "pk2dw.diag");
		break;
#else
		fprintf(stderr, "%s: DEBUG disabled - recompile\n",
		    progname);
		exit(1);
#endif
	    default:
		fprintf(stderr, "usage: pk2sfp [-D<debugoptions>] [-sS] file\n");
		exit(1);
	}
    }

    if (!silent) {
	if (!symbol) {
	    for (i = 0; encNormal[i].e_name; i++) {
		if (!encNormal[i].e_seq)
		    printf("Can't use %s in Normal font\n",
			encNormal[i].e_name);
#ifdef	NEVER
		else if (strlen(encNormal[i].e_seq) != 1)
		    printf("Multi-char sequence (Normal fonts): %s\n",
			encNormal[i].e_name);
#endif
	    }
	} else {
	    for (i = 0; encSymbol[i].e_name; i++) {
		if (!encSymbol[i].e_seq)
		    printf("Can't use %s in Symbol font\n",
			encSymbol[i].e_name);
#ifdef	NEVER
		else if (strlen(encSymbol[i].e_seq) != 1)
		    printf("Multi-char sequence (Symbol fonts): %s\n",
			encSymbol[i].e_name);
#endif
	    }
	}
    }


    for(;argv[optind];optind++) {
	register struct pkp *pk;
	register struct pkc *pc;
	register char *p;

	p = strrchr(argv[optind], '/');
	if (p)
	    strcpy(buf, p+1);
	else
	    strcpy(buf, argv[optind]);

	if (p = strchr(buf, '.'))
	    *p = '\0';
	else
	    strcat(buf, ".WID");

	if (!(fout = fopen(buf, "w"))) {
	    fprintf(stderr, "%s: cannot open %s\n", progname, buf);
	    exit(1);
	}

	fprintf(fout, "# %s\n", buf);
	fprintf(fout, "# Generated by pk2ditwid\n");
	fprintf(fout, "spacewidth 22\n");
	fprintf(fout, "charset\n");

	/* Read the PK file in-core */
	pk = pk_read(argv[optind]);

	/* Emit each character */
	for (pc = pk->pkp_chars; pc; pc = pc->pkc_next) {
	    if (pc->pkc_char <= 0x20)
		continue;
	    if (symbol)
		et = encSymbol;
	    else
		et = encNormal;
	    scanet(pk, pc, et);
	}

	for (et = (symbol ? encSymbol: encNormal); et->e_name; et++) {
	    if (et->e_seq && !et->e_wid) {
		if (!silent)
		    printf("Didn't find width for %s\n", et->e_name);
	    } else {
		register char *pp;
		fprintf(fout, "%s\t%ld\t%d\t",
		    et->e_name, et->e_wid & 0x3f, (et->e_wid>>6)&0x3);
		for (pp = et->e_seq; *pp; pp++)
		    fprintf(fout, "\\%03o", (*pp)&0xff);
		fprintf(fout, "\n");
	    }
	}

	/* Clobber in-core PK */
	pk_destroy(pk);

    }
    exit(0);
}

scanet(p, pc, et)
register struct pkp *p;
register struct pkc *pc;
register struct enctab *et; {
    register char *pp;
    int found = 0;
    for (; et->e_name; et++) {
	if (!et->e_seq)
	    continue;
	for (pp = et->e_seq; *pp; pp++) {
	    if (((*pp)&0xff) == pc->pkc_char) {
				/* get # pixels */
		long widval = ((double) pc->pkc_dx / pow2(16)) *
				/* normalize by actual resolution */
			      ((double) OUTRES / p->pkp_res) *
				/* normalize to UNITWIDTH points */
			      ((double) UNITWIDTH * pow2(20) / p->pkp_ds) +
				/* round ... */
			      0.5;
		int kern = ((p->pkp_kh < pc->pkc_y_off) << 1) |
			   (p->pkp_kl - 2 > pc->pkc_y_off - pc->pkc_height);
			   /* the "-2" is a fudge for teensy descenders */
		found = 1;

		/*printf("%s %s %03o\n", et->e_name, et->e_seq, pc->pkc_char);*/
		if (et->e_wid) {	/* already seen */
		    int oldwid, oldkern;
		    oldwid = et->e_wid&0x3f;
		    oldkern = (et->e_wid>>6)&3;
		    kern |= oldkern;		/* this is correct */
		    /* This can be fooled.... */
		    if (*(pp+1) == 0x08 ||
			(pp > et->e_seq && *(pp-1) == 0x08))
			/* preceded or succeeded by BACKSPACE */
			widval = max(widval, oldwid);
		    else
			widval += oldwid;
		    if (widval > 0x3f) {	/* oh-oh! */
			printf("Multi-sequence too wide! (%s)\n",
			    et->e_name);
			widval = 0x3f;
		    }
		}
		et->e_wid = (widval | (kern << 6));
	    }
	}
    }
    if (!found && !silent)
	printf("Character \\%03o in font not used by troff\n",
	    pc->pkc_char);
}
