/*	Copyright 1985, 1986, 1987, 1988 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		utils.c
	Author: 	Chris Lewis
	Specs:		Utility functions
 */

#include "defs.h"

#ifndef	lint
static char SCCSid[] =
    "@(#)utils.c: 2.1 Copyright 90/07/18 16:51:48 Chris Lewis";
#endif

extern struct cattab tabN[], tabS[];

int lastFont, lastPoints;
int lastYPos, lastXPos;

extern char *malloc();

char *skipblanks(p)
register char *p; {
    while (*p && isspace(*p)) p++;
    return(p);
}

char *gettok(p, bp)
register char *p, *bp; {
    p = skipblanks(p);
    while(*p && !isspace(*p)) *bp++ = *p++;
    *bp = '\0';
    return(p);
}

interp(buf, xlator, suf)
char *buf, *suf; FUNC xlator; {
    register char *p;
    char token[512];
    p = gettok(buf, token);
    if (0 == strcmp(token, "include") || 0 == strcmp(token, "binclude")) {
	int binary;
	FILE *inc;
	binary = (token[0] == 'b') ? 1: 0;
	p = gettok(p, token);
	DBP((D_SPEC, "Trying to include %s\n", token));
	if (!(inc = fopen(token, "r"))) {
	    strcat(token, ".");
	    strcat(token, suf);
	    DBP((D_SPEC, "Trying to include %s\n", token));
	    if (!(inc = fopen(token, "r"))) {
		char nbuf[512];
		if (token[0] != '/') {
		    sprintf(nbuf, "%s/%s", LIBDIR, token);
		    DBP((D_SPEC, "Trying to include %s\n", nbuf));
		    inc = fopen(nbuf, "r");
		}
	    }
	}
	if (!inc) {
	    fprintf(stderr, "%s: cannot open file %s\n", progname, token);
	    exit(1);
	} else {
	    DBP((D_SPEC, "Successfull include\n"));
	    if (binary || !xlator)
		while ((binary = fread(token, 1, sizeof(token), inc)) > 0)
		    fwrite(token, 1, binary, stdout);
	    else
		(*xlator)(inc);
	    fclose(inc);
	}
    }

    else {
	fprintf(stderr, "%s: unknown directive: %s\n", progname, token);
	exit(1);
    }
}

char nodename[25];
getnodename() {
    FILE *uuname;
    if ((uuname = popen("uuname -l", "r")) == NULL)
	strcpy(nodename, "<noname>");
    else {
	fscanf(uuname, "%s", nodename);
	pclose(uuname);
    }
}

struct fonttable fonttable[MAXFONTS+1];
struct fonttable *xlatetable[8];

#define	READFONT	0
#define	READNORM	1
#define	READSYMB	2

loadfont(normfont, symfont)
struct troff2befont *normfont, *symfont; {

    char buffer[BUFSIZ];
    char buf[6][64];
    int tableindex;
    int state, i, count;
    register char *first;
    extern int atoi();
    struct cattab *tab;
    struct troff2befont *otab;
    int done;

    FILE *fontfile;

    for (tableindex = 0; tableindex < 8; tableindex++) {
	xlatetable[tableindex] = &fonttable[tableindex];
    }

    fontfile = libopen(printer, "fonts");

    tableindex = 0;

    state = READFONT;

    while(fgets(buffer, sizeof(buffer), fontfile)) {

	first = buffer;

	for(;*first && isspace(*first); first++);

	if (!*first || *first == '#')
	    continue;

	switch(count = sscanf(first, "%s%s%s%s%s%s",
	    buf[0], buf[1], buf[2], buf[3], buf[4], buf[5])) {
	    case 1: buf[1][0] = '\0';
	    case 2: buf[2][0] = '\0';
	    case 3: buf[3][0] = '\0';
	    case 4: buf[4][0] = '\0';
	    case 5: buf[5][0] = '\0';
	    case 6:
		if        (strcmp(buf[0], "normal") == 0) {
		    state = READNORM;
		    break;
		} else if (strcmp(buf[0], "symbol") == 0) {
		    state = READSYMB;
		    break;
		}
		switch(state) {
		    case READFONT:
			if (tableindex == MAXFONTS) {
			    fprintf(stderr, "%s: Too many fonts for %s!\n",
				progname, printer);
			    exit(1);
			}
			for(i = 0; i < 4; i++) {
			    first = mustmalloc(strlen(buf[i])+1,
				"fonttable");
			    strcpy(first, buf[i]);
			    fonttable[tableindex].tab[i] = first;
			}
#ifdef	OPT
			fonttable[tableindex].widthtable = (char *) NULL;
#endif
			tableindex++;
			break;
		    case READNORM: case READSYMB:
			done = 0;
			if (count <= 1) {
			    fprintf(stderr, "%s: bad font.%s line: %s\n",
				progname, printer, buffer);
			    exit(1);
			}
			tab = (state == READNORM) ? tabN : tabS;
			otab = (state == READNORM) ? normfont : symfont;
			for (i = 0; tab[i].ch_name; i++) {
			    if (strcmp(tab[i].ch_name, buf[0]) == 0) {
				switch(buf[1][0]) {
				    case 'N':
					otab[i].t2b_font = N; break;
				    case 'S':
					otab[i].t2b_font = S; break;
				    case 'D':
					otab[i].t2b_font = D; break;
				    case '0':
				    case '1':
				    case '2':
				    case '3':
				    case '4':
				    case '5':
				    case '6':
				    case '7':
				    case '8':
				    case '9':
					otab[i].t2b_font = atoi(buf[1]);
					break;
				    default:
					fprintf(stderr, "%s: bad font in %s\n",
					    progname, buffer);
					exit(1);
				}
				switch(count) {
				    case 6:
					otab[i].t2b_scale = atoi(buf[5]);
				    case 5:
					otab[i].t2b_yc = atoi(buf[4]);
				    case 4:
					otab[i].t2b_xc = atoi(buf[3]);
				    case 3:
					octdecode(buf[2]);
					first = mustmalloc(strlen(buf[2]) + 1,
					    "fonttable");
					strcpy(first, buf[2]);
					otab[i].t2b_charseq = first;
				}
				done = 1;
				break;
			    }
			}
			if (!done) {
			    fprintf(stderr, "%s: couldn't apply fonts.%s: %s\n",
				progname, printer, buffer);
			    exit(1);
			}
		}
	}
    }
    fclose(fontfile);
#ifdef	OPT
    loadwidth(xlatetable[0]);
    loadwidth(xlatetable[1]);
    loadwidth(xlatetable[2]);
    loadwidth(xlatetable[3]);
#endif
}

/*	Translate any octal escapes *inplace* */
octdecode(str)
register char *str; {
    register char *from, *to;
    int tmp, i;
    from = to = str;
    while(*from) {
	if (*from != '\\')
	    *to++ = *from++;
	else {
	    tmp = 0;
	    from++;
	    i = 3;
	    while(i-- > 0 && *from && *from >= '0' && *from <= '7')
		tmp = (tmp << 3) + *from++ - '0';
	    *to++ = tmp&0xff;
	}
    }
    *to++ = '\0';
}


dumpsequence(sequence)
register char *sequence; {
    printf("\t");
    for(;*sequence;sequence++)
	if (isascii(*sequence) && isprint(*sequence))
	    printf("%c", *sequence);
	else
	    printf("\\%03o", (*sequence)&0xff);
}

dumpline(name, tp)
register char *name;
register struct troff2befont *tp; {
    if (name != NOC) {
	printf("%s\t", name);
	switch(tp->t2b_font) {
	    case N: printf("N"); break;
	    case S: printf("S"); break;
	    case D: printf("D"); break;
	    default: printf("%d", tp->t2b_font); break;
	}
	dumpsequence(tp->t2b_charseq);
	printf("\t%d\t%d\t%d", tp->t2b_xc, tp->t2b_yc, tp->t2b_scale);
	printf("\n");
    }
}

dumplist(namelist, tp)
register struct cattab *namelist;
register struct troff2befont *tp; {
    register int i;
    for (i = 0; namelist[i].ch_name && namelist[i].ch_catidx != NTC;
	i++, tp++) {
	if (strlen(namelist[i].ch_name) == 0)
	    continue;
	if (strcmp(namelist[i].ch_name, "hy") == 0)
	    dumpline("-", tp);
	dumpline(namelist[i].ch_name, tp);
    }
}

dumptables(bep)
struct backend *bep; {
    if (!bep) {
	fprintf(stderr, "%s: no backend selected for table dump\n", progname);
	exit(1);
    }
    printf("normal\n");
    dumplist(tabN, bep->bestdfont);
    printf("symbol\n");
    dumplist(tabS, bep->besymfont);
}

FontSel(from, to)
char from, *to; {
#ifdef	DEBUG
    register int i;
#endif
    register struct fonttable *p;
    DBP((D_SPEC, "FontSel: %c -> %s\n", from, to));
    if (from < '1' || from > '8') {
	fprintf(stderr, "Bad arguments to FontSel: %c %s\n", from, to);
	return;
    }

    for (p = fonttable; p->troffName; p++)
	if (strcmp(p->troffName, to) == 0) {
	    xlatetable[from - '1'] = p;
	    break;
	}
    if (!p->troffName) {
	fprintf(stderr, "Could not translate font %c (%s)\n", from, to);
    }
#ifdef	OPT
    if (p->troffName && !p->widthtable)
	loadwidth(p);
#endif

#ifdef	DEBUG
    for (i = 0; i < 8; i++)
	DBP((D_SPEC, "Font %d->%s\n", i+1, xlatetable[i]->fontName));
#endif
}

FILE *libopen(pref, suf)
register char *pref, *suf; {

    register char *buffer = mustmalloc(strlen(LIBDIR) + 50, "libopen");
    register FILE *library;

    sprintf(buffer, "%s.%s", pref, suf);
    if ((library = fopen(buffer, "r")) == NULL) {
	sprintf(buffer, "lib/%s.%s", pref, suf);
	if ((library = fopen(buffer, "r")) == NULL) {
	    sprintf(buffer, "%s/%s.%s", LIBDIR, pref, suf);
	    if ((library = fopen(buffer, "r")) == NULL) {
		fprintf(stderr, "Cannot find %s.%s in . or lib or %s\n", pref, suf,
		    LIBDIR);
		exit(1);
	    }
	}
    }
    free(buffer);
    return(library);
}

resetState() {
    lastFont = -1;
    lastPoints = -1;
    lastYPos = -1;
    lastXPos = -1;
}

doprologs() {
    if (!prologs)
	return;
    while(*prologs)
	dospecial(*prologs++);
}

#ifdef	OPT
loadwidth(p)
struct fonttable *p; {
    FILE *f;
    int c;
    if ((int) p->widthtable == 1)
	return;
    p->widthtable = mustmalloc(224, "widthtable");
    strcpy(widthptr, "ft");
    strcat(widthptr, p->troffName);
    DBP((D_SPEC, "Attempting to read font file %s\n", widthtables));
    if (f = fopen(widthtables, "r")) {
	for (c = 0; c < HEADERSIZE; c++) getc(f);
	if (224 != fread(p->widthtable, 1, 224, f)) {
	    fprintf(stderr, "%s: badly formed width table %s\n",
		progname, widthtables);
	    free(p->widthtable);
	    p->widthtable = (char *) 1;
	    DBP((D_SPEC, "Load of %s failed\n", widthtables));
	} else {
	    for (c = 0; c < 224; c++)
		p->widthtable[c] &= 0x3f;
	    DBP((D_SPEC, "Load of %s succeeded\n", widthtables));
	}
    } else {
	DBP((D_SPEC, "Failed to open widthtable %s\n", widthtables));
	free(p->widthtable);
	p->widthtable = (char *) 1;
    }
}
#endif

#ifdef	NULLCHECK
mab() {
    fprintf(stderr, "KABOOM\n");
    abort();
}
#endif
