/*	Copyright 1985, 1986, 1987, 1988 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		t2conf.c
	Author: 	Chris Lewis
	Specs:		Switch for alternate backends.
 */

#include "defs.h"

#ifndef	lint
static char SCCSid[] =
    "@(#)t2conf.c: 2.1 Copyright 90/07/18 16:51:40 Chris Lewis";
#endif

#ifdef	PS
#include "ps.h"
#endif

#ifdef	LJ
#include "lj.h"
#endif

#ifdef	DT
#include "dt.h"
#endif

extern int FontSel();

/*	Common variables */
int	pagePending = 1;
int	currentPage = 0;

struct backend B[] = {
/*   bename,	beprolog,	beepilog,	bechar,	bepage,	befontsel */
/*		beoverlay,	bepassthru	bexlat, bestdfont, besymfont */

#ifdef	PS
    { "ps",	psProlog,	psEpilog,	psChar,	psPage,	FontSel,
		psOverlay,	NULL,		psXlate, psStdFont, psSymFont },
#endif

#ifdef	DT
    { "dt",	dtProlog,	dtEpilog,	dtChar,	dtPage,	FontSel,
		NULL,		dtPassthru,	NULL,	dtStdFont, dtSymFont },
#endif

#ifdef	LJ
    { "lj",	ljProlog,	ljEpilog,	ljChar,	ljPage,	FontSel,
		NULL,		NULL,		NULL,   ljStdFont, ljSymFont },
#endif
    { NULL }
};


getdriver(name)
char *name; {

    be = BNULL;
    if (B[0].bename == NULL) {
	fprintf(stderr, "%s: No drivers configured!\n", progname);
	exit(1);
    }

    if (B[1].bename == NULL) {
	if (strcmp(B[0].bename, name)) {
	    fprintf(stderr, "%s: Asked for driver '%s', only %s exists\n",
		progname, name, B[0].bename);
	    exit(1);
	}
	be = &B[0];
	return;
    }
    for (be = B; be->bename != NULL; be++)
	if (strcmp(name, be->bename) == 0)
	    return;
    fprintf(stderr, "%s: No driver called '%s' configured\n", progname, name);
    exit(1);
}
