%%STARTSHELL%%
#	Copyright 1985, 1986, 1987, 1988 Chris Lewis
#		All Rights Reserved
#
#    Permission to copy and further distribute is freely given provided
#    this copyright notice remains intact and that this software is not
#    sold for profit.
#
#	Project:	Generic Troff drivers
#	Module:		psroff.sh
#	Author: 	Chris Lewis
#	Specs:		troff driver
#
#ident  "@(#)psroff.sh: 2.1 Copyright 90/07/18 16:51:55 Chris Lewis"

LIBDIR="%%LIBDIR%%"
FONTDIR="%%FONTDIR%%"

term=false
fail=false
type=`basename $0 | sed -n -e 's;^\([^/]*\)roff$;\1;p'`
if [ -z "$type" ]
then
    echo "psroff: Can't intuit psroff type from $0" >&2
    exit 1
fi
copies=1
for i in $*
do
    case $i in
	-F)
	    fail=true
	    ;;
	-X)
	    set -x
	    debug=1
	    ;;
	-t)
	    term=true
	    ;;
	-T*)
	    type=`echo $i | sed -e 's/-T//'`
	    ;;
	-d*)
	    sptr=`echo $i | sed -e 's/-d//'`
	    ;;
	-n*)
	    copies=`echo $i | sed -e 's/-n//'`
	    ;;
	-D* | -M | -R* | -O* | -P* | -Z)
	    extraargs="$extraargs $i"
	    ;;
	-m* | -c*)
	    mac=`echo $i | sed -e 's/-[cm]//'`
	    file="$LIBDIR/adapters/mac.$type/tmac.$mac"
	    if [ ! -r $file ]
	    then
		file="$LIBDIR/adapters/tmac.$mac"
	    fi
	    if [ ! -r $file ]
	    then
		file="%%RTMACDIR%%/tmac.$mac"
	    fi
	    if [ ! -r $file ]
	    then
		echo "$0: Couldn't find tmac.$mac anywhere!" >&2
		exit 1
	    fi
	    files="$files $file"
	    ;;
	-)
	    files="$files $i"
	    seenfiles=1
	    ;;
	-rL*)
	    eval `echo $i | sed -e 's/-rL\(..*\)\(.\)$/length=\1 prec=\2/'`
	    if [ -z "$length" -o -z "$prec" ]
	    then
		echo "$0: Bad length definition ($i) - must have value and scale" \
		    >&2
		exit 1
	    fi
	    extraargs="$extraargs -l$length$prec"
	    args="$args $i"
	    ;;
	-*)
	    args="$args $i"
	    ;;
	*)
	    files="$files $i"
	    seenfiles=1
	    if [ ! -r $i ]
	    then
		echo "$0: cannot open $i" >&2
		exit 1
	    fi
	    ;;
    esac
done

if [ -z "$seenfiles" ]
then
    files="$files -"
fi

if [ -f troff2ps ]
then
    t2=./troff2ps
else
    t2=$LIBDIR/troff2ps
fi

if [ -r psrofflib ]
then
    psrofflib=psrofflib
elif [ -r lib/psrofflib ]
then
    psrofflib=lib/psrofflib
else
    if [ -r $LIBDIR/lib/psrofflib ]
    then
	psrofflib=$LIBDIR/lib/psrofflib
    fi
fi

if [ -z "$psrofflib" ]
then
    echo "$0: Can't find psrofflib in . or $LIBDIR" >&2
    exit 1
fi

F=''
#	If your system has no awk (or a busted one), you may have to
#	comment out the "line=`awk ... $psrofflib" lines, and uncomment
#	the sed script.  If you do, you won't be able to continue
#	psrofflib lines, so you'll have to "join" the entries in psrofflib
#	(remembering to delete the name fields in the continuation lines).
line=`awk '
    $1 ~ /^#/ {next}
    $0 ~ /^troff/ { print $0 }
    $1 == "'$type'" {
	seen=1
	print "F='T'" substr($0, length($1) + 1)
	next
    }
    { if (seen) exit(0) }
' $psrofflib`
#line=`sed -n -e '/^troff/p' \
#	     -e "/^$type[ 	]/{
#		 s/^$type[ 	]*\(.*\)$/F='T' \1/p
#		 q
#		}" $psrofflib`

if [ -z "$line" ]
then
    echo "$0: Can't find a line for '$type' in $psrofflib" >&2
    exit 1
else
    eval "$line"
    if [ -z "$F" ]
    then
	echo "$0: Can't find a line for '$type' in $psrofflib" >&2
	exit 1
    fi
fi

if [ -z "$troff" ]
then
    #	Use path instead
    troff=troff
else
    if [ ! -f $troff ]
    then
	echo "$0: $troff: not executable" >&2
	exit 1
    fi
fi

if [ -z "$trofftype" ]
then
    widtharg=''
else
    if [ ! -d $FONTDIR/$width ]
    then
cat >&2 <<!
CAT Troff width tables have not been installed in $FONTDIR/$width/ft\*.
Either you've not installed psroff yet, or your 'width' setting in psrofflib
is incorrect.  Continuing anyways, using the default CAT troff widths found
in $FONTDIR/ft\*, but the character spacing may be somewhat strange.
You should investigate your configuration (see the README and TROUBLE files).
!
	widtharg=''
    else
	widtharg=`eval echo $trofftype`
    fi
fi

if [ -z "$t2arg" ]
then
    echo "$0: t2arg isn't set for $type" >&2
    exit 1
fi

t2arg="$t2arg $extraargs"

if [ -n "$sptr" ]
then
    ptr=$sptr
fi

if [ -n "$debug" ]
then
    (
    echo "troff=$troff"
    echo "trofftype=$trofftype"
    echo "width=$width"
    echo "t2arg=$t2arg"
    echo "lparg=$lparg"
    echo "widtharg=$widtharg"
    echo "ptr=$ptr"
    ) >&2
fi

if [ -n "$widtharg" -a ! -d /usr/lib/font/$width ]
then
    echo "$0: troff doesn't have width tables ($width) for $type printer" >&2
    echo "Please see the README and gfnttab for creating them" >&2
    exit 1
fi

if $fail
then
    $troff -t $widtharg $args $files > /dev/null
elif $term
then
    ( $troff -t $widtharg $args $files 2>&1 ) | $t2 $t2arg
    exit $?
else
    eval "( $troff -t $widtharg $args $files 2>&1 ) | $t2 $t2arg $lparg"
    exit $?
fi
