/*	Copyright 1985, 1986, 1987, 1988 16:51:42 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		ps.h 2.1 90/07/18
	Author: 	Chris Lewis
	Specs:		PostScript Driver definitions
 */

/*	Points per inch (default PostScript resolution) */
#define	PSRESOLUTION	72
/*	Length scaling factor */
#define	PSSCALEFACTOR	(TROFFRESOLUTION/PSRESOLUTION)
/*	Troff assumes 7.5" paper width, most macro packages print in
	6.5" area within that.  Sooo, we'll center the paperwidth on the
	physical page - implying .5" inch physical margins.
	Note also: ps.c operates in 432'nds, but they're scaled down
	to 72'nds during emission.
 */
#define	TROFF2PSX(x) (x + pageoffset)
/*	11" paper length (note the reversed sign!) */
#define	TROFF2PSY(y) (pagelength - pageyoffset - (y))

#define	FONTMACRO

#define	EMITPS	printf

/*	Entry points: */
extern int psProlog(), psEpilog(), psChar(), psPage(),
    psOverlay(), psXlate();

extern struct troff2befont psSymFont[], psStdFont[];
