/*	Copyright 1985, 1986, 1987, 1988 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		ps.c
	Author: 	Chris Lewis
	Specs:		PostScript driver
 */

#include "defs.h"

#ifdef	PS
#include "ps.h"

#ifndef	lint
static char SCCSid[] =
    "@(#)ps.c: 2.1 Copyright 90/07/18 16:47:36 Chris Lewis";
#endif

/*	ps.c will generate some additional "print" commands to cause
	the printer to "print" back who did the job, and how long it
	took.  define NOCHATTER if you don't want this.
 */
static long charCount;

#ifdef	FORM
static char Overlay[100] = {""};
#endif

#define	USED	01

struct troff2befont psStdFont[108] = {

/*	Note on X-shift, Y-shift and point scale factor:
	The first two are shifts in the baseline position of the
	character, and the third is a multiplier of the point size.
	If they are zero, nothing happens.  If they are non-zero,
	they are first multiplied by .01, then (in the case of the
	shifts), multiplied by the current points to get a shift
	value in TROFF2PS[XY] coordinates.  In the case of point scale
	factor, it is multiplied by <currentpointsize> * .01 and becomes
	the pointsize of the sequence to be emitted.
 */
/*          +-------------------------------- Troff character number
	    |
            |    +--------------------------- N: standard fonts
            |    |                            S: symbol font
            |    |                            D: draw macro
            |    |                            n: new font
            |    |
            |    |  +------------------------ X-shift
            |    |  |                         Note: positive is right.
            |    |  |
            |    |  |  +--------------------- Y-shift
            |    |  |  |                      Note: positive is up.
            |    |  |  |
            |    |  |  |  +------------------ Point scale factor
            |    |  |  |  |
            |    |  |  |  |   +-------------- Sequence
            |    |  |  |  |   |
            v    v  v  v  v   v */
	/*  0*/	{N, 0, 0, 0, "h"},
	/*  1*/	{N, 0, 0, 0, "t"},
	/*  2*/	{N, 0, 0, 0, "n"},
	/*  3*/	{N, 0, 0, 0, "m"},
	/*  4*/	{N, 0, 0, 0, "l"},
	/*  5*/	{N, 0, 0, 0, "i"},
	/*  6*/	{N, 0, 0, 0, "z"},
	/*  7*/	{N, 0, 0, 0, "s"},
	/*  8*/	{N, 0, 0, 0, "d"},
	/*  9*/	{N, 0, 0, 0, "b"},
	/* 10*/	{N, 0, 0, 0, "x"},
	/* 11*/	{N, 0, 0, 0, "f"},
	/* 12*/	{N, 0, 0, 0, "j"},
	/* 13*/	{N, 0, 0, 0, "u"},
	/* 14*/	{N, 0, 0, 0, "k"},
	/* 15*/	{N, 0, 0, 0, NOC},
	/* 16*/	{N, 0, 0, 0, "p"},
	/* 17*/	{D, 0, 0, 0, "do34em"},
	/* 18*/	{N, 0, 0, 0, ";"},
	/* 19*/	{N, 0, 0, 0, NOC},
	/* 20*/	{N, 0, 0, 0, "a"},
	/* 21*/	{N, 0, 0, 0, "_"},
	/* 22*/	{N, 0, 0, 0, "c"},
	/* 23*/	{N, 0, 0, 0, "`"},
	/* 24*/	{N, 0, 0, 0, "e"},
	/* 25*/	{N, 0, 0, 0, "'"},
	/* 26*/	{N, 0, 0, 0, "o"},
	/* 27*/	{D, 0, 0, 0, "do14"},
	/* 28*/	{N, 0, 0, 0, "r"},
	/* 29*/	{D, 0, 0, 0, "do12"},
	/* 30*/	{N, 0, 0, 0, "v"},
	/* 31*/	{N, 0, 0, 0, "-"},
	/* 32*/	{N, 0, 0, 0, "w"},
	/* 33*/	{N, 0, 0, 0, "q"},
	/* 34*/	{N, 0, 0, 0, "/"},
	/* 35*/	{N, 0, 0, 0, "."},
	/* 36*/	{N, 0, 0, 0, "g"},
	/* 37*/	{D, 0, 0, 0, "do34"},
	/* 38*/	{N, 0, 0, 0, ","},
	/* 39*/	{N, 0, 0, 0, "&"},
	/* 40*/	{N, 0, 0, 0, "y"},
	/* 41*/	{N, 0, 0, 0, NOC},
	/* 42*/	{N, 0, 0, 0, "%"},
	/* 43*/	{N, 0, 0, 0, NOC},
	/* 44*/	{N, 0, 0, 0, "Q"},
	/* 45*/	{N, 0, 0, 0, "T"},
	/* 46*/	{N, 0, 0, 0, "O"},
	/* 47*/	{N, 0, 0, 0, "H"},
	/* 48*/	{N, 0, 0, 0, "N"},
	/* 49*/	{N, 0, 0, 0, "M"},
	/* 50*/	{N, 0, 0, 0, "L"},
	/* 51*/	{N, 0, 0, 0, "R"},
	/* 52*/	{N, 0, 0, 0, "G"},
	/* 53*/	{N, 0, 0, 0, "I"},
	/* 54*/	{N, 0, 0, 0, "P"},
	/* 55*/	{N, 0, 0, 0, "C"},
	/* 56*/	{N, 0, 0, 0, "V"},
	/* 57*/	{N, 0, 0, 0, "E"},
	/* 58*/	{N, 0, 0, 0, "Z"},
	/* 59*/	{N, 0, 0, 0, "D"},
	/* 60*/	{N, 0, 0, 0, "B"},
	/* 61*/	{N, 0, 0, 0, "S"},
	/* 62*/	{N, 0, 0, 0, "Y"},
	/* 63*/	{N, 0, 0, 0, "F"},
	/* 64*/	{N, 0, 0, 0, "X"},
	/* 65*/	{N, 0, 0, 0, "A"},
	/* 66*/	{N, 0, 0, 0, "W"},
	/* 67*/	{N, 0, 0, 0, "J"},
	/* 68*/	{N, 0, 0, 0, "U"},
	/* 69*/	{N, 0, 0, 0, "K"},
	/* 70*/	{N, 0, 0, 0, "0"},
	/* 71*/	{N, 0, 0, 0, "1"},
	/* 72*/	{N, 0, 0, 0, "2"},
	/* 73*/	{N, 0, 0, 0, "3"},
	/* 74*/	{N, 0, 0, 0, "4"},
	/* 75*/	{N, 0, 0, 0, "5"},
	/* 76*/	{N, 0, 0, 0, "6"},
	/* 77*/	{N, 0, 0, 0, "7"},
	/* 78*/	{N, 0, 0, 0, "8"},
	/* 79*/	{N, 0, 0, 0, "9"},
	/* 80*/	{N, 0, 0, 0, "*"},
	/* 81*/	{N, 0, 0, 0, "\\261"},
	/* 82*/	{N, 0, 0, 0, "\\256"},
	/* 83*/	{N, 0, 0, 0, "\\257"},
	/* 84*/	{D, 0, 0, 0, "doff"},
	/* 85*/	{N, 0, 0, 0, "\\242"},
	/* 86*/	{D, 0, 0, 0, "doFl"},
	/* 87*/	{D, 0, 0, 0, "doFi"},
	/* 88*/	{N, 0, 0, 0, "\\("},
	/* 89*/	{N, 0, 0, 0, "\\)"},
	/* 90*/	{N, 0, 0, 0, "["},
	/* 91*/	{N, 0, 0, 0, "]"},
	/* 92*/	{S, 0, 0, 0, "\\260"},
	/* 93*/	{N, 0, 0, 0, "\\262"},
	/* 94*/	{N, 0, 0, 0, "="},
	/* 95*/	{S, 0, 0, 0, "\\322"},
	/* 96*/	{N, 0, 0, 0, ":"},
	/* 97*/	{N, 0, 0, 0, "+"},
	/* 98*/	{N, 0, 0, 0, NOC},
	/* 99*/	{N, 0, 0, 0, "!"},
	/*100*/	{N, 0, 0, 0, "\\267"},
	/*101*/	{N, 0, 0, 0, "?"},
	/*102*/	{S, 0, 0, 0, "\\242"},
	/*103*/	{N, -60, 0, 0, "|"},
	/*104*/	{N, 0, 0, 0, NOC},
	/*105*/	{S, 0, 0, 0, "\\323"},
	/*106*/	{D, 0, 0, 0, "dosq"},
	/*107*/	{N, 0, 0, 0, "$"},
    };

struct troff2befont psSymFont[] = {
/*          +-------------------------------- Troff character number
	    |
            |    +--------------------------- N: standard fonts
            |    |                            S: symbol font
            |    |                            D: draw macro
            |    |                            n: new font
            |    |
            |    |  +------------------------ X-shift (scaled by point)
            |    |  |                         Note: positive is right.
            |    |  |
            |    |  |  +--------------------- Y-shift (scaled by point)
            |    |  |  |                      Note: positive is up.
            |    |  |  |
            |    |  |  |  +------------------ Point scale factor
            |    |  |  |  |
            |    |  |  |  |   +-------------- Sequence
            |    |  |  |  |   |
            v    v  v  v  v   v */
	/*  0*/	{S, 0, 0, 0, "\\171"},
	/*  1*/	{S, 0, 0, 0, "\\161"},
	/*  2*/	{S, 0, 0, 0, "\\156"},
	/*  3*/	{S, 0, 0, 0, "\\155"},
	/*  4*/	{S, 0, 0, 0, "\\154"},
	/*  5*/	{S, 0, 0, 0, "\\151"},
	/*  6*/	{S, 0, 0, 0, "\\172"},
	/*  7*/	{S, 0, 0, 0, "\\163"},
	/*  8*/	{S, 0, 0, 0, "\\144"},
	/*  9*/	{S, 0, 0, 0, "\\142"},
	/* 10*/	{S, 0, 0, 0, "\\170"},
	/* 11*/	{S, 0, 0, 0, "\\150"},
	/* 12*/	{S, 0, 0, 0, "\\146"},
	/* 13*/	{S, 0, 0, 0, "\\165"},
	/* 14*/	{S, 0, 0, 0, "\\153"},
	/* 15*/	{S, 0, 0, 0, NOC},
	/* 16*/	{S, 0, 0, 0, "\\160"},
	/* 17*/	{N, 0, 0, 0, "@"},
	/* 18*/	{S, 0, 0, 0, "\\257"},
	/* 19*/	{S, 0, 0, 0, NOC},
	/* 20*/	{S, 0, 0, 0, "\\141"},
	/* 21*/	{S, 0, 0, 0, "\\174"},
	/* 22*/	{S, 0, 0, 0, "\\143"},
	/* 23*/	{N, 0, 0, 0, "\\042"},
	/* 24*/	{S, 0, 0, 0, "\\145"},
	/* 25*/	{S, 0, 0, 0, "\\075"},
	/* 26*/	{S, 0, 0, 0, "\\157"},
	/* 27*/	{S, 0, 0, 0, "\\254"},
	/* 28*/	{S, 0, 0, 0, "\\162"},
	/* 29*/	{S, 0, 0, 0, "\\255"},
	/* 30*/	{S, 0, 0, 0, "\\164"},
	/* 31*/	{4, 0, 0, 0, "O"},
	/* 32*/	{N, 0, 0, 0, "\\134"},
	/* 33*/	{S, 0, 0, 0, "\\131"},
	/* 34*/	{D, 0, 0, 0, "BellSymbol"},
	/* 35*/	{S, 0, 0, 0, "\\245"},
	/* 36*/	{S, 0, 0, 0, "\\147"},
	/* 37*/	{S, 0, 0, 0, "\\312"},
	/* 38*/	{S, 0, 0, 0, "\\265"},
	/* 39*/	{S, 0, 0, 0, "\\336"},
	/* 40*/	{S, 0, 0, 0, "\\167"},
	/* 41*/	{S, 0, 0, 0, NOC},
	/* 42*/	{S, 0, 0, 0, "\\321"},
	/* 43*/	{S, 0, 0, 0, NOC},
	/* 44*/	{S, 0, 0, 0, "\\106"},
	/* 45*/	{S, 0, 0, 0, "\\121"},
	/* 46*/	{S, 0, 0, 0, "\\127"},
	/* 47*/	{S, 0, 0, 0, "\\310"},
	/* 48*/	{4, 0, 0, 0, "M"},
	/* 49*/	{S, 0, 0, 0, "\\126"},
	/* 50*/	{S, 0, 0, 0, "\\114"},
	/* 51*/	{S, 0, 0, 0, "\\055"},
	/* 52*/	{S, 0, 0, 0, "\\107"},
	/* 53*/	{S, 0, 0, 0, "\\362"},
	/* 54*/	{S, 0, 0, 0, "\\120"},
	/* 55*/	{S, 0, 0, 0, "\\314"},
	/* 56*/	{S, 0, 0, 0, "\\311"},
	/* 57*/	{N, 0, 0, 0, "\\176"},
	/* 58*/	{S, 0, 0, 0, "\\266"},
	/* 59*/	{S, 0, 0, 0, "\\104"},
	/* 60*/	{S, 0, 0, 0, "\\326"},
	/* 61*/	{S, 0, 0, 0, "\\123"},
	/* 62*/	{S, 0, 0, 0, "\\273"},
	/* 63*/	{S, 0, 0, 0, "\\076"},
	/* 64*/	{S, 0, 0, 0, "\\130"},
	/* 65*/	{S, 0, 0, 0, "\\074"},
	/* 66*/	{S, 0, 0, 0, "\\244"},
	/* 67*/	{S, 0, 0, 0, "\\307"},
	/* 68*/	{S, 0, 0, 0, "\\125"},
	/* 69*/	{S, 0, 0, 0, "\\330"},
	/* 70*/	{4, 0, 0, 0, "J"},
	/* 71*/	{4, 0, 0, 0, "B"},
	/* 72*/	{4, 0, 0, 0, "A"},
	/* 73*/	{4, 0, 0, 0, "C"},
	/* 74*/	{4, 0, 0, 0, "D"},
	/* 75*/	{4, 0, 0, 0, "E"},
	/* 76*/	{4, 0, 0, 0, "F"},
	/* 77*/	{4, 0, 0, 0, "G"},
	/* 78*/	{4, 0, 0, 0, "K"},
	/* 79*/	{4, 0, 0, 0, "I"},
	/* 80*/	{4, 0, 0, 0, "H"},
	/* 81*/	{S, 0, 0, 0, "\\264"},
	/* 82*/	{S, 0, 0, 0, "\\270"},
	/* 83*/	{S, 0, 0, 0, "\\261"},
	/* 84*/	{S, 0, 0, 0, "\\243"},
	/* 85*/	{S, 0, 0, 0, "\\263"},
	/* 86*/	{S, 0, 0, 0, "\\272"},
	/* 87*/	{S, 0, 0, 0, "\\271"},
	/* 88*/	{S, 0, 0, 0, "\\173"},
	/* 89*/	{S, 0, 0, 0, "\\175"},
	/* 90*/	{N, 0, 0, 0, "\\302"},
	/* 91*/	{N, 0, 0, 0, "\\301"},
	/* 92*/	{N, 0, 0, 0, "\\303"},
	/* 93*/	{N, 0, 0, 0, "\\043"},
	/* 94*/	{S, 0, 0, 0, "\\334"},
	/* 95*/	{S, 0, 0, 0, "\\316"},
	/* 96*/	{N, 0, 0, 0, "\\304"},
	/* 97*/	{S, 0, 0, 0, "\\306"},
	/* 98*/	{S, 0, 0, 0, NOC},
	/* 99*/	{N, 0, 0, 0, "\\263"},
	/*100*/	{4, 0, 0, 0, "L"},
	/*101*/	{S, 0, 0, 0, "\\052"},
	/*102*/	{S, 0, 0, 0, "\\315"},
	/*103*/	{4, 0, 0, 0, "N"},
	/*104*/	{S, 0, 0, 0, NOC},
	/*105*/	{S, 0, 0, 0, "\\053"},
	/*106*/	{S, 0, 0, 0, "\\256"},
	/*107*/	{N, 0, 0, 0, "\\247"},
};

psPage() {
    if (!currentPage)
	return;
    printf("hits misses\n");
    printf("PageSave restore\n");
    printf("/misses exch def /hits exch def\n");
    printf("ShowPage\n");
    pagePending = 1;
}

static
doPageStart() {
    currentPage++;
    printf("%%%%Page: ? %d\n", currentPage);
#ifdef	FORM
    printf("/Form { %s } def\n",
	Overlay[0] == '+' ? (Overlay[0] = '\0', Overlay+1) : Overlay);
#endif
    printf("/PageSave save def\n");
    pagePending = 0;
    printf("StartPage\n");
}

psSetFont(font, points)
int font, points; {
    if (lastPoints != points || font != lastFont) {
	struct fonttable *fp = &fonttable[font];
	if (fp->fontSeq && *fp->fontSeq && !(fp->flags&USED)) {
	    char buffer[512];
	    int n;
	    FILE *f = fopen(fp->fontSeq, "r");
	    if (!f) {
		fprintf(stderr, "%s: cannot open fontfile %s\n",
		    progname, fp->fontSeq);
	    } else {
		DBP((D_BEND,"Downloading %s\n", fp->fontSeq));
		while((n = fread(buffer, 1, sizeof(buffer), f)) > 0) {
		    fwrite(buffer, 1, n, stdout);
		}
		fclose(f);
	    }
	}

	fp->flags |= USED;
#ifdef	FONTMACRO
	printf("/%s %d SetFont\n", fp->fontName, points);
#else
	printf("/%s dup /curFont exch def findfont\n",
	    fp->fontName);
	printf("%d dup /curPoints exch def scalefont setfont\n", points);
#endif
	lastPoints = points;
	lastFont = font;
    }
}

psChar(x, y, font, points, troffChar, sequence)
int x, y;
int font, points, troffChar;
register char *sequence; {
    register int nx = TROFF2PSX(x), ny = TROFF2PSY(y);
    register struct troff2befont *rp;

    if (pagePending) {
	resetState();
	doPageStart();
    }

    charCount++;

    DBP((D_BEND,"BEFORE (troffChar,x,y,font,points) = (%d,%d,%d,%d,%d)\n",
	troffChar, x, y, font, points));
    if (font == 3) {
	rp = &be->besymfont[troffChar];
    } else {
	rp = &be->bestdfont[troffChar];
    }

    switch(rp->t2b_font) {
	/* Only fonts with "N" are subject to font translation */
	case N:
	    if (font == 3)
		font = 0;	/* Special chars are Courier */
	    else {
		DBP((D_BEND,"psSetChar %d->%s (%s)\n", font,
		    xlatetable[font]->troffName,
		    xlatetable[font]->fontName));
		font = xlatetable[font] - fonttable;
	    }
	    break;
	case S:
	    font = 3;
	    break;
	case D:
	    break;
	default:
	    /* Typically used when the R and S fonts don't have the
	       character desired, so select the font via the index
	       in the fonts.?? file */
	    font = rp->t2b_font;
	    break;
    }

    if (!sequence)
	sequence = rp->t2b_charseq;

    if (!sequence) {
	fprintf(stderr, "No coding for %d\n", troffChar);
	return;
    }

    /*	We're committed now - the "if" statements avoid floating
	arithmetic on slow machines */

    if (rp->t2b_scale) points *= (.01 * rp->t2b_scale);
    if (rp->t2b_xc) nx += points * (.01 * rp->t2b_xc);
    if (rp->t2b_yc) ny += points * (.01 * rp->t2b_yc);

    psSetFont(font, points);

    DBP((D_BEND,"AFTER (sequence,x,y,font,points) = (%s,%d,%d,%d,%d)\n",
	sequence, nx, ny, font, points));

    if (rp->t2b_font == D) {
	emitnum(nx);
	printf(" ");
	emitnum(ny);
	printf(" ");
	printf("%s\n", sequence);
    } else {
	emitnum(nx);
	if (lastYPos != ny) {
	    printf(" ");
	    emitnum(ny);
	    printf("(%s)Y\n", sequence);
	    lastYPos = ny;
	} else
	    printf("(%s)X\n",sequence);
    }
}

/*	Specialized emit routine:
	outputs number divided by PSSCALEFACTOR, rounded to the first
	decimal place without using floats/double
 */
emitnum(val)
register int val; {
    register int neg;
    if (val < 0) {
	neg = 1;
	val = -val;
    } else {
	neg = 0;
    }
    if (neg)
	printf("-");
    printf("%d", val / PSSCALEFACTOR);
    val = ((val % PSSCALEFACTOR) * 10 /*+ (PSSCALEFACTOR / 2)*/) /
	PSSCALEFACTOR;
    if (val)
	printf(".%d", val);
}

extern char nodename[];

psProlog() {
    extern char *ctime();
    extern char *strchr();
    char buffer[30];
    FILE *library;
    long curtime;

    currentPage = 0;
    pagePending = 1;

    library = libopen(printer, "lib");

    time(&curtime);
    strcpy(buffer, ctime(&curtime));
    *strchr(buffer, '\n') = '\0';
    getnodename();

    printf("%%!PS-Adobe-1.0\n");
    printf("%%%%Title: (stdin)\n");
    printf("%%%%Creator: %s %s\n", progname, shortversion);
    printf("%%%%PsroffVersion: %s\n", version);
    printf("%%%%CreationDate: %s\n", buffer);
    printf("%%%%For: %s\n", username);
    printf("%%%%Pages: (atend)\n");
    printf("%%%%DocumentFonts: (atend)\n");
    printf("%%%%EndComments\n");
    printf("/GlobalSave save def\n");
    printf("/hits 0 def /misses 0 def\n");
    /* special backends (eg: psfig) need this */
    printf("/resolution %d def\n", TROFFRESOLUTION);
#ifndef	NOCHATTER
    /* compatibility with behandler.ps */
    printf("statusdict /jobname (%s@%s %s %s %s) def\n",
	username, nodename, buffer, progname, shortversion);
    printf("(%s@%s %s %s %s\\n) print\n", username, nodename, buffer,
	progname, shortversion);
    printf("flush\n");
#endif
    printf("usertime /btime exch def\n");
    psXlate(library);
    doprologs();
    printf("%%%%EndProlog\n");
    fclose(library);
}

psEpilog() {
    int i;
    if (!currentPage)
	return;
    printf("%%%%Trailer\n");
    if (metrics)
	printf("%d metrics\n", charCount);
#ifndef	NOCHATTER
    printf("(Execution time (seconds): ) print\n");
    printf("usertime btime sub 0.001 mul (          ) cvs print\n");
    printf("(; Pages: %d) print\n", currentPage);
    printf("(\\n) print\n");
    printf("flush\n");
#endif
    printf("GlobalSave restore\n");
    printf("%%%%DocumentFonts:");
    for (i = 0; i < MAXFONTS; i++)
	if (fonttable[i].flags&USED)
	    printf(" %s", fonttable[i].fontName);
    printf("\n");
    printf("%%%%Pages: %d\n", currentPage);
#ifndef	NOCONTROLD
    putchar('\004');
#endif
}

psXlate(library)
FILE *library; {
    char buf[512];
    while (fgets(buf, sizeof(buf), library))
	if (0 == strncmp(buf, "%%%", 3))
	    interp(&buf[3], psXlate, "ps");
	else
	    fputs(buf, stdout);
}

psOverlay(overlay)
char *overlay; {
#ifdef	FORM
    strcpy(Overlay, overlay);
    printf("%%%%%%Form set: %s\n", Overlay);
#endif
}

#endif /* PS */
