.\"Copyright 1988 by Chris Lewis 2.1 90/07/18
.TH TROFF2PS 1 local
.SH NAME
troff2ps, troff2lj, troff2xx \- convert troff output to Postscript, HP etc.
.SH SYNOPSIS
.BI %%LIBDIR%%/troff2 xx
.BI "[-D" debopts "]"
.BI "[-T" xx "]"
.BI "[-R" nn "]"
.BI "[-P" opt "]*"
.BI "[-l" length "]"
.BI "[-p" prolog "]"
.BI "[-O" l "]"
.BI "[-Y" l "]"
[-V] [-M]
.SH DESCRIPTION
.I Troff2ps
takes
.I troff
output on standard input and transforms it into another format for
output on a printer.
This program is normally invoked by
.IR psroff (1L),
which has a more complete description of how to use some of the more
interesting features of this program.
.P
The output format is determined by how
.I troff2ps
is invoked.
Normally,
.I troff2ps
will generate PostScript output, but the
.B -T
option will allow you to specify other types of output.
Your system administrator (or the original author of this program) may
make other output options available from time to time.
.P
The
.BI -l length
option is used to tell the software how long the pages are on the printer.
The default value is 11 inches.
Length should be written as if you were issuing a ".pl"
.I troff
command; eg: troff scaling should be used.
For example: "-l11i", "-l4752u", "-l792p" specify a page length of
11 inches in inches,
.I troff
units and points respectively.
.P
The
.BI -T xx
option sets the output format.
For example, "troff2ps -Tlj" will generate Laserjet output.
.P
The
.B -D
option generates scads of diagnostic output in a file called "diagnostics"
in the current directory.
The type of diagnostics is selected by
.IR debopts ,
which is a string of characters from the following list: 'c': cat codes, 's':
special directives, 'f': font management (laserjets), 'b':
cat->backend character translations, 'p': PK font handling, 'v':
extremely verbose, 'F' flush after every debug print statement (very slow).
If DEBUG turned off during compilation, this will not be available.
.P
The
.B -V
option causes
.I troff2ps
to print a version message and quit.
.P
A trailer page of statistics can be generated by using the
.B -M
option provided that the driver supports it.
.P
Where
.I troff2ps
is generating output for another typesetting filter (eg: jetroff),
sometimes the filter will require different resolution settings for output.
For example, jetroff parsing of ditroff input assumes a resolution of
300 in character positioning, but jetroff does not parse the "x res <nn>"
command.
The
.BI "[-R" nn "]"
option allows you to specify the resolution that the output filter expects.
Ditroff output has the default resolution set to 300.
(Which is compatible with jetroff.)
.P
The
.BI -P opt
directive can be specified as many times as you wish, it tells
.I troff2ps
to emit each
.I opt
in turn as special requests after the printer-specific
prolog is generated, but before any pages are emitted.
This allows you to specify file inclusions or form overlays or any
other special request feature in a way that won't interfere with
the beginning of documents, or things like changing forms without
modifying the document.
Each
.I opt
is specified in the same way as the
.B sR
macro below.
.P
The
.B -O
and
.B -Y
options allow you to specify page X and Y offsets respectively.
The value should be a number with a valid troff scale factor.
Eg: ``-O.463i''.
.SH "SPECIAL REQUESTS"
.BI troff2 xx
supports a number of additional features over and above bare
.IR troff .
The macro adapters (see
.IR psroff (1L))
contain a macro called "\fB.sR\fP".
This macro is used to send special requests to the printer driver.
The macro is invoked with the following arguments:
.sp
.nf
\&.sR "<func><arg><arg>..."
.fi
.sp
.P
Where
.I func
is a single letter function code.
.I arg
is an argument to the function - the number of arguments a function
takes is dependent on the function.
.ta |1.4i
.in +1.4i
.ti -1.2i
Function	Meaning
.sp
.ti -1.2i
O<name>	Overlay - use "name" as the name of an overlay file.
More than one can be specified by separating by blanks.
The overlay is typically a name from the printer-specific library.
Eg: "Confidential" is the name for the confidential overlay.
Only supported by postscript driver and this directive must be
executed before any output on the page the overlay is desired.
A O without a name (eg: ``.sR "O"'') cancels the current overlay.
More than one overlay can be specified in one ``O'' request, as
in "OLetterhead Confidential".
.sp
.ti -1.2i
L<name>	Letterhead - same as ``O'', except that the overlay is
cancelled after the first use.
A ``.sR "LLetterhead"'' is the same as a ``.sR "OLetterhead"'' followed
by ``.sR "O"'' after the pagebreak.
Any pre-existing "O" directive is cancelled by the "L" and vice-versa.
.sp
.ti -1.2i
FnAA	Switch troff font (n) 1..4 to driver font AA (eg: .fp 1 CW becomes
F1CW).
See the
.I *.fonts
files for which fonts are supported.
.sp
.ti -1.2i
I<file>	Include the file specified as the single argument into the driver
output.
The driver type is appended onto the end of the file name.
Eg: with the Postscript driver,
".sR Ifoo"
becomes an inclusion of "foo.ps".
.RI troff2 xx
will read the file from the current directory if it exists there, otherwise
from the troff2 library directory.
.sp
These are not
.I troff
inclusions - they are interpreted only by
.RI troff2 xx.
This is how the libraries are loaded.
See the section on libraries on how to write library files.
.sp
.ti -1.2i
i<file>	Same as "I", except that no translations are done whatsover,
allowing you to enter binary files in the driver's output stream.
.sp
.ti -1.2i
Estring	Passes "string" through the stderr of the backend.
Used for passing index macro and macro error messages through to where
you can see them.
All drivers.
.sp
.ti -1.2i
Pstring	Passes "string" through the backend directly to the printer.
This is how you can send text in troff directly to the printer (ie:
embedded postscript inclusions - eg: psfig).
All drivers.
.sp
.ti -1.2i
Sstring	Takes the string and executes it as a command.
The standard output is sent as-is to the printer.
This is how bit map converters can be invoked.
All drivers.
.in -1.2i
.P
Note: in the macro adapters, the ".tm" directive has been renamed to
".tM".
Use of ".tm" will simply forward the message through stderr.
.SH "LIBRARY FILES"
.I Troff2ps
supports the inclusion of printer-specific files both through explicit
inclusions in your
.I troff
files, as well as including a standard prolog in a printer-independent
fashion.
.I troff2xx
loads the file
.IR xx. lib,
where
.I xx
is the printer type selected.
Eg: "ps.lib" for PostScript, or "lj.lib" for LaserJet.
The default prefix is the driver type (eg:
.B -T
option) but can be overridden by using the
.BI -p prefix
option.
With an include directive (either "I" or "i" with ".sR"),
.I troff2xx
will append the suffix to the file name before searching for the file.
.P
Files are searched for in the current directory first, then the
.I troff2xx
library directory second.
.P
The scanning of normal include files is done by stripping all comments
(prefixed by "%") and all whitespace (in lj driver, not neccessary for
PostScript).
See the comment in the lj.lib file for more details.
Within the lib files you can recursively include other files as well by
using "%%%include filename".
.P
The "i" include form (.sR macro) or "%%%binclude filename" form (inside
a library file) does the same thing, except that the file included is
simply copied, no translations are done.
.SH FILES
.if t .ta 2.5i
.if n .ta 3.5i
%%LIBDIR%%	Troff2ps library directory
.br
%%LIBDIR%%/lib/*.fonts	Font tables.
.br
%%LIBDIR%%/lib/*.lib	Prefix libraries for output.
.br
etc.
.SH BUGS
Due to the nature by which special sequences are transmitted by
troff (stderr, forced into stdin by
.IR psroff ),
normal troff errors will not be seen and may generate a few
"invalid opcode" messages from troff2ps or garble on output.
Normally the document will be truncated if this occurs.
If this happens, run
.I psroff
with the ``-F'' option.
.P
Unfortunately, there is no way at present for the ".sR" macro to
change fonts within a line - for some pretty bizarre reasons if you ask
me.
Never mind.
Ask me if you want more information.
.SH "SEE ALSO"
troff(1), psroff(1L).
.SH AUTHOR
Chris Lewis (...lsuc!gate!eci386!clewis or clewis@eci386)
