.\"Copyright 1988 by Chris Lewis 90/07/18
.TH PK2SFP 1 local
.SH NAME
pk2sfp,pk2ditwid,pktype,pk2ps \- PK/SFP format font file handling utilities
.SH SYNOPSIS
.B pk2sfp
.BI "[-D" opts "]"
.BI "[" options "]"
fonts ...
.br
.B pk2sfp
.B -m
.BI "[-D" opts "]"
.BI "[" options "]"
map font map font ...
.br
.B pk2ditwid
.BI "[-D" opts "]"
.B "[-S]"
.B "[-s]"
files...
.br
.B pktype
.BI "[-v]"
.BI "[-f" char "]"
.BI "[-l" char "]"
.BI "[-D" opts "]"
files...
.br
.B pk2ps
.B "[-f]"
.B "[-v]"
.BI "[-D" opts "]"
files...
.SH DESCRIPTION
These programs allow you to manipulate PK and SFP format font files,
which
.B psroff
can use with Hewlett Packard Laserjet (or compatible) printers.
These programs are usually found in %%LIBDIR%%.
.SH "Converting SFP and PK files: pk2sfp"
.P
.B pk2sfp
reads each of its argument files, and converts them into HPLJ format
fonts (HP SFP format), and outputs them to standard output sorted
in ascending order of character code.
The output does not normally contain "SET FONT ID" sequences.
This is how HP distributes their fonts on floppies.
.P
.B pk2sfp
concatenates all the conversions of the input files together on standard
output.
.P
.B pk2sfp
with the
.B "-m"
option allows you to merge font files, at the same time changing the
encoding.
Most of the options for simple font conversions apply to
.B pk2sfp
with the
.B "-m"
option, but merging is covered more completely in "Merging SFP and PK
fonts" below.
.P
.B pk2sfp
can read both PK and SFP format files (the latter effectively being a
``no-op'' conversion - which can be useful for checking format validity
and changing header characteristics, see below).
.P
.B pk2sfp
attempts to infer certain header characteristics by the basename
of the input font file name if the input font is PK format.
The
.B psroff
naming convention is:
.BR path / troffname . pointsize . "[pk|sfp]"
.sp
.in +.5i
.nf
All ROMAN8 encodings unless MATH8.
All 0 strokeweight, unless Bold.
All upright, unless Italic
All Roman typeface, unless otherwise specified

R	: Normal Roman
I	: Italic
B	: Bold
S	: MATH8 Symbol
X	: Bold italic
\&.X	: <typeface> Bold italic
\&.I	: <typeface> Italic
\&.B	: <typeface> Bold
\&.R	: <typeface> Normal
H or H.	: Helvetica typeface
C or C.	: Courier typeface
          typefaces should be extended.
.fi
.in -.5i
.P
.B pk2sfp
will pass through SFP characteristics unchanged, unless you change them
explicitly (see below).
.P
.SH "Additional options for pk2sfp"
.P
The
.BI "-s" na
option will set the symbol set.
Eg:
.B "-s8U"
sets the symbol set to "ROMAN8".
.P
.BI "-t" "0|1"
sets the orientation to ``upright'' (0) or ``italic'' (1).
.P
.BI "-w" n
sets the stroke weight, 0 is normal, -7 is very light and 7 is very
bold.
-3 and 3 are traditional values.
.P
.BI "-f" n
sets the typeface to ``n''.
For example, Times Roman is ``5''.
.P
.BI "-i" n
causes
.B pk2sfp
to emit fontid sequences in front of each downloaded
font, incrementing the id by one for each font, starting with number
.IR n .
For compatibility with
.B psroff
it is suggested that ``n'' be at least 1000.
.P
Specifying
.B "-v"
requests pk2sfp to tell you what it's doing on stderr.
.P
The
.B "-S"
tells
.B pk2sfp
that it's dealing with a font intended for
.BR psroff "'s"
S font.
This has no effect unless
.B "-p"
is specified.
.P
The
.B "-p"
("partial downloading") feature indicates to
.B pk2sfp
that the fonts are intended for use with
.B psroff
and that characters that aren't used by
.B psroff
(eg: half of a ROMAN8 font isn't used) will be dropped from the
output font.
The font being read are assumed to be ROMAN8 fonts and the list of
valid characters will correspond to the characters that
.B psroff
needs from ROMAN8 sets.
Specify
.B "-S"
too if you want to do this to MATH8 fonts which are intended for
the characters that
.B psroff
needs from the MATH8 set.
.P
The
.B "-P"
option tells pk2sfp to mark the fonts it downloads as permanent,
which means they are not cleared by a software reset, only explicit
deletions or printer power-offs.
This option does not do anything unless
.BI "-i" n
specified as well.
.P
Please note: the tables used to control
.B "-p"
are compiled into
.BR pk2sfp .
If you change the character translations in lj.c or lj.fonts, you
will have to rebuild
.BR pk2sfp .
The partial option should not be used for auxiliary fonts (fonts
which supply characters not in ROMAN8 or MATH8).
Use the
.B "-m"
(merge) options for creating specialized reduced size font sets for
such fonts.
.P
The following example shows how you could preload your laserjet
with fonts (in sizes 8, 9, 10, 11 and 12).
This demonstrates the use of
the
.BR -p "," -P ","
and
.B -S
options to use up as little Laserjet memory as possible.
(These fonts should be marked ``b'' (builtin) in
.IR lj.fonts ")."
.sp
.in +.25i
.nf
 F=%%LJF%%
 pk2sfp -pP -i1000 $F/R.[89].pk $F/R.1[0-2].pk | lp
 pk2sfp -SpP -i1006 $F/S.[89].pk $F/S.1[0-2].pk | lp
.fi
.in .-25i
.sp
.P
All of the preceding options take place on all of the fonts specified in
the command line.
Most of the options perform no sanity checks on their arguments.
The reader is cautioned to read the HP manuals before attempting anything
fancy with options that affect header descriptors.
.SH "Merging PK and SFP fonts: pk2sfp -m"
.P
There are a wealth of fonts and font formats in the world.
Performing simple conversions between one format and the other would
lead to you having a considerably bigger repertoire of fonts.
Right?
.P
Well, not always.
Not only to the formats change from one font format to another, but
.B encodings
do too.
If you simply converted Knuth's fonts in PK format to SFP and used them
on your Laserjet you're bound to be disappointed, because a character in
Knuth's font isn't necessarily in the same place in standard SFP fonts.
Eg: If you used the hex code 0x7B to print a left brace-bracket (that's
what it is in ASCII and ROMAN8 fonts right?), you'd find that in Knuth's
CMR font you'll get a "ff" ligature instead.
Worse, other ASCII/ROMAN8 characters don't exist in CMR at all.
.P
So, font conversion often needs more than simple format translation
to work out the way you want.
.P
The
.B "-m"
option to
.B pk2sfp
is intended to do just that: take characters from a combination of
fonts, change encodings as necessary, and create one output font.
.BR Psroff "'s"
HP Laserjet S font is created in this way from four separate PK fonts.
.P
The
.B "-m"
option to
.B pk2sfp
indicates that preceding each font file specified a map file will be
given.
Each font file will be appended together (with only one SFP header)
with the translations specified by the map files and copied to
standard output.
Any character not mentioned in a map file is not copied.
The map file applies to the font files following until overridden
by the next map file.
The map file specifies the translations with lines of the following format:
.sp
.in +.5i
.nf
from  to  description
.fi
.in -.5i
.sp
.P
.I From
specifies the character in the font file to be selected.
Any character that doesn't match a ``from'' line will not be
copied to the output.
.I To
specifies what character number the ``from'' character should be
changed to.
If ``to'' is omitted, it is assumed to be the same as ``from''.
The description is free form text and is ignored.
From, to and description are separated by white space.
Empty lines or lines beginning with "#" are comments.
.P
``From'' and ``to'' can be specified in any of the following formats:
a single non-numeric character other than ``#'',
a decimal number starting with a non-zero digit,
an octal number consisting of a zero digit followed by numeric digits,
or hexadecimal consisting of a zero digit, followed by 'x' or 'X', followed
by digits and upper or lower case 'a' through 'f'.
If the ``to'' string is a single double quote ("), it is duplicated
from the ``from'' string.
The error checking isn't very exhaustive, so it is recommended that you
use the
.B -v
option to check things.
The
.B -v
option will also give you a very verbose description of what characters
its translating and what characters it couldn't find.
.P
There are some examples of this in the source tree for
.B psroff ,
that generate a ROMAN8 and MATH8 SFP in 10 points.
Look in utils/Makefile for ``testmerge'', utils/maps contains some
useful translation maps, and utils/fonts contains a few PK files for
your experimentation.
.B Psroff
is shipped with PK format font files that were created by use of this
utility.
.SH "Creating width tables: pk2ditwid"
.P
.B pk2ditwid
is used to generate a ditroff format width table file (used by
.B psroff
width table installation via
.B gfnttab
and
.BR dit2catwid )
from PK or SFP font files.
The output files are generated in the current directory with the
same name as the basename of the input files, with a ".WID"
suffix.
.P
The
.B -S
option indicates to
.B pk2ditwid
that the font file is a
PK or SFP used for the symbol font, otherwise
.B pk2ditwid
assumes that it is a normal font.
.P
The
.B -s
option tells
.B pk2ditwid
to shut up and do the best it can.
Ordinarily
.B pk2ditwid
is extremely chatty about which characters it could find etc.,
which is rarely of major interest to the user.
Which is why
.BR psroff "'s"
installation script puts
.BR pk2ditwid "'s"
output in log files and makes no attempt to show them to the user.
.P
.BR pk2ditwid "'s"
exact operation is somewhat bizarre, the following is a simplified
description:
.P
Normally,
.B psroff
works with pure ROMAN8 and MATH8
encoded fonts for normal and symbol font sets respectively.
(ROMAN8 and MATH8 are two of HP's standard "char-to-glyph" mapping tables).
However,
The MATH8 and ROMAN8 encodings do not exactly reflect CAT
.BI troff 's
divisions of characters.
In
.BR troff2ps 's
backend drivers, there are tables that correspond to CAT normal and symbol,
which are indexed by CAT code to select which HP font and character sequence
should be emitted by the backend to print a specific CAT character.
.P
Most CAT codes are single HP characters, but a few are done by concatenation
(for example \e(34 may be) or overstrike
(\e(co may be).
.P
.B pk2ditwid
uses the backend tables and reads each of the font files given as arguments.
It then generates a ditroff-like width table that contains width information
for each sequence of HP characters needed to generate a CAT character.
The width tables are fairly simple, and contain three fields of principle
interest:
.P
Column one is the CAT
.B troff
character name.
Single characters are themselves, dual characters are prefixed by "\e("
in
.BR troff .
.P
The second column indicates the width of that character in 1/300th's of an
inch when the character is printed at 10 points.
(Which are the default
.BR gfnttab / dit2catwid
settings)
.P
The third column is the kerning information, and is a number formed
by or'ing a 1 and/or 2 together.
A ``1'' denotes an descender (eg: ``g''),
and a ``2'' denotes a character with an ascender (eg: ``k'').
.P
Please note this is only ditroff-\f3like\fP \(em the output is not
intended to go through real
.B makedev
which will probably complain about multiple-character emit sequences and
missing directives.
.P
The wierdness comes from the fact that it's possible to override the
CAT character to HP sequence translation by adding directives to the
.I lj.fonts
file but the sequences are built-in (so I'm lazy...) to
.BR pk2ditwid .
If you choose to add in translation overrides to
.IR lj.fonts ,
you will have to recompile
.B pk2ditwid
and rerun the width table build and install procedures
to recompute and install the new width tables.
The Makefile uses the
.B troff2ps
binary to generate a compileable table of translation sequences, using
both the built-in backend map plus the
.I lj.fonts
override you've specified,
plus the mkenctab shell script to generate the pk2ditwid tables.
This is so durn complicated, that I simply automated it all:
in the
.B psroff
source directory area, change
.B lib/lj.fonts
to reflect the translations you need,
and rebuild and reinstall
.BR psroff .
.P
If you're just adding new fonts to
.BR psroff 's
repertoire, this isn't all necessary, just install the fonts into
%%LJF%% (using the proper naming convention),
update
.IR lj.fonts ,
and go into the widths source directory and type ``make ljwidths widths''
then su to root and ``make installwidths''.
.P
.B pk2ditwid
need only be run on one font in each family, and by default, the build
procedure runs
.B pk2ditwid
once each font (in the size closest to 10) that it finds in the
%%LJF%% directory.
.SH "Examining PK and SFP font files: pktype"
.P
.B pktype
reads PK and SFP format files and generates files suffixed with ".D"
which contain a description of the font and each character.
If the
.B "-v"
option is specified, an approximation of the character image is displayed
too.
The
.BI "-f" char
and
.BI "-l" char
options allow you to specify a range of characters to print, where
the
.B -f
specifies the first character, and
.B -l
specifies the last character.
.SH "Displaying PK and SFP font files: pk2ps"
.P
.B pk2ps
takes each of the specified files and generates bitmap Postscript
fonts and appends to each commands to draw a table.
The table contains each character in the font, and below it are
decimal, hexidecimal and octal numbers representing the character code.
The output of
.B pk2ps
is on standard output.
.P
The
.B -f
option causes
.B pk2ps
to omit the table printing commands and some of the extra Postscript, leaving
only the Postscript font definition.
The resultant output can then be used as a Postscript font (via inclusion
in ps.lib etc.).
The font is named for the basename of the filename.
``<path>/cmr10.358pk'' will be called ``cmr10''.
The font is supposedly properly scaled, so Postscript ``scalefont'' will
work normally and generate the size font you expect.
Warning: this uses bitmapped fonts: displaying these characters at
considerably
larger sizes or at odd multiples of the ``true'' size (the size of the
example is actually 10 * 358 / 300) may lead to some objectionable
jaggies.
.P
In all four utilities, the
.BI "-D" opts
option allows you to turn on debugging.
See
.BR troff2ps (1)
for further information.
Note: if DEBUG compiled out, this will not be available.
.SH FILES
.if t .ta 2.5i
.if n .ta 3.5i
%%LJF%%	troff2ps LJ font directory.
.br
%%LIBDIR%%/lib/lj.fonts	LJ font definitions and translation overrides.
	not read by pk2sfp/pktype/pk2ditwid
.SH "BUGS"
.B pk2sfp
should really have multiple output files when requested by an option.
.B pk2ditwid
and
.B pk2sfp
should be able to read the
.I lj.fonts
file instead of being recompiled.
.B pk2ditwid
only understands backspace or character concatenation sequences
(eg: "a\010b" or "ab"),
any translation that contains any other escape sequence will not be
parsed properly and may generate bizarre widths, though it will
be moderately sane if all of the characters in the escape sequence
are nonprintable (or not in the font file).
Such escape sequences may also affect operation of
.B pk2sfp "'s"
partial downloading feature (by including characters that you don't
really need - which is harmless).
.SH "SEE ALSO"
troff2ps(1L), \fIlj.fonts\fP,
Hewlett Packard's HP Laserjet Reference Manuals.
.SH AUTHOR
Written by Chris Lewis
