.\"Copyright 1989, 1990 by Chris Lewis 2.1 90/07/18
.TH HPINTERP 1 local
.SH NAME
hpinterp,lj2ps \- Look at HPLJ codes or convert to Postscript
.SH SYNOPSIS
.B hpinterp
.B "-v"
.B "-p"
.B "-d"
< HP codes
.br
.B lj2ps
< HP codes > Postscript
.SH DESCRIPTION
The
.B hpinterp
program is a brute-force kludge to examine HP Laserjet compatible
escape code sequences.
It generates on standard output english readable versions of the HP
laserjet escape sequences if the -v flag is given,
along with the escape sequence themselves in a ``ascii-ish'' format if the
-d option is also given.
Further, if
.B hpinterp
finds any fonts being downloaded in the stream, it will create
a file called
.BI FONTS/f n
that will contain the font in SFP format, and
.I n
will be the fontid assigned to it.
(0 if there is no fontid assigned, as in HP font floppy distribution
format).
A file called
.BI FONTS/f n .desc
will also be created that contains a English description (including
coarse pixel map) of each font.
.PP
If the "-p" flag is given (without -v or -d),
.B hpinterp
will generate a postscript approximation of the motion and character
show commands represented in the HPLJ sequence.
If appended to a
.B "pk2ps -f"
of all of the
.BI FONTS/f n
files created by
.BR hpinterp ,
the output can be printed on a Postscript printer (sometimes - see WARNINGS).
.PP
.B lj2ps
is a simple shell script that will take HPLJ code on standard input,
run
.B "hpinterp -p"
on it, then run
.B "pk2ps -f"
on the fonts that
.B "hpinterp"
created, and then produce on standard output a Postscript file that
can be sent to a Postscript printer.
.SH FILES
.if t .ta 2.5i
.if n .ta 3.5i
./FONTS/f<n>	Parsed-out SFP's
.br
./FONTS/f<n>.desc	English descriptions
.SH "SEE ALSO"
Hewlett Packard Laserjet documentation.
Adobe Systems Postscript documentation.
.SH WARNINGS
.B Hpinterp
is a dog, it was written for quick debugging purposes.
The
.B -p
option was implemented soley so I could debug
.B "troff2ps -Tlj"
without having a laserjet printer.
.B Hpinterp
will not create a FONTS directory if one doesn't exist, and will die if
there isn't one.
As far as generating postscript is concerned,
.B hpinterp
only translates the 3 or 4 escape sequences generated by
.B "troff2ps -Tlj"
and thereby should not be used on HPLJ output from ANY other program.
In fact,
.B "hpinterp -p"
.B cannot
even handle plain ASCII.
The only sequences that
.B hpinterp
actually does something with for Postscript are:
X and Y absolute decipoint positioning, select font by characteristic
("b" or "n" matching), download font, select downloaded font, emit page
and print a character.
.PP
.B "hpinterp -p"
will attempt to do something sane with selecting a font by characteristic,
but be warned, these use the printer's built-in fonts (which are likely
to be radically different from a LJ's), so the widths may be different and
the mappings of non-ASCII characters certainly will be.
Further, the current incarnation of
.B hpinterp
cannot handle multiple-character output sequences, and will display
wierd things.
.PP
Most Postscript printers have relatively little memory for additional
bitmapped fonts.
Do not be surprised by VMerrors from your Postscript printer if you've
selected more than a few fonts in your Laserjet output.
.SH AUTHOR
Written by Chris Lewis
