#	2.1 90/07/18
#	This file controls psroff, you can insert additional printer
#	types here.  These are eval'd *late* in processing, so that
#	you can insert $copies etc.
#
#	Syntax:
#
# troff=<path to troff>
# trofftype=[-F...|-T...]
# name width=<width> t2arg=<troff2ps args> lparg=<lp command line> ptr=<ptr>
#		<repeat as many printers that you have>
#
#	if troff omitted or assigned "", will use your PATH for troff.
#	if trofftype omitted or assigned "", will not use width table
#		directories, and "width" will be unused.  This is not
#		recommended if you have printers with different character
#		widths.  See trofftype assignment below.
#	name: name of config (eg: xt for ditroff->xtroff).
#	width: name of width files (eg: "ps" for %%FONTDIR%%/ps/ftXX).
#	ptr: default physical printer id (eg: "lp -d$ptr")
#
#	Useful troff2ps args:
#		-T<type>	driver name (defaults ps), available:
#				lj and dt.
#		-p<printer>	printer-specific initializations - eg:
#				prefix for *.lib and *.fonts files.
#				(defaults to <type>).  Should be set
#				*before* -T.
#		-d<device>	x T <device> for ditroff drivers.
#				(defaults to alw)
#		-R<num>		ditroff resolution to use.  Default 300
#		-O<pageoffset>	offset to be applied *bypassing* troff.
#				Default "-O.5i".  Set to 0 to get this
#				perfectly offset-compatible with other
#				troffs.  Most macro packages are set to
#				centre their default page layout in
#				(effectively) 7.5i, the adapters plus
#				the .5i default makes pages centre
#				by default in 8.5i (matter of taste).
#
#	lparg: how to get output to printer.  Note the "-n$copies" and
#		-d$ptr.  The $ptr is the psroff selected physical printer
#		id, and is what would be specified by psroff -d<printer>.
#		Default "ptr" is described above.
#
#	Use single quotes for all strings that have embedded blanks or
#	other metacharacters.  (This delays the variable replacement until
#	the correct point).  Lines can be continued by prepending the
#	continuation lines with the "name" followed by whitespace.
#
#	psroff will use the last assignments to troff and trofftype prior
#	to the matching name.

troff=''
trofftype='-T$width'

#	Uncomment the following if you're a Sun or Ultrix -F troff.
#	Check your manual pages.  (Though some support -F without mentioning
#	it in their manual pages).  The default is "-T" (Xenix and some others)
#trofftype='-F%%FONTDIR%%/$width/ftXX'

#	psroff generating postscript directly.
ps	width=ps t2arg=-Tps lparg='| $LIBDIR/psxlate | rlp -d$ptr -n$copies'
ps	ptr='gate!AppleLaser'
#	Example optimizer entry.
ops	width=ps t2arg='-Tps -Z -W/usr/lib/font/ps'
ops	lparg='| $LIBDIR/psxlate | rlp -d$ptr -n$copies' ptr='gate!AppleLaser'
#	For testing new width tables without clobbering real one.
tps	width=tps t2arg='-Tps -Z -W/usr/lib/font/tps'
tps	lparg='| $LIBDIR/psxlate | rlp -d$ptr -n$copies' ptr='gate!AppleLaser'

#	System V'ish LJ printing to printer called laser.
#	(Does your lp filter script support -og? (8 bit, no filtering))

lj	width=lj t2arg=-Tlj lparg='| lp -d$ptr -og -n$copies' ptr=laser

tlj	width=lj t2arg=-Tlj lparg='| %%LIBDIR%%/lj2ps | rlp -d$ptr -n$copies'
tlj	ptr='gate!AppleLaser'

#	Deskjet: Only difference is troff2ps library inclusions for deskjet.
#	(dt.lib has a slightly different prolog)

dj	width=lj t2arg='-Tlj -pdj' lparg='| lp -d$ptr -og -n$copies' ptr=laser

#	DiTROFF test output (outputs ditroff on screen) using
#	supplied ps widths.

dt	width=ps t2arg='-Tdt -ddjet' lparg="| cat"

#	Ditroff configurations:

#	Tpscript output (ditroff drivers, PS widths, dt libraries)

tp	width=ps t2arg='-Tdt -R720 -dalw'
tp	lparg='| /usr/lib/troff/tpscript | rlp -d$ptr -n$copies'
tp	ptr=gate!AppleLaser

#	jetroff output (ditroff drivers, jt widths, jt libraries)
#	The jt widths are not supplied - see README.  These are widths
#	derived from Knuth's PK fonts from TeX, which are what is distributed
#	with jetroff.  jt.fonts has some example character mapping overrides
#	to make dt.c's mapping tables correspond to jetroff's
#	character->font arrangement.  (Box drawing characters in Rick
#	Richardson's ST (cmtrf) font)

jt	width=jt t2arg='-Tdt -pjt -ddjet' lparg='| djet | lp -d$ptr -n$copies'
jt	ptr=laser

#	X.11 Xtroff using supplied ps width tables
#
#	You should probably run xtroff's devpsc ditroff width tables
#	through gfttab ("cd widths; gfnttab /usr/lib/font/devpsc psc" ?)
#	and change width to psc.  However, the default "ps" tables work
#	pretty well.  A few characters in CAT troff do not print as you
#	would expect: ^, @, \(ga, \(em, \(dg, \(bs, \(eq.  Some of these
#	may have been fixed in your version of xtroff (patch 10).

xt	width=ps t2arg='-Tdt -dpsc' lparg='| xtroff'

#	Adobe Transcript psdit - this appears to work, but I've not
#	set a workable lparg.  A number of characters are missing:
#	@, ^, ff, ffi, ffl (ligatures are off by default anyways),
#	\(bs displays as a heart.

psd	width=ps t2arg='-Tdt -dpsc' lparg='| psdit | something'

#	AT&T ditroff previewer on 3b2's - using supplied ps width tables.
#	Using otroff (CAT troff on these machines) to drive.
#
#	You should probably run xproof's devpsc ditroff width tables
#	through gfttab ("cd widths; gfnttab /usr/lib/font/devpsc psc" ?)
#	and change width to psc.  Special note: xproof keeps each symbol
#	character/pointsize in a separate file, and counts as a separate font.
#	The limit appears to be 50 fonts, so testtab.m won't print completely.

troff=otroff
xp	width=ps t2arg='-Tdt -dpsc' lparg='| xproof'
