/*	Copyright 1985, 1986, 1987, 1988 Chris Lewis
		All Rights Reserved

    Permission to copy and further distribute is freely given provided
    this copyright notice remains intact and that this software is not
    sold for profit.

	Project:	Generic Troff drivers
	Module:		dt.c
	Author: 	Chris Lewis
	Specs:		Ditroff driver
 */

#include "defs.h"

#ifndef	lint
static char SCCSid[] =
    "@(#)dt.c: 2.1 Copyright 90/07/18 16:51:27 Chris Lewis";
#endif

/*	These two tables are always included so that we have the
	official character mapping tables.
 */

struct troff2befont dtStdFont[108] = {

/*	Note on X-shift, Y-shift and point scale factor:
	The first two are shifts in the baseline position of the
	character, and the third is a multiplier of the point size.
	If they are zero, nothing happens.  If they are non-zero,
	they are first multiplied by .01, then (in the case of the
	shifts), multiplied by the current points to get a shift
	value in TROFF2PS[XY] coordinates.  In the case of point scale
	factor, it is multiplied by <currentpointsize> * .01 and becomes
	the pointsize of the sequence to be emitted.
 */
/*          +-------------------------------- Troff character number
	    |
            |    +--------------------------- N: standard fonts
            |    |                            S: symbol font
            |    |                            D: draw macro
            |    |                            n: new font
            |    |
            |    |  +------------------------ X-shift (scaled by point)
            |    |  |                         Note: positive is right.
            |    |  |
            |    |  |  +--------------------- Y-shift (scaled by point)
            |    |  |  |                      Note: positive is up.
            |    |  |  |
            |    |  |  |  +------------------ Point scale factor
            |    |  |  |  |
            |    |  |  |  |   +-------------- Sequence
            |    |  |  |  |   |
            v    v  v  v  v   v */
	/*  0*/	{N, 0, 0, 0, "h"},
	/*  1*/	{N, 0, 0, 0, "t"},
	/*  2*/	{N, 0, 0, 0, "n"},
	/*  3*/	{N, 0, 0, 0, "m"},
	/*  4*/	{N, 0, 0, 0, "l"},
	/*  5*/	{N, 0, 0, 0, "i"},
	/*  6*/	{N, 0, 0, 0, "z"},
	/*  7*/	{N, 0, 0, 0, "s"},
	/*  8*/	{N, 0, 0, 0, "d"},
	/*  9*/	{N, 0, 0, 0, "b"},
	/* 10*/	{N, 0, 0, 0, "x"},
	/* 11*/	{N, 0, 0, 0, "f"},
	/* 12*/	{N, 0, 0, 0, "j"},
	/* 13*/	{N, 0, 0, 0, "u"},
	/* 14*/	{N, 0, 0, 0, "k"},
	/* 15*/	{N, 0, 0, 0, NOC},
	/* 16*/	{N, 0, 0, 0, "p"},
	/* 17*/	{N, 0, 0, 0, "em"},
	/* 18*/	{N, 0, 0, 0, ";"},
	/* 19*/	{N, 0, 0, 0, NOC},
	/* 20*/	{N, 0, 0, 0, "a"},
	/* 21*/	{N, 0, 0, 0, "ru"},
	/* 22*/	{N, 0, 0, 0, "c"},
	/* 23*/	{N, 0, 0, 0, "`"},
	/* 24*/	{N, 0, 0, 0, "e"},
	/* 25*/	{N, 0, 0, 0, "'"},
	/* 26*/	{N, 0, 0, 0, "o"},
	/* 27*/	{N, 0, 0, 0, "14"},
	/* 28*/	{N, 0, 0, 0, "r"},
	/* 29*/	{N, 0, 0, 0, "12"},
	/* 30*/	{N, 0, 0, 0, "v"},
	/* 31*/	{N, 0, 0, 0, "hy"},
	/* 32*/	{N, 0, 0, 0, "w"},
	/* 33*/	{N, 0, 0, 0, "q"},
	/* 34*/	{N, 0, 0, 0, "/"},
	/* 35*/	{N, 0, 0, 0, "."},
	/* 36*/	{N, 0, 0, 0, "g"},
	/* 37*/	{N, 0, 0, 0, "34"},
	/* 38*/	{N, 0, 0, 0, ","},
	/* 39*/	{N, 0, 0, 0, "&"},
	/* 40*/	{N, 0, 0, 0, "y"},
	/* 41*/	{N, 0, 0, 0, NOC},
	/* 42*/	{N, 0, 0, 0, "%"},
	/* 43*/	{N, 0, 0, 0, NOC},
	/* 44*/	{N, 0, 0, 0, "Q"},
	/* 45*/	{N, 0, 0, 0, "T"},
	/* 46*/	{N, 0, 0, 0, "O"},
	/* 47*/	{N, 0, 0, 0, "H"},
	/* 48*/	{N, 0, 0, 0, "N"},
	/* 49*/	{N, 0, 0, 0, "M"},
	/* 50*/	{N, 0, 0, 0, "L"},
	/* 51*/	{N, 0, 0, 0, "R"},
	/* 52*/	{N, 0, 0, 0, "G"},
	/* 53*/	{N, 0, 0, 0, "I"},
	/* 54*/	{N, 0, 0, 0, "P"},
	/* 55*/	{N, 0, 0, 0, "C"},
	/* 56*/	{N, 0, 0, 0, "V"},
	/* 57*/	{N, 0, 0, 0, "E"},
	/* 58*/	{N, 0, 0, 0, "Z"},
	/* 59*/	{N, 0, 0, 0, "D"},
	/* 60*/	{N, 0, 0, 0, "B"},
	/* 61*/	{N, 0, 0, 0, "S"},
	/* 62*/	{N, 0, 0, 0, "Y"},
	/*from here on are actually code 1-45, upper half of font */
	/* 63*/	{N, 0, 0, 0, "F"},
	/* 64*/	{N, 0, 0, 0, "X"},
	/* 65*/	{N, 0, 0, 0, "A"},
	/* 66*/	{N, 0, 0, 0, "W"},
	/* 67*/	{N, 0, 0, 0, "J"},
	/* 68*/	{N, 0, 0, 0, "U"},
	/* 69*/	{N, 0, 0, 0, "K"},
	/* 70*/	{N, 0, 0, 0, "0"},
	/* 71*/	{N, 0, 0, 0, "1"},
	/* 72*/	{N, 0, 0, 0, "2"},
	/* 73*/	{N, 0, 0, 0, "3"},
	/* 74*/	{N, 0, 0, 0, "4"},
	/* 75*/	{N, 0, 0, 0, "5"},
	/* 76*/	{N, 0, 0, 0, "6"},
	/* 77*/	{N, 0, 0, 0, "7"},
	/* 78*/	{N, 0, 0, 0, "8"},
	/* 79*/	{N, 0, 0, 0, "9"},
	/* 80*/	{N, 0, 0, 0, "*"},
	/* 81*/	{N, 0, 0, 0, "-"},
	/* 82*/	{N, 0, 0, 0, "fi"},
	/* 83*/	{N, 0, 0, 0, "fl"},
	/* 84*/	{N, 0, 0, 0, "ff"},
	/* 85*/	{N, 0, 0, 0, "ct"},
	/* 86*/	{N, 0, 0, 0, "Fl"},
	/* 87*/	{N, 0, 0, 0, "Fi"},
	/* 88*/	{N, 0, 0, 0, "("},
	/* 89*/	{N, 0, 0, 0, ")"},
	/* 90*/	{N, 0, 0, 0, "["},
	/* 91*/	{N, 0, 0, 0, "]"},
	/* 92*/	{N, 0, 0, 0, "de"},
	/* 93*/	{N, 0, 0, 0, "dg"},
	/* 94*/	{N, 0, 0, 0, "="},
	/* 95*/	{N, 0, 0, 0, "rg"},
	/* 96*/	{N, 0, 0, 0, ":"},
	/* 97*/	{N, 0, 0, 0, "+"},
	/* 98*/	{N, 0, 0, 0, NOC},
	/* 99*/	{N, 0, 0, 0, "!"},
	/*100*/	{N, 0, 0, 0, "bu"},
	/*101*/	{N, 0, 0, 0, "?"},
	/*102*/	{N, 0, 0, 0, "fm"},
	/*103*/	{N, 0, 0, 0, "|"},
	/*104*/	{N, 0, 0, 0, NOC},
	/*105*/	{N, 0, 0, 0, "co"},
	/*106*/	{N, 0, 0, 0, "sq"},
	/*107*/	{N, 0, 0, 0, "$"}
};

struct troff2befont dtSymFont[] = {
/*          +-------------------------------- Troff character number
	    |
            |    +--------------------------- N: standard fonts
            |    |                            S: symbol font
            |    |                            D: draw macro
            |    |
            |    |  +------------------------ X-shift (scaled by point)
            |    |  |                         Note: positive is right.
            |    |  |
            |    |  |  +--------------------- Y-shift (scaled by point)
            |    |  |  |                      Note: positive is up.
            |    |  |  |
            |    |  |  |  +------------------ Point scale factor
            |    |  |  |  |
            |    |  |  |  |   +-------------- Sequence
            |    |  |  |  |   |
            |    |  |  |  |   |
            v    v  v  v  v   v */
	/*  0*/	{S, 0, 0, 0, "*q"},
	/*  1*/	{S, 0, 0, 0, "*h"},
	/*  2*/	{S, 0, 0, 0, "*n"},
	/*  3*/	{S, 0, 0, 0, "*m"},
	/*  4*/	{S, 0, 0, 0, "*l"},
	/*  5*/	{S, 0, 0, 0, "*i"},
	/*  6*/	{S, 0, 0, 0, "*z"},
	/*  7*/	{S, 0, 0, 0, "*s"},
	/*  8*/	{S, 0, 0, 0, "*d"},
	/*  9*/	{S, 0, 0, 0, "*b"},
	/* 10*/	{S, 0, 0, 0, "*c"},
	/* 11*/	{S, 0, 0, 0, "*y"},
	/* 12*/	{S, 0, 0, 0, "*f"},
	/* 13*/	{S, 0, 0, 0, "*u"},
	/* 14*/	{S, 0, 0, 0, "*k"},
	/* 15*/	{S, 0, 0, 0, NOC},
	/* 16*/	{S, 0, 0, 0, "*p"},
	/* 17*/	{S, 0, 0, 0, "@"},
	/* 18*/	{S, 0, 0, 0, "da"},
	/* 19*/	{S, 0, 0, 0, NOC},
	/* 20*/	{S, 0, 0, 0, "*a"},
	/* 21*/	{S, 0, 0, 0, "or"},
	/* 22*/	{S, 0, 0, 0, "*x"},
	/* 23*/	{N, 0, 0, 0, "\""},
	/* 24*/	{S, 0, 0, 0, "*e"},
	/* 25*/	{S, 0, 0, 0, "eq"},
	/* 26*/	{S, 0, 0, 0, "*o"},
	/* 27*/	{S, 0, 0, 0, "<-"},
	/* 28*/	{S, 0, 0, 0, "*r"},
	/* 29*/	{S, 0, 0, 0, "ua"},
	/* 30*/	{S, 0, 0, 0, "*t"},
	/* 31*/	{S, 0, 0, 0, "ul"},
	/* 32*/	{N, 0, 0, 0, "\\"},
	/* 33*/	{S, 0, 0, 0, "*Q"},
	/* 34*/	{S, 0, 0, 0, "bs"},
	/* 35*/	{S, 0, 0, 0, "if"},
	/* 36*/	{S, 0, 0, 0, "*g"},
	/* 37*/	{S, 0, 0, 0, "ip"},
	/* 38*/	{S, 0, 0, 0, "pt"},
	/* 39*/	{S, 0, 0, 0, "rh"},
	/* 40*/	{S, 0, 0, 0, "*w"},
	/* 41*/	{S, 0, 0, 0, NOC},
	/* 42*/	{S, 0, 0, 0, "gr"},
	/* 43*/	{S, 0, 0, 0, NOC},
	/* 44*/	{S, 0, 0, 0, "*F"},
	/* 45*/	{S, 0, 0, 0, "*H"},
	/* 46*/	{S, 0, 0, 0, "*W"},
	/* 47*/	{S, 0, 0, 0, "cu"},
	/* 48*/	{S, 0, 0, 0, "rn"},
	/* 49*/	{S, 0, 0, 0, "ts"},
	/* 50*/	{S, 0, 0, 0, "*L"},
	/* 51*/	{S, 0, 0, 0, "mi"},
	/* 52*/	{S, 0, 0, 0, "*G"},
	/* 53*/	{S, 0, 0, 0, "is"},
	/* 54*/	{S, 0, 0, 0, "*P"},
	/* 55*/	{S, 0, 0, 0, "sb"},
	/* 56*/	{S, 0, 0, 0, "sp"},
	/* 57*/	{S, 0, 0, 0, "ap"},
	/* 58*/	{S, 0, 0, 0, "pd"},
	/* 59*/	{S, 0, 0, 0, "*D"},
	/* 60*/	{S, 0, 0, 0, "sr"},
	/* 61*/	{S, 0, 0, 0, "*S"},
	/* 62*/	{S, 0, 0, 0, "~="},
	/* 63*/	{S, 0, 0, 0, ">"},
	/* 64*/	{S, 0, 0, 0, "*C"},
	/* 65*/	{S, 0, 0, 0, "<"},
	/* 66*/	{S, 0, 0, 0, "/"},
	/* 67*/	{S, 0, 0, 0, "ca"},
	/* 68*/	{S, 0, 0, 0, "*U"},
	/* 69*/	{S, 0, 0, 0, "no"},
	/* 70*/	{S, 0, 0, 0, "rc"},
	/* 71*/	{S, 0, 0, 0, "lt"},
	/* 72*/	{S, 0, 0, 0, "bv"},
	/* 73*/	{S, 0, 0, 0, "lk"},
	/* 74*/	{S, 0, 0, 0, "lb"},
	/* 75*/	{S, 0, 0, 0, "rt"},
	/* 76*/	{S, 0, 0, 0, "rk"},
	/* 77*/	{S, 0, 0, 0, "rb"},
	/* 78*/	{S, 0, 0, 0, "rf"},
	/* 79*/	{S, 0, 0, 0, "lf"},
	/* 80*/	{S, 0, 0, 0, "lc"},
	/* 81*/	{S, 0, 0, 0, "mu"},
	/* 82*/	{S, 0, 0, 0, "di"},
	/* 83*/	{S, 0, 0, 0, "+-"},
	/* 84*/	{S, 0, 0, 0, "<="},
	/* 85*/	{S, 0, 0, 0, ">="},
	/* 86*/	{S, 0, 0, 0, "=="},
	/* 87*/	{S, 0, 0, 0, "!="},
	/* 88*/	{S, 0, 0, 0, "{"},
	/* 89*/	{S, 0, 0, 0, "}"},
	/* 90*/	{N, 0, 0, 0, "aa"},
	/* 91*/	{N, 0, 0, 0, "ga"},
	/* 92*/	{S, 0, 0, 0, "^"},
	/* 93*/	{S, 0, 0, 0, "#"},
	/* 94*/	{S, 0, 0, 0, "lh"},
	/* 95*/	{S, 0, 0, 0, "mo"},
	/* 96*/	{N, 0, 0, 0, "~"},
	/* 97*/	{S, 0, 0, 0, "es"},
	/* 98*/	{S, 0, 0, 0, NOC},
	/* 99*/	{N, 0, 0, 0, "dd"},
	/*100*/	{S, 0, 0, 0, "br"},
	/*101*/	{S, 0, 0, 0, "**"},
	/*102*/	{S, 0, 0, 0, "ib"},
	/*103*/	{S, 0, 0, 0, "ci"},
	/*104*/	{S, 0, 0, 0, NOC},
	/*105*/	{S, 0, 0, 0, "pl"},
	/*106*/	{S, 0, 0, 0, "->"},
	/*107*/	{N, 0, 0, 0, "sc"}
};

#ifdef	DT
#include "dt.h"

#define	USED	01

int dtresolution = DTRESOLUTION;

dtPage() {
    pagePending = 1;
}

static
doPageStart() {
    currentPage++;
    pagePending = 0;
    printf("p%d\n", currentPage);
}


dtSetFont(font, points)
int font, points; {
    if (lastPoints != points || font != lastFont) {
	if (!(fonttable[font].flags)&USED)
	    printf("x font %d %s\n", font+1, fonttable[font].troffName);
	fonttable[font].flags |= USED;
	printf("f%d\n", font+1);
	printf("s%d\n", points);
	lastPoints = points;
	lastFont = font;
    }
}

dtChar(x, y, font, points, troffChar, sequence)
long x, y;
int font, points, troffChar;
char *sequence; {
    register int nx = TROFF2DTX(x), ny = TROFF2DTY(y);
    register struct troff2befont *rp;
    if (pagePending) {
	resetState();
	doPageStart();
    }

    DBP((D_BEND,"x,y=%d,%d; font=%d, points=%d, tc=%d\n",
	x, y, font, points, troffChar));

    if (font == 3) {
	rp = &be->besymfont[troffChar];
    } else {
	rp = &be->bestdfont[troffChar];
    }

    switch(rp->t2b_font) {
	/* Only fonts with "N" are subject to font translation */
	case N:
	    if (font == 3)
		font = 0;	/* Special chars are Courier */
	    else {
		DBP((D_BEND, "dtSetChar %d->%s (%s)\n", font,
		    xlatetable[font]->troffName,
		    xlatetable[font]->fontName));
		font = xlatetable[font] - fonttable;
	    }
	    break;
	case S:
	    font = 3;
	    break;
	case D:
	    break;
	default:
	/* Typically used when the R and S fonts don't have the
	   character desired, so select the font via the index
	   in the fonts.?? file */
	    font = rp->t2b_font;
	    break;
    }

    if (!sequence)
	sequence = rp->t2b_charseq;

    if (!sequence) {
	fprintf(stderr, "No coding for %d\n", troffChar);
	return;
    }

    /*	We're committed now - the "if" statements avoid floating
	arithmetic on slow machines */

    if (rp->t2b_scale) points *= (.01 * rp->t2b_scale);
    if (rp->t2b_xc) nx += points * (.01 * rp->t2b_xc);
    if (rp->t2b_yc) ny += points * (.01 * rp->t2b_yc);

    dtSetFont(font, points);
#ifdef	NOTYET
    if (rp->t2b_font == D)
	printf("H%d\nV%d\nc%s\n", nx, ny, sequence);
    else {
#endif
	/* print an nnc sequence if we can...may even be able to avoid
	   the newline. */

	if (lastYPos == ny &&
	    sequence[1] == 0 &&
	    lastXPos != -1 &&
	    (nx - lastXPos) > 0 && (nx - lastXPos) < 100) {

	    printf("%02d%c\n",(nx - lastXPos), sequence[0]);

	} else {

	    printf("H%d\n", nx);

	    if (lastYPos != ny) {
		printf("V%d\n", ny);
		lastYPos = ny;
	    }
	    if (sequence[1])
		printf("C%s\n", sequence);
	    else
		printf("c%s\n", sequence);
	}
#ifdef	NOTYET
    }
#endif
}

dtProlog() {
    extern char *ctime();
    extern char *strchr();
    extern char nodename[];
    extern char *device;
    char buffer[30];
    long curtime;
#ifdef	OPT
    extern int optimize;

    optimize = 0;
#endif

    currentPage = 0;
    pagePending = 1;

    time(&curtime);
    strcpy(buffer, ctime(&curtime));
    *strchr(buffer, '\n') = '\0';

    getnodename();

#ifndef	NOCHATTER
    printf("#Title: (stdin)\n");
    printf("#Creator: %s %s\n", progname, shortversion);
    printf("#PsroffVersion: %s\n", version);
    printf("#CreationDate: %s\n", buffer);
    printf("#For: %s\n", username);
    printf("#Pages: (atend)\n");
    printf("#DocumentFonts: (atend)\n");
    printf("#EndComments\n");
#endif
    printf("x T %s\n", device);
    printf("x res %d %d %d\n", dtresolution, 1, 1);
    printf("x init\n");
    doprologs();

}

dtPassthru(s)
register char *s; {
    printf("x X %s\n", s);
}

dtEpilog() {
    printf("x trailer\n");
    printf("x stop\n");
}

#endif /* DT */
