#include "defs.h"

#ifndef	lint
static char SCCSid[] =
    "@(#)debug.c: 2.1 Copyright 90/07/18 16:51:21 Chris Lewis";
#endif

#ifdef	DEBUG

int debug = 0;

#define	D_CAT	1
#define	D_SPEC	2
#define	D_CHAR	4
#define	D_FONT	8
#define	D_BEND	0x10
#define	D_PK	0x20
#define	D_VERB	0x40
#define	D_FLSH	0x80

struct dbm {
    char req;
    int bit;
} dbm[] = {
    {'c', D_CAT},
    {'s', D_SPEC},
    {'C', D_CHAR},
    {'f', D_FONT},
    {'F', D_FLSH},
    {'b', D_BEND},
    {'p', D_PK},
    {'v', D_VERB},
    {'A', ~0},
    {0, 0}
};

setdebug(str, df)
char *str, *df; {
    register struct dbm *d;
    for(;*str; str++) {
	for(d = dbm; d->req; d++)
	    if (d->req == *str) {
		debug |= d->bit;
		break;
	    }
	if (!d->req) {
	    fprintf(stderr, "%s: don't understand %c debug flag\n",
		progname, *str);
	    exit(1);
	}
    }

    if (debug) {
	if (!(diagFile = fopen(df, "w"))) {
	    fprintf(stderr, "%s: Cannot open diagnostics file (%s)\n",
		progname, df);
	    exit(1);
	}
	fprintf(diagFile, "Debug flags: %x\n", debug);
    }
}

#ifdef VFPRINTF
#include <varargs.h>
/* VARARGS */
dprintf(level, va_alist)
int level;
va_dcl
{
	va_list args;
	char *fmt;

	if (!(debug&level))
	    return;

	va_start(args);
	fmt = va_arg(args, char *);
	VFPRINTF(diagFile, fmt, args);
	va_end(args);
	if (debug&D_FLSH)
	    fflush(diagFile);
}
#else
/* VARARGS1 ARGSUSED */
dprintf(level, fmt, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
int level;
char	*fmt;
int	a1, a2, a3, a4, a5, a6, a7, a8, a9, a10; {
	char buf[BUFSIZ];

	if (!(debug&level))
	    return;

	sprintf(buf, fmt, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
	fprintf(diagFile, buf);
	if (debug&D_FLSH)
	    fflush(diagFile);
}
#endif
#endif

char *
mustmalloc(n, msg)
int n;
char *msg; {
    extern char *malloc();
    register char *p = malloc((unsigned) n);
    if (!p) {
	pkmsg("%s: Out of space! (requesting %d bytes, key: %s)\n",
	    progname, n, msg);
	abort();
    }
    clrarray(p, n);
    return(p);
}

#ifdef	BCOPY
/*	"slowish" routines when you don't have memcpy and friends
 */
bcopy(from, to, len)
register char *from, *to;
register int n; {
    while(n--)
	*to++ = *from++;
}
bzero(array, len)
register char *array;
register int len; {
    while(n--)
	*array++ = '\0';
}
#endif
