%%STARTSHELL%%
#	Psroff checking script 2.1 90/07/18
chkinst=false
for i
do
    case $i in
	install)
	    chkinst=true
	    ;;
	*)
	    printerlist="$printerlist $i"
	    ;;
    esac
done
eval "`sed -n -e 's/[()]//g' \
	      -e 's/^LIBDIR.*=[ 	]*/LIBDIR=/p' \
	      -e 's/^LJF.*=[ 	]*/LJF=/p' \
	      -e 's/^FONTDIR.*=[ 	]*/FONTDIR=/p' \
	     Makefile`"
echo "LIBDIR  = $LIBDIR"
echo "LJF     = $LJF"
echo "FONTDIR = $FONTDIR"
if [ -z "$FONTDIR" ]
then
    echo "ERROR: That's odd, can't find a FONTDIR setting in Makefile"
elif [ ! -d $FONTDIR ]
then
    echo "ERROR: That's really odd, no such directory $FONTDIR"
    echo "       This is where CAT's width tables are supposed to be"
    echo "       It is usually /usr/lib/font"
    FONTDIR=
fi
if [ -z "$LIBDIR" ]
then
    echo "ERROR: Bad configuration - no LIBDIR setting"
    exit 1
elif [ ! -d $LIBDIR ]
then
    echo "INFO: You've not installed psroff yet - no LIBDIR ($LIBDIR) exists"
    if $chkinst
    then
	echo "ERROR: Can't check installed version unless it's installed"
	exit 1
    fi
fi

if $chkinst
then
    psrofflib=$LIBDIR/lib/psrofflib
    libbase=$LIBDIR/lib
else
    psrofflib=lib/psrofflib
    libbase=lib
fi

if [ ! -r $psrofflib ]
then
    echo "ERROR: no $psrofflib to check"
    exit 1
fi

eval `grep '^troff=' $psrofflib`
echo "INFO: Your troff setting in psrofflib is troff=$troff"
if [ -n "$troff" ]
then
    # This should be -x, but Ultrix sh doesn't believe in it
    if [ ! -f $troff ]
    then
	echo "ERROR: troff setting in $psrofflib ($troff) doesn't exist"
	troff=
    fi
else
    mpath=`echo $PATH | sed -e 's/^:/.:/' -e 's/:$/:./' -e 's/:/ /g'`
    echo "INFO: Your path is $mpath"
    for i in $mpath
    do
	if [ -f $i/troff ]
	then
	    echo "INFO: Troff appears to be $i/troff"
	    troff=$i/troff
	    break
	fi
    done
fi

eval `grep '^trofftype=' $psrofflib`
echo "INFO: Your trofftype setting in $psrofflib is trofftype='$trofftype'"
if [ -n "$FONTDIR" ]
then
    arglist="-F$FONTDIR/./ftXX"
fi
for i in $arglist -T. ''
do
    echo "INFO: Testing '$i' trofftype setting"
    $troff -t < /dev/null $i > /dev/null
    rc=$?
    if [ $rc = 0 ]
    then
	echo "... $i worked"
	case $i in
	    -F*)
		workingtype="-F$FONTDIR/\$width/ftXX"
		;;
	    -T*)
		if [ -n "$FONTDIR" -a "$FONTDIR" != /usr/lib/font ]
		then
		    echo "ERROR: FONTDIR must be /usr/lib/font with this"
		    echo "       type of troff"
		fi
		workingtype="-T\$width"
		;;
	    *)
		echo "INFO: Poor you, your troff doesn't understand -T or -F."
		echo "      This means that you'll have to put all of your"
		echo "      width files directly in $FONTDIR, and you'll not"
		echo "      be able to support multiple sets of width tables"
		workingtype=" "
		;;
	esac
	break
    else
	echo "... $i didn't work"
    fi
done
if [ -z "$workingtype" ]
then
    echo "ERROR: Oh my, your troff doesn't seem to work AT ALL!"
    echo "       It's giving me non-zero return codes when I try"
    echo "       all of the known different ways of setting width table"
    echo "       directory (including none!).  Egads.  Get Help!!!!!!!"
    exit 1
fi

if [ "$workingtype" != "$trofftype" ]
then
    echo "ERROR: You should have trofftype='$workingtype' in $psrofflib"
    echo "       Psroff won't work AT ALL without this fixed"
else
    echo "INFO: Your trofftype setting ($trofftype) appears correct"
fi

if [ ! -r $FONTDIR/ftR ]
then
    echo "INFO: There isn't a $FONTDIR/ftR (it should be if you've installed"
    echo "      Troff on your system.  Without it, I can't test HEADERSIZE"
else
    hdrsize=`sed -n \
	-e 's/^#define[ 	]*HEADERSIZE[ 	]*\([0-9]*\).*/\1/p' defs.h`
    echo "INFO: You have HEADERSIZE defined as $hdrsize"
    bytecount=`wc -c $FONTDIR/ftR | sed -e 's/^[ 	]*//g' -e 's/[ 	].*//`
    case $bytecount in
	224)
	    echo "INFO: You appear to have a Xenix-like troff - width tables"
	    echo "      have no extraneous garbage.  Lucky you!"
	    acthdr=0
	    ;;
	*)
	    echo "INFO: H'mm, you don't have a Xenix-like troff - Assuming"
	    echo "      your troff puts a.out.h headers on width tables, I"
	    echo "      will try compiling a teensy program to find out how"
	    echo "      big a.out.h headers actually are...."
	    cat > AUDITP.c <<\!
#include <a.out.h>
#ifdef	X_EXEC
/*	Xenix I think.... */
#define	HEADERSIZE sizeof(struct xexec)
#endif
#ifdef	F_LNNO
/*	COFF format headers */
#define	HEADERSIZE (-sizeof(struct filehdr))
#endif
#ifndef HEADERSIZE
/*	Generalized V7 or BSD - non-coff format headers */
#define	HEADERSIZE sizeof(struct exec)
#endif
main() {
printf ("%d\n", HEADERSIZE);
}
!
	    rm -f AUDITP
	    if [ -z "$MAKE" ]
	    then
		MAKE=make
	    fi
	    $MAKE AUDITP > /dev/null 2>&1
	    if [ ! -f AUDITP ]
	    then
		echo "INFO: H'm, Wouldn't compile ..."
		#	Common for 32 bitters (Sun/Ultrix f'r instance)
		acthdr=-32
	    else
		acthdr=`./AUDITP`
	    fi
	    rm -f AUDITP AUDITP.c
	    case $acthdr in
		-*)
		    echo 'INFO: The following HEADERSIZE is *purely* a guess:'
		    acthdr=`echo $acthdr | sed -e 's/-//'`
		    ;;
	    esac
	    echo "INFO: It looks like HEADERSIZE should be $acthdr"
	    ;;
    esac
    if [ "$hdrsize" != "$acthdr" ]
    then
	echo "ERROR: HEADERSIZE should be set to $acthdr, not $hdrsize"
    else
	echo "INFO: HEADERSIZE appears to be set correctly to 0"
    fi
fi

Topts="`sed -e '/^[a-zA-Z]/!d' -e '/^troff/d' \
	-e '/^trofftype/d' -e 's/[ 	].*//' $psrofflib`"
echo "INFO: Commencing psrofflib ($psrofflib) checking"
if $chkinst
then
    msgtyp='ERROR  '
    troff2ps=$LIBDIR/troff2ps
else
    msgtyp='WARNING'
    troff2ps=./troff2ps
fi

if [ ! -f $troff2ps ]
then
    echo "WARNING: Can't test drivers, because troff2ps isn't built"
fi
rm -f PRINTERLIST

for type in $Topts
do
    troff="<not set>"
    trofftype="<not set>"
    width="<not set>"
    t2arg="<not set>"
    lparg="<not set>"
    ptr="<not set>"
    line=`sed -n -e '/^troff/p' \
		 -e "/^$type[ 	]/{
		     s/^$type[ 	]*\(.*\)$/F='T' \1/p
		     q
		    }" $psrofflib`
    eval "$line"
    echo "INFO: psroff -T$type settings:"
    echo "      troff      $troff"
    echo "      trofftype  $trofftype"
    echo "      width      $width"
    if [ -n "$FONTDIR" -a ! -d $FONTDIR/$width ]
    then
	echo "   * $msgtyp: FONTDIR/$width not installed yet"
	echo "              psroff -T$width won't work until you do"
    fi
    if [ ! -d widths/width${width} ]
    then
	echo "   * WARNING: no widths/width${width} directory"
    fi
    echo "      t2arg      $t2arg"
    drivertype=`echo $t2arg | sed -n -e 's/.*-T\([^	 ]*\).*/\1/p'`
    printertype=`echo $t2arg | sed -n -e 's/.*-p\([^ 	]*\).*/\1/p'`
    if [ -z "$drivertype" ]
    then
	echo "   * INFO   : no -T in $psrofflib t2arg - assuming ps"
	drivertype=ps
    fi
    if [ -z "$printertype" ]
    then
	printertype=$drivertype
    fi
    echo "          Driver type: $drivertype, library prefix: $printertype"
    if [ -f $troff2ps ]
    then
	$troff2ps -T$drivertype < /dev/null > /dev/null 2>&1
	if [ $? != 0 ]
	then
	    echo "   * ERROR  : troff2ps driver $drivertype not" \
		"configured psroff -T$width will die"
	fi
    fi
    set +x
    echo "      lparg      $lparg"
    echo "      ptr        $ptr"
    if [ ! -r $libbase/$printertype.lib ]
    then
	echo "   * WARNING: no $libbase/$printertype.lib (no prolog)"
    fi
    if [ ! -r $libbase/$printertype.fonts ]
    then
	echo "   * ERROR  : Can't find $libbase/$printertype.fonts"
	echo "              Won't be able to give you list of fonts available"
	continue
    fi
    echo "See $printertype.fonts below for listing of fonts"
    echo $printertype >> PRINTERLIST
done

if [ -z "$printerlist" ]
then
    printerlist=`sort -u PRINTERLIST`
fi
rm -f PRINTERLIST

for printertype in $printerlist
do
    (
	if [ -n "$FONTDIR" -a -d "$FONTDIR/$printertype" ]
	then
	    ls $FONTDIR/$printertype | sed -n -e 's/^.*ft//p' | sort -u
	fi
	echo "troff2ps"
	cat $libbase/$printertype.fonts
    ) | awk '
    BEGIN {
	fontdir = "'"$FONTDIR"'"
	printertype = "'"$printertype"'"
	catfonts[""] = 0
	fonts[""] = 0
	printf("\n\nPrinter type %s.fonts\n\n", printertype);
	printf("%-4s %-20s %-25s %s\n", "Cat", "English Name", "Sequence", \
	    "Flags");
	printf("Name\n\n");
	ignoring = 0
    }
    $1 == "troff2ps" {
	startlisting = 1;
	next
    }
    $1 == "normal" || $1 == "symbol" {
	ignoring = 1
    }
    $1 !~ /^[A-Za-z][A-Za-z]*/ {
	next
    }
    NF >= 1 {
	if (ignoring)
	    next
	if (startlisting) {
	    english = ""
	    sequence = ""
	    flags = ""
	    name = $1
	    if (NF > 1)
		english = $2
	    if (NF > 2)
		sequence = $3
	    if (NF > 3)
		flags = $4
	    printf("%-4s %-20s %-25s %s\n", name, english, sequence, flags);
	    fonts[name] = 1
	} else {
	    catfonts[$1] = 1
	    ftdirfound = 1
	}
    }
    END {
	if (ftdirfound) {
	    for (name in fonts) {
		if (name && !catfonts[name])
		    printf("  FONT %s: don't use: %s/%s/ft%s not installed\n",\
			name, fontdir, printertype, name);
	    }
	}
	for (name in catfonts) {
	    if (name && !fonts[name])
		printf("  FONT %s: don't use: %s/%s/ft%s exists, but"
		    name, fontdir, printertype, name)
		printf(" no %s.fonts\n", printertype)
	}
    }'
    if [ -n "$LJF" -a -d "$LJF" -a "$printertype" = lj ]
    then
	sed -e '/^[A-Za-z][A-Za-z]*/!d' $libbase/$printertype.fonts |
	    while read troffname english sequence flags
	    do
	        for i in 6 7 8 9 10 11 12 14 16 18 20 22 24 28 36
		do
		    suffix=
		    case $flags in
			n* | b*) ;;
			p*)
			    suffix=pk
			    ;;
			s*)
			    suffix=sfp
			    ;;
		    esac
		    if [ -n "$suffix" -a ! -r $LJF/$troffname.$i.$suffix ]
		    then
			echo "ERROR: $LJF/$troffname.$i.$suffix missing"
		    fi
		    flags=`echo $flags | sed -e 's/.\(.*\)/\1/'`
		done
	    done
    fi
done
