/* ta=4 */
/****************************************************************************
*				p s b a n n e r . c		v 2.0								*
*																			*
*	Print a banner page on a postscript printer for Xenix 2.2.3				*
*																			*
*	The generated print stream is NOT minimally conforming as per Red Book.	*
*																			*
*	Tony Field.       tony@ajfcal  											*
****************************************************************************/

#include <stdio.h>
#include "patchlevel.h"


/*	setup paper dimensions									*/

typedef struct		 			/*	measurement in point					*/
{	char	paper_name[60];		/*	name of paper size (for command line)	*/
	char	paper_tray[200];	/*	postscript operator to select this tray	*/
	int		width;				/*	portrait point width of paper			*/
	int		height;				/*	portrait point height of paper			*/
	int		lx, ly, ux, uy;
} measure;

measure	*p;		/*	working set of parameters  (points to something below) 	*/

				/*	standard paper sizes in portrait layout.				 */

measure	page_types[30] =
{			{ 	"letter",
				"statusdict begin lettertray end",
				  612,   792,    18,    15,   593,   777
			},
			{ 	"legal",
				"statusdict begin legaltray end",
				  612,  1008,    18,    15,   593,   993
			},
			{	"a4",
				"statusdict begin a4tray end",
				  595,   842,    18,    15,   578,   827
			},
			{	"b5",
				"statusdict begin b5tray end",
				  516,   729,    18,    15,   497,   712
			},
			{	"",			/* end of paper list */
				"",
				 0, 0,  0,  0, 0, 0
			}
};

char	slots[4][100] = 
{			"statusdict begin 1 setpapertray end",
			"statusdict begin 2 setpapertray end",
			"",
			""
} ;
int		nslots = 2;

int	X_INDENT	= 30;		/*	points						*/
int Y_INDENT	= 30;
int	BIG_POINT	= 60;		/* changes to point size automatically scale	*/
int MED_POINT	= 35;		/* the printout.								*/
int	SMALL_POINT	= 15;
int	UX, UY, DX, DY, MAX_X, MAX_Y;

/*	The following arguments are received in the command line
	argvp[9] and argv[10] may be page size and paper tray specifications.
*/

#define	Userid		argv[1]
#define	Name		argv[2]
#define	Requestid	argv[3]
#define	Printer		argv[4]
#define	Options		argv[5]
#define	Date		argv[6]
#define	Machineid	argv[7]
#define	Title		argv[8]

main (argc, argv)
int		argc;
char	*argv[];
{	int		x, y, c, i, set_paper_tray, set_paper_bin;
	char	line[200];
	FILE	*pdef;
	
	if ((pdef = fopen (PDEF, "r")) != NULL)
	{	nslots = 0;
		fgets (line, 199, pdef);
		for (i = 0;  i < 25;  i++)
		{	if (fgets (line, 199, pdef) == NULL)
				break;
			trim (line);
			if (strncmp (line, "*fonts", 6) == 0)
				break;
			strcpy (page_types[i].paper_name, line);
			if (fgets (page_types[i].paper_tray, 199, pdef) == NULL)
				bad_file();
			trim (page_types[i].paper_tray);
			if (fgets (line, 100, pdef) == NULL)
				bad_file();
			trim (line);
			sscanf (line, "%d%d%d%d%d%d",
				&page_types[i].width,
				&page_types[i].height,
				&page_types[i].lx,
				&page_types[i].ly,
				&page_types[i].ux,
				&page_types[i].uy);

		}
		page_types[i].paper_name[0] = '\0';

		while (fgets (line, 199, pdef) != NULL)
		{	if (strncmp (line, "*slots", 6) == 0)
			{	while (fgets (line, 90, pdef) != NULL)
				{	trim (line);
					if (strncmp (line, "*eof", 4) == 0)
						break;
					if (*line)
					{	strcpy (slots[nslots], line);
						if (++nslots > 3)
							break;
					}
				}
			}
		}
		fclose (pdef);
	}
	
	MAX_X = page_types[0].width;
	MAX_Y = page_types[0].height;
	set_paper_bin = 0;
	set_paper_tray = -1;
	
	for (i = 9;  i < argc;  i++)
	{	c = argv[i][1];
		switch (c)
		{
		case 'b':
			if ((set_paper_bin = atoi (argv[i+1])) > nslots)
			{	fprintf (stderr, "paper bin greater than %d\n", nslots);
				exit (1);
			}
			i++;
			break;

		case 'g':
			for (set_paper_tray = 0;  page_types[set_paper_tray].paper_name[0];  set_paper_tray++)
			{	if (compare (argv[i+1], page_types[set_paper_tray].paper_name) == 0)
				{	MAX_X = page_types[set_paper_tray].width;
					MAX_Y = page_types[set_paper_tray].height;
					break;
				}
			}
			if (page_types[set_paper_tray].paper_name[0] == '\0')
			{	fprintf (stderr, "Invalid paper size\n");
				exit (1);
			}
			i++;
			break;

		default: ;
		}
	}

	UX	=	X_INDENT;
	UY	=	(MAX_Y - Y_INDENT);
	DX	=	(MAX_X - 2 * X_INDENT);
	DY	=	(BIG_POINT * 3);

	/*	center text used for userid and job title print  */
	
	send ("%!\n");
	send ("/ctext {     % center text:   string x y dx\n");
	send ("   2 div\n");
	send ("   /Dx exch def\n");
	send ("   /Yv exch def\n");
	send ("   /Xv exch def\n");
	send ("   dup stringwidth pop\n");
	send ("   2 div\n");
	send ("   Dx exch sub\n");
	send ("   Xv add\n");
	send ("   Yv moveto\n");
	send ("   show\n");
	send ("} def\n");
	send ("%%EndProlog\n");

	send ("%%Page: ? 1\n");
	if (set_paper_bin)
		printf ("%s\n", slots[set_paper_bin-1]);

	if (set_paper_tray >= 0)
		printf ("%s\n", page_types[set_paper_tray].paper_tray);
		
	send ("/pg save def\n");

	/*	draw a box for the userid */
	
	printf ("newpath\n");
	printf ("%d %d moveto\n", UX,UY);
	printf ("%d %d rlineto\n", DX, 0);
	printf ("%d %d rlineto\n", 0, -DY);
	printf ("%d %d rlineto\n", -DX, 0);
	printf ("closepath\n");
	printf ("4 setlinewidth\n");
	printf ("stroke\n");

	/*	center the userid and the job title */
	
	y = UY - DY / 2 - BIG_POINT / 2;
	printf ("/Helvetica-BoldOblique findfont %d scalefont setfont\n", BIG_POINT);
	printf ("(%s) %d %d %d ctext\n", Userid, X_INDENT, y, DX);

	y = UY - (DY + MED_POINT * 3);
	printf ("/Helvetica-Bold findfont %d scalefont setfont\n", MED_POINT);
	printf ("(%s) %d %d %d ctext\n", Title, X_INDENT, y, DX);

	/*	print other banner page parameters */
	
	x = X_INDENT;
	y -= (MED_POINT * 2);
	printf ("%d %d moveto\n", x,y);	
	sendnormal ("User:       ");
	sendbold (Name);

	y -= SMALL_POINT + (SMALL_POINT / 2);
	printf ("%d %d moveto\n", x,y);	
	sendnormal ("Request ID: ");
	sendbold (Requestid);
	
	y -= SMALL_POINT + (SMALL_POINT / 2);
	printf ("%d %d moveto\n", x,y);	
	sendnormal ("Printer ID: ");
	sendbold (Printer);
	
	y -= SMALL_POINT + (SMALL_POINT / 2);
	printf ("%d %d moveto\n", x,y);	
	sendnormal ("Options:    ");
	sendbold (Options);
	
	y -= SMALL_POINT + (SMALL_POINT / 2);
	printf ("%d %d moveto\n", x,y);	
	sendnormal ("Date:       ");
	sendbold (Date);
	
	y -= SMALL_POINT + (SMALL_POINT / 2);
	printf ("%d %d moveto\n", x,y);	
	sendnormal ("Machine:    ");
	sendbold (Machineid);

	send ("showpage pg restore\n");
	send ("%%Trailer\n");	
	exit (0);
}

send (s)
char	*s;
{
	while (*s)
		putchar (*s++);
}

sendnormal (s)
char 	*s;
{
	printf ("/Courier findfont %d scalefont setfont\n", SMALL_POINT);
	send ("(");
	send (s);
	send (")show\n");
}

sendbold (s)
char 	*s;
{
	printf ("/Helvetica-Bold findfont %d scalefont setfont\n", SMALL_POINT);
	send ("(");
	send (s);
	send (")show\n");
}

trim (s)
char	*s;
{
	while (*s)
	{	if (*s < ' ')
		{	*s = 0;
			break;
		}
		s++;
	}
}

bad_file()
{
	fprintf (stderr, "Bad %s file\n", PDEF);
	exit (1);
}

compare (a,b)
char	*a, *b;
{	int	aa, bb;

	while (*a  &&  *b)
	{	aa = *a++;
		bb = *b++;
		if (toupper (aa)  !=  toupper (bb))
			return (aa - bb);
	}
	return (0);
}

