/* ta=4 */
/*	allow user to select printer from various *.def files
	and also select defaule page size (letter, a4 etc)
	
	selected printer is in file		Ppsfprint.cfg
	seleted page size is in file	Ppagesize.cfg

	This also generates a postscript programme (psizes.ps) that should be
	sent to the printer to print out the actual imageable area.
*/

#include <stdio.h>

#define printerdef "Ppsfprint.cfg"

typedef struct		 			/*	measurement in point					*/
{	char	paper_name[60];		/*	name of paper size (for command line)	*/
	char	paper_tray[200];	/*	postscript operator to select this tray	*/
	int		width;				/*	portrait point width of paper			*/
	int		height;				/*	portrait point height of paper			*/
} measure;

char *psheader = "%!\n\
/getsize {\n\
	clippath\n\
	pathbbox\n\
} def\n\
/sendsize {\n\
	/ury exch def\n\
	/urx exch def\n\
	/lly exch def\n\
	/llx exch def\n\
	/str 64 string def\n\
	show\n\
	(  ) show\n\
	llx    ceiling cvi str cvs show\n\
	(  ) show\n\
	lly    ceiling cvi str cvs show\n\
	(  ) show\n\
	urx    floor cvi str cvs show\n\
	(  ) show\n\
	ury    floor cvi str cvs show\n\
} def\n\
/pg save def\n\
newpath\n";

char *psfont = "/Courier findfont 12 scalefont setfont\n";

char *pstail = "showpage \n\
pg restore\n\004";

char	printername[100];
int		defaultsize;

main (argc, argv)
int		argc;
char	*argv[];
{	int		i,j;
	int		many, n, pnumber;
	char	printers[100];
	FILE	*fp, *fpdef;

	if (argc < 2)
	{	fprintf (stderr, "Cannot find printer definition files (*.def)...\n");
		exit (1);
	}
	
refresh:
	puts ("\n\n                         SELECT PRINTER TYPE\n");
	many = 0;
	for (i = 1;  i < argc;  i++)
	{	if ((fp = fopen (argv[i], "r")) == NULL)
			exit (1);
		fgets (printers, 99, fp);
		trim (printers);
		n = strlen (printers);
		if (n < 35)
			n = 35;
		many += n;	
		if (many > 70)
		{	many = n;
			printf ("\n");
		}
		printf ("%2d: %-35s", i, printers);
		fclose (fp);
	}
	printf ("\n");
	do
	{	printf ("==> Select printer by number (q = quit, r = refresh display): ");
		gets (printers);
		if (toupper (*printers) == 'Q')
			exit (44);
		if (toupper (*printers) == 'R')
			goto refresh;
		pnumber = atoi (printers);
		if (pnumber < 1  ||  pnumber > argc)
			puts ("... Invalid printer number");
		else
			break;
	} while (1);
	if (access (argv[pnumber], 4) == 0)
	{
		if ((fpdef = fopen (printerdef, "w")) != NULL)
		{	fprintf (fpdef, "%s", argv[pnumber]);
			fclose (fpdef);
			getsize (argv[pnumber]);
			genpost (argv[pnumber]);
		}
		else
		{	fprintf (stderr, "Cannot create printer definition file: %s\n", printerdef);
			exit (1);
		}
		fclose (fp);
	}
	else
	{	fprintf (stderr, "Cannot find printer definition file: %s\n", argv[pnumber]);
		exit (1);
	}
	exit (0);
}
getsize (fn)
char	*fn;
{	char	ptypes[40][100];
	char	line[100];
	int		ntypes, i, ncol, pnumber;
	FILE	*fpdef;
		
	if ((fpdef = fopen (fn, "r")) != NULL)
	{	fgets (printername, 99, fpdef);
		trim (printername);
		ntypes = 1;
		for ( ; ; )
		{	fgets (line, 99, fpdef);
			if (*line == '*')
				break;
			trim (line);
			strcpy (ptypes[ntypes], line);
			fgets (line, 99, fpdef);
			fgets (line, 99, fpdef);
			ntypes++;
		}
		fclose (fpdef);

ref:
		printf ("\nPrinter is: %s\n\nSelect default page size:\n", printername);
		for (i = 1;  i < ntypes;  i++)
		{	printf ("%2d: %s\n", i, ptypes[i]);
		}
		do
		{	printf ("==> Select page size by number (q = quit, r = refresh display): ");
			gets (line);
			if (toupper (*line) == 'Q')
				exit (44);
			if (toupper (*line) == 'R')
				goto ref;
			pnumber = atoi (line);
			if (pnumber < 1  ||  pnumber > ntypes)
				puts ("... Invalid page size number");
			else
				break;
		} while (1);
		fclose (fpdef);
		ptypes[ntypes][0] = '\0';
		if ((pnumber > 0  &&  pnumber < ntypes)
			&& (fopen ("Ppagesize.cfg", "w")) != NULL)
		{
			fprintf (fpdef, "%s", ptypes[pnumber]);
			fclose (fpdef);
			defaultsize = pnumber - 1;
		}
	}
	else
	{	fprintf (stderr, "Cannot find printer definition file: %s\n", printerdef);
		exit (1);
	}
	exit (0);
}

genpost (f)
char	*f;
{
	FILE *pdef, *psfile;
	char	line[500];
	measure	page_types[40];
	int		i, j;
	int		x, y;
	
	if ((pdef = fopen (f, "r")) != NULL)
	{
		fgets (line, 100, pdef);
		for (i = 0;  i < 28;  i++)
		{	if (fgets (page_types[i].paper_name, 59, pdef) == NULL)
				break;
			trim (page_types[i].paper_name);
			if (page_types[i].paper_name[0] ==  '*')
				break;
			if (fgets (page_types[i].paper_tray, 199, pdef) == NULL)
				bad_file();
			trim (page_types[i].paper_tray);
			if (fgets (line, 100, pdef) == NULL)
				bad_file();
			trim (line);
			sscanf (line, "%d%d",
				&page_types[i].width,
				&page_types[i].height);

		}
		page_types[i].paper_name[0] = '\0';
		fclose (pdef);
		if ((psfile = fopen ("psizes.ps", "w")) != NULL)
		{	fprintf (psfile, "%s", psheader);
			for (j = i-1;  j >= 0;  j--)
			{	lcase (line, page_types[j].paper_name);
				fprintf (psfile, "%s\n(%s: %d %d) getsize\n",
							line,
							page_types[j].paper_name,
							page_types[j].width, 
							page_types[j].height);
			}
			fprintf (psfile, "%s\n", page_types[defaultsize].paper_tray);
			fprintf (psfile, "%s", psfont);
			x = 50;
			y = 600;
			fprintf (psfile, "%d %d moveto\n", x, y);
			fprintf (psfile, "(Imageable area) show\n");
			y -= 15;
			fprintf (psfile, "%d %d moveto\n", x, y);
			fprintf (psfile, "(");
			send (printername, psfile);
			fprintf (psfile, ") show\n");
			y -= 20;
			for (j = i-1;  j >= 0;  j--)
			{
				fprintf (psfile, "%d %d moveto\nsendsize\n", x, y);
				y -= 15;
			}
			fprintf (psfile, "%s", pstail);
		}
	}
}

trim (s)
char	*s;
{
	while (*s)
	{	if (*s < ' ')
		{	*s = 0;
			break;
		}
		s++;
	}
}

bad_file()
{
	fprintf (stderr, "Bad %s file\n", PDEF);
	exit (1);
}

lcase (a, b)
char	*a, *b;
{
	while (*b)
	{	*a++ = tolower (*b);
		b++;
	}
	*a = '\0';
}

send (s, fp)
char	*s;
FILE	*fp;
{
	char	*strchr();
	
	while (*s)
	{
		if (strchr ("\r\b\\()", *s) != NULL)
			fputc ('\\', fp);
		fputc (*s, fp);
		s++;
	}
}
