# include <stdio.h>
# include <sys/types.h>

# ifndef lint
static char *rcs_id =
	"@(#) $Header: mp_args.c,v 2.6 89/05/25 15:43:07 mark Exp $";
# endif

# include "mp_head.h"

/*
 * mpage:	a program to reduce pages of print so that several pages
 * 	  	of output appear on one printed page.
 *
 * Written by:
 *   ...!uunet!\                       Mark Hahn, Sr Systems Engineer
 *              >pyrdc!mark            Pyramid Technology Corporation
 * ...!pyramid!/                       Vienna, Va    (703)848-2050
 *
 *
 * Copyright (c) 1988 Mark P. Hahn, Herndon, Virginia
 *  
 *     Permission is granted to anyone to make or distribute verbatim
 *     copies of this document as received, in any medium, provided
 *     that this copyright notice notice is preserved, and that the
 *     distributor grants the recipient permission for further
 *     redistribution as permitted by this notice.
 *
 */

/* $Log:	mp_args.c,v $
 * Revision 2.6  89/05/25  15:43:07  mark
 * added the -b options as a converse to the -o option.
 * 
 * Revision 2.5  89/05/25  10:42:39  mark
 * changes to print a page count on stderr after the print job is queued.
 * 
 * Revision 2.4  89/05/25  08:57:47  mark
 * rearranged the rcs header keywords for better readability.
 * 
 * Revision 2.3  89/05/22  14:41:03  mark
 * Fixed the type-o in the rcs identification string
 * 
 * Revision 2.2  89/05/22  14:38:06  mark
 * Added rcs identification usable with the "what" program
 * 
 * Revision 2.1  89/05/22  14:31:29  mark
 * New Major Revision
 * 
 * Revision 1.1  89/05/22  14:25:29  mark
 * Initial revision
 *  */

do_args(argc, argv, envflag)
 int argc;
 char **argv;
 int envflag;
{
	char *optstr;
	int consumed;
	int currarg;
	int opterrors;

	opterrors = 0;
	for (currarg = 1; currarg < argc; currarg++) {
		if (*argv[currarg] != '-') {
			if (envflag) {
				opterrors++;
			}
			break;
		}
		optstr = argv[currarg];
		consumed = 0;
		while (*++optstr && ! consumed) {
			switch (*optstr) {
			default:
				fprintf(stderr,"%s: unknown option -%c\n",
				       MPAGE, *optstr);
				opterrors++;
				break;
			case '1':
				sheetindex = 0;
				break;
			case '2':
				sheetindex = 1;
				break;
			case '4':
				sheetindex = 2;
				break;
			case '8':
				sheetindex = 3;
				break;
			case 'A':	/* A4 sized, european paper */
				opt_a4 = 1;
				set_page();
				break;
			case 'a':	/* across */
				sheetorder = LEFTRIGHT;
				break;
			case 'h':
				++optstr;
				opt_doheader = 1;
				(void)strcpy(opt_header, optstr);
				consumed = 1;
				break;
			case 'L':
				++optstr;
				opt_lines = atoi(optstr);
				consumed = 1;
				break;
			case 'l':	/* landscape */
				sheetaspect = LANDSCAPE;
				break;
			case 'n':	/* normal */
				sheetaspect = NORMAL;
				break;
			case 'o':	/* print outlines */
				opt_outline = 1;
				break;
			case 'b':	/* don't print outlines */
				opt_outline = 0;
				break;
			case 'P':	/* Printer */
				++optstr;
				(void) strcpy(printer, optstr);
				consumed = 1;
				break;
			case 'p':	/* pr */
				opt_pr++;
				break;
			case 's':	/* silent (don't print page count) */
				opt_verbose = 0;
				break;
			case 'u':	/* updown */
				sheetorder = UPDOWN;
				break;
			case 'v':	/* verbose (print page count) */
				opt_verbose = 1;
				break;
			case 'W':
				++optstr;
				opt_width = atoi(optstr);
				consumed = 1;
				break;
			}
		}
	}
	if (opterrors) {
		return -1;
	}
	return currarg;
}

do_env()
{
	int argc;
	char **argv, **slice();
	char copy[LINESIZE];
	char *env, *getenv();

	env = getenv("PRINTER");
	if (env) {
		strcpy(printer, env);
	}

	env = getenv("MPAGE");
	if (env) {
		strcpy(copy, env);
		argv = slice(copy, &argc);
		if (do_args(argc, argv, 1) < 0) {
			fprintf(stderr, "%s: error in envronment \"%s\"\n",
				MPAGE, env);
			return 0;
		}
	}
	return 1;
}

char *slc_argv[20];

char **slice(string, cntp)
 char *string;
 int *cntp;
{
	int count;

	/*
	 * mimic the shell for conformity
	 */
	slc_argv[0] = MPAGE;
	count = 1;
	/*
	 * while there are still characters to be processed
	 */
	while (*string) {
		/*
		 * skip any leading or leftover white space
		 */
		while (*string == ' ') {
			string++;
		}
		/*
		 * make sure we had more than just white space before
		 * we believe we actually have an argument
		 */
		if (*string) {
			/*
			 * point the next slot in argv to this string
			 */
			slc_argv[count] = string;
			count += 1;
			/*
			 * and go looking for the end of this string
			 * which is delienated by a space or NULL
			 */
			while (*string && *string != ' ') {
				string++;
			}
			/*
			 * if this not the end of the string, then convert
			 * the space into a NULL and move forward one byte.
			 * if this is the end of the string, we already have
			 * a suitable NULL byte for the string and it also
			 * drops us out of all the loops
			 */
			if (*string) {
				*string = 0;
				string++;
			}
		}
	}
	/*
	 * return the count via the integer pointer we were given
	 * and put a null pointer into the argv array for conformity
	 */
	slc_argv[count] = 0;
	*cntp = count;
	return slc_argv;
}

