/* $Header: mp_head.h,v 2.8 89/05/25 10:42:07 mark Exp $ */

/*
 * mpage:	A program to reduce pages of print so that several pages
 * 	  	of output appear on one sheet of paper.
 *
 * Written by:
 *   ...!uunet!\                       Mark Hahn, Sr Systems Engineer
 *              >pyrdc!mark            Pyramid Technology Corporation
 * ...!pyramid!/                       Vienna, Va    (703)848-2050
 *
 *
 * Copyright (c) 1988 Mark P. Hahn, Herndon, Virginia
 *  
 *     Permission is granted to anyone to make or distribute verbatim
 *     copies of this document as received, in any medium, provided
 *     that this copyright notice notice is preserved, and that the
 *     distributor grants the recipient permission for further
 *     redistribution as permitted by this notice.
 *
 */

/* $Log:	mp_head.h,v $
 * Revision 2.8  89/05/25  10:42:07  mark
 * changes to print a page count on stderr after the print job is queued.
 * 
 * Revision 2.7  89/05/25  10:25:13  mark
 * add new debugging keyword for tracking the processing of postscript
 * documents.
 * 
 * Revision 2.6  89/05/25  10:23:17  mark
 * fixed typo in rcs keyword
 *  */

/*
 * Through-out the program comments I have tried to refer to pages a the
 * logical printed page of text that gets reduced.  Sheets refer to physical
 * pieces of paper.  Hence, mulitple pages appear on a sheet.  "page" is a
 * logical or virtual entity, and "sheet" is physical entity.
 */

char *ctime();
FILE *popen();
char *strcpy();
char *mktemp();
time_t time();

# define	TRUE		1
# define	FALSE		0

# define	LINESIZE	1024

# define	FILE_EOF	1
# define	FILE_MORE	2

# define	LINE_MORE	5
# define	LINE_EOF_NOW	4
# define	LINE_EOF	3
# define	LINE_OVERPRINT	2
# define	LINE_BLANK	1


/*
 * to turn on debugging, define the preprocessor macro DEBUG and set
 * the variable Debug_flag to the sum of the sections to debug.
 */
# ifdef DEBUG
# define Debug(f,s,a)	if (Debug_flag & f) printf(s,a)
# define DB_GETLINE	0x0000001
# define DB_ONEPAGE	0x0000002
# define DB_STDIN	0x0000004
# define DB_PSDOC	0x0000008
# define DB_PSPAGE	0x0000010
# define DB_PSCHECK	0x0000020
# define DB_PSROFF	0x0000040
# define DB_PSMPAGE	0x0000080
# define DB_POINTS	0x0000100
# define DB_POST	0x0000200
# define DB_UNUSED	0x0000400
extern int Debug_flag;
extern int errno;
# else DEBUG
# define Debug(f,s,a)
# endif DEBUG

/*
 * defintions for sorting out types of postscript input
 */
# define	PS_NONE		0
# define	PS_PSROFF	1
# define	PS_MPAGE	2
# define	PS_CONFORM	3
# define	PS_OTHER	4

/*
 * "Conforming" postscript flag string  (remember ps_check strips
 * the "%!" flag from PS files
 */
# define	PS_FLAG		"PS-Adobe-"

/*
 * some basic PS parameters
 */
extern int ps_width;	/* number of points in the X direction (8.5 inches) */
extern int ps_height;	/* number of points in the Y direction (11 inches) */

/*
 * a sheet describes the measurements and orientatation of a page for
 * use in constructing a sheet preabmles.
 */
struct sheet {
	int sh_cwidth;		/* number of characters across a page */
	int sh_plength;		/* number of lines down a page */
	int (*sh_width)();	/* postscript width across a printed page */
	int (*sh_height)();	/* postscript height of a printed page */
	int sh_rotate;		/* angle to rotate the page */
	int (*sh_outline)();	/* text to print as outline for */
				/*    the printed sheet*/
	struct	pagepoints *sh_pagepoints; /* where to put pages on */
					     /*    the printed sheet */
};

/*
 * simple x and y coordinates for putting pages of output on printed sheet
 */
struct pagepoints {
	int (*pp_origin_x)();
	int (*pp_origin_y)();
};

/* array of sheets where pages are ordered for left to right reading */
extern struct sheet *left_right[];

/* arrays for sheets where pages are ordered for top to bottom reading  */
extern struct sheet *up_down[];

/* definitions for aspect and reading directions */
# define NORMAL		0
# define LANDSCAPE	1
# define UPDOWN		0
# define LEFTRIGHT	1

/*
 * Variables for holding the chosen options,  The defaults are set here.
 * the sheetlist pointer is set to point to the array for either up/down
 * or left/right reading.  This array is index by sheetorder, and then
 * sheetindex.  sheetindex encodes the number of reduced pages per printed
 * sheet and indexes into the sheet list (0 = 1 page, 1 = two pages, 2 =
 * four pages, 3 = eight pages).
 */
extern struct sheet **sheetlist;/* array of sheet lists (up/down or left/right) */
extern int sheetaspect;		/* either normal or landscape */
extern int sheetorder;		/* up/down or left/right flag */
extern int sheetindex;		/* index to number of pages of sheet */
extern int pg_sheetmargin;	/* non-printable border on sheet */
extern int pg_pagemargin;	/* border for pages */
extern int fsize;		/* font scale size */
extern int opt_pr;		/* boolean, if true use pr to format output */
extern int opt_lines;		/* number of lines to fit on an reduced page */
extern int opt_width;		/* number of columns to fit on reduced page */
extern int opt_doheader;	/* have a head for pr's -h option */
extern int opt_a4;		/* sheets are A4 sized, european paper */
extern int opt_outline;		/* print a nice outline around pages */
extern int opt_verbose;		/* print a count of pages sent to printer */
extern char opt_header[LINESIZE]; /* the header for pr's -h option */
extern char outcommand[LINESIZE]; /* the command which is the output filter */
extern char printer[LINESIZE];	/* the printer (argument to lpr -P??) */

/*
 * various global information
 */
extern char MPAGE[];		/* program name */
extern int ps_pagenum;		/* current page count */
extern char usage[];		/* usage string */

/*
 * function declarations for the page point computation functions
 */
int xbase1(), xbase2();
int ybase1(), ybase2(), ybase3(), ybase4();
int ytop1(), ytop2(), ytop3(), ytop4();
int xwid1(), xwid2(), xwid4(), xwid8();
int yht1(), yht2(), yht4(), yht8();

static char *rcs_header_id =
	"@(#)	$Header: mp_head.h,v 2.8 89/05/25 10:42:07 mark Exp $";

