
/*  @(#)misc.c 1.5 90/08/16
 *
 *  Copyright (c) Steve Holden and Rich Burridge.
 *                All rights reserved.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors inherent either
 *  to the comments or the code of this program, but if reported
 *  to me then an attempt will be made to fix them.
 */

#include "mp.h"
#include "patchlevel.h"
#include "extern.h"


void
do_date()        /* Output Postscript definition for the date and time. */
{
  long clock ;           /* Used by the localtime function call. */
  struct tm *tm ;        /* Used by the localtime and asctime calls. */

  if (date == NULL)
    {
      clock = time((time_t *) 0) ;
      tm = localtime(&clock) ;
      psdef("TimeNow", asctime(tm)) ;
    }
  else psdef("TimeNow", date) ;
}


get_opt(argc, argv, options)
int argc ;
char **argv, *options ;
{
  char opch, *str, *ptr ;
  static int flag = 0 ;
  static int cur_argc ;
  static char **cur_argv ;

  if (flag == 0)
    {
      cur_argc = argc ;
      cur_argv = argv ;
      flag = 1 ;
      optind = 1 ;
    }

  if (cur_argc <= 1) return -1 ;

  if (--cur_argc >= 1)
    {
      str = *++cur_argv ;
      if (*str != '-') return -1 ;    /* Argument is not an option   */
      else
        {                             /* Argument is an option */
          if ((ptr = index(options, opch = *++str)) != (char *) 0)
            {
              ++optind ;
              optarg = ++str ;        /* Point to rest of argument if any  */
              if ((*++ptr == ':') && (*optarg == '\0'))
                {
                  if (--cur_argc <= 0) return '?' ;
                  optarg = *++cur_argv ;
                  ++optind ;
                }
              return opch ;
            }
          else if (opch == '-')
            {                         /* End of options */
              ++optind ;
              return -1 ;
            }
          else return '?' ;
        }
    } 
  return 0 ;                          /* Should never be reached. */
}


get_options(argc, argv)      /* Read and process command line options. */
int argc ;
char *argv[] ;
{
  int opch ;

  while ((opch = get_opt(argc, argv, "adflmop:s:tv")) != -1)
    switch (opch)
      {
        case 'a' : article = TRUE ;      /* "Article from" format. */
                   break ;
        case 'd' : digest = TRUE ;       /* Print digest. */
                   break ;
        case 'f' : filofax = TRUE ;      /* Print filofax file. */
                   SPRINTF(proname, "%s/mp.pro.filofax.ps", prologue) ;
                   break ;
        case 'l' : landscape = TRUE ;    /* Print in landscape mode. */
                   break ;
        case 'm' : folder = TRUE ;       /* Print mail folder. */
                   break ;
        case 'o' : text_doc = TRUE ;     /* Print ordinary text file */
                   break ;
        case 'p' : if (strlen(optarg))
                     STRCPY(proname, optarg) ;  /* New prologue file. */
                   break ;
        case 's' : if (strlen(optarg))
                     gsubject = optarg ;        /* New subject line. */
                   break ;
        case 't' : timeman = TRUE ;     /* Print Time Manager file. */
                   SPRINTF(proname, "%s/mp.pro.timeman.ps", prologue) ;
                   break ;
        case 'v' : FPRINTF(stderr,
                           "%s version 2.4.%1d\n", progname, PATCHLEVEL) ;                         exit(1) ;
        case '?' : usage() ;
      }
}


void
init_setup()            /* Set default values for various options. */
{
  char *c, *ptr ;
  int amp_cnt = 0 ;     /* Number of ampersands in gecos field. */
  int i, j, n, spaces ;
  struct passwd *pp ;

  c = getlogin() ;      /* Pointer to users login name. */
  if (c == NULL)        /* Get username from password file */
    {
      pp = getpwuid(geteuid()) ;
      if (pp == NULL) c = "printing" ;
      else c = pp->pw_name ;
    }
  owner = malloc((unsigned) (strlen(c) + 1)) ;
  STRCPY(owner, c) ;
 
/*  Have a look for the users gecos (normally real name), so that its a bit
 *  more recognisable. If this field is too long, then we need to truncate
 *  sensibly. We also need to check a few things. If we've extracted
 *  two "words" or have found a comma, then exit. If an ampersand is
 *  found, this is expanded to the users name in capitals.
 */    
     
  pp = getpwnam(owner) ;
  if (pp != NULL && pp->pw_gecos && pp->pw_gecos[0] != '\0')
    {  
      for (i = 0; i < strlen(pp->pw_gecos); i++)
        if (pp->pw_gecos[i] == '&') amp_cnt++ ;
 
      owner = malloc((unsigned) (strlen(pp->pw_gecos) +
                                 amp_cnt * strlen(c) + 1)) ;

      n = spaces = 0 ;
      ptr = pp->pw_gecos ;
      for (i = 0; i < strlen(pp->pw_gecos); i++)
        {
               if (*ptr == ',') break ;
          else if (*ptr == '&')
            {
              for (j = 0; j < strlen(c); j++)
                if (islower(c[j])) owner[n++] = toupper(c[j]) ;
                else owner[n++] = c[j] ;
              *ptr++ ;
            }
          else if (*ptr == ' ')
            {
              if (++spaces == 2) break ;
              else owner[n++] = *ptr++ ;
            }
          else owner[n++] = *ptr++ ;
          if (n >= NAMELENGTH) break ;
        }
      if (n > NAMELENGTH) n = NAMELENGTH ;
      owner[n] = '\0' ;
    }
  if ((nameptr = getenv("NAME")) != NULL)
    STRCPY(owner, nameptr) ;

  if (text_doc) doc_type = DO_TEXT ;
  switch (doc_type)
    {
      case DO_TEXT : message_for = "Listing for ";
                     digest = FALSE ;
                     break ;
      case DO_MAIL : message_for = digest ? "Mail digest for " : "Mail for " ;
                     break ;
      case DO_NEWS : message_for = digest ? "News digest for " : "News for " ;
                     break ;
    }
}


usage()     /* Print usage message and exit. */
{
  FPRINTF(stderr,"Usage: %s [-a] [-d] [-f] [-l] [-m] ", progname) ;
  FPRINTF(stderr, "[-o] [-p prologue] [-s subject] [-t] [-v] [-?]\n") ;
  exit(1) ;
}

