
/*  @(#)main.c 1.6 90/08/17
 *
 *  Takes a mail file, a news article or an ordinary file
 *  and pretty prints it on a Postscript printer.
 *
 *-----------------------------------------------------------------------
 *
 *  Credits:
 *
 *  Original written in the Icon language by Steve Holden.
 *
 *  Converted to C, modified and maintained
 *  by Rich Burridge - Sun Microsystems Australia.
 *
 *  Further modifications to handle news articles and MH mail,
 *  by Bruno Pillard  - Chorus Systemes, St Quentin en Yvelines, France
 *
 *  Addition of digest printing by Dave Glowacki of Public
 *  Works Computer Services, St Paul, MN.
 *
 *  Ordinary text file pretty printing by Rich Burridge.
 *
 *  Substantial modifications to header parsing and command options
 *  by Jeremy Webber, Computer Science Dept, University of Adelaide,
 *  Australia.
 *
 *  Support for printing multiple files and subject line filename print
 *  for ordinary files added by S. Manoharan, Edinburgh University.
 *
 *  Landscape mode added by Michael Tuciarone.
 *
 *----------------------------------------------------------------------
 *
 *  Copyright (c) Steve Holden and Rich Burridge.
 *                All rights reserved.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors inherent either
 *  to the comments or the code of this program, but if reported
 *  to me then an attempt will be made to fix them.
 */

#include "mp.h"

/* Command line option flags */
 
bool article  = FALSE ;       /* Set for news in "Article from " format. */
bool digest   = FALSE ;       /* Are we are printing a mail digest (-d) */
bool filofax  = FALSE ;       /* Set if we are printing a filofax file. */
bool folder   = FALSE ;       /* Set if we are printing a mail folder. */
bool text_doc = FALSE ;       /* Printing normal text (-o) */
bool timeman  = FALSE ;       /* Set if we are printing a Time Manager file. */
 
/* Header definitions. */
 
char *FROMHDR       = "From:" ;
char *FROM_HDR      = "From " ;            /* UNIX From header */
char *APP_FROMHDR   = "Apparently_from:" ;
char *TOHDR         = "To:" ;
char *APP_TOHDR     = "Apparently_to:" ;
char *CCHDR         = "Cc:" ;
char *SUBJECTHDR    = "Subject:" ;
char *DATEHDR       = "Date:" ;
char *NEWSGROUPSHDR = "Newsgroups:" ;
char *REPLYHDR      = "Reply_to:" ;

/* Header lines. */

char *from            = NULL ;    /* From: */
char *from_           = NULL ;    /* From_ (UNIX from) */
char *apparently_from = NULL ;    /* Apparently_from: */
char *to[MAXCONT+1] ;             /* To: (can have multiple lines) */
char *apparently_to   = NULL ;    /* Apparently_to: */
char *cc[MAXCONT+1]   = NULL ;    /* Cc: (can have multiple lines) */
char *subject         = NULL ;    /* Subject: (can be set from command line) */
char *gsubject        = NULL ;    /* Global subject set from command line. */
char *date            = NULL ;    /* Date: */
char *newsgroups      = NULL ;    /* Newsgroups: (news articles only) */
char *reply_to        = NULL ;    /* Reply-to: */

/* Strings used in page processing. */

char curfname[MAXPATHLEN] ;       /* Current file being printed. */
char *message_for = "" ;          /* "[Mail,News,Listing] for " line */
char *nameptr ;                   /* Used to getenv the NAME variable. */
char *optarg ;                    /* Optional command line argument. */
char *owner       = NULL ;        /* Name of owner (usually equal to 'to') */
char *progname    = NULL ;        /* Name of this program. */
char *prologue    = PROLOGUE ;    /* Name of PostScript prologue file. */
char proname[MAXPATHLEN] ;        /* Full pathname of the prologue file. */

/* Other globals. */

document_type doc_type = DO_MAIL ;  /* Printing type - default mail */

int colct = 0;              /* Column count on current page. */
int cmdfiles = 0 ;          /* Set if file to print given on command line. */
int landscape = 0;          /* Set if in landscape (wide) mode. */
int linect = 0 ;            /* Line count on current page. */
int llen = LINELENGTH ;     /* Number of characters per line. */
int optind ;                /* Optional command line argument indicator. */
int pageno = 1 ;            /* Page number within message. */
int plen = PAGELENGTH ;     /* Number of lines per page. */
int tpn    = 0 ;            /* Total number of pages printed. */

/* Read-ahead variables. */

char nextline[MAXLINE] ;  /* Read-ahead of the mail message, minus nl */

bool end_of_file = FALSE ;     /* EOF indicator */
bool end_of_line ;             /* Is a newline removed from this line */
bool end_of_page = FALSE ;     /* end-of-page indicator - ^L on input */

FILE *fp ;                     /* File pointer for current file. */


main(argc, argv)
int argc ;
char **argv ;
{
  to[0] = cc[0] = NULL ;

  progname = argv[0] ;        /* Save this program name. */

/*  Try to get location of the mp prologue file from an environment variable.
 *  If it's not found, then use the default value.
 */

  if ((prologue = getenv("MP_PROLOGUE")) == NULL)
    prologue = PROLOGUE ;
  SPRINTF(proname, "%s/mp.pro.ps", prologue) ;

  get_options(argc, argv) ;   /* Read and process command line options. */

  show_prologue(proname) ;    /* Send prologue file to output. */

  if (landscape) PRINTF("\nLandscape\n") ;

  FPUTS("%%EndProlog\n", stdout) ;

  if (argc - optind != 0) cmdfiles = 1 ;
  if (!cmdfiles)
    {
      fp = stdin ;                 /* Get input from standard input. */
      STRCPY(curfname, "stdin") ;
      printfile() ;                /* Pretty print *just* standard input. */
    }
  else
    for (; optind < argc; ++optind)
      {
        STRCPY(curfname, argv[optind]) ;    /* Current file to print. */
        if ((fp = fopen(curfname, "r")) == NULL)
          {
            FPRINTF(stderr, "%s: cannot open %s\n", progname, curfname) ;
            continue ;
          }
        pageno = 1 ;       /* Initialise current page number. */
        end_of_file = 0 ;  /* Reset in case there's another file to print. */
        printfile() ;      /* Pretty print current file. */
      }

  show_trailer() ;         /* Send trailer file to output. */

  exit(0) ;
/*NOTREACHED*/
}


printfile()    /* Create PostScript to pretty print the current file. */
{
  readline() ;
  if (end_of_file)
    {
      FPRINTF(stderr, "mp: empty input file, nothing printed\n") ;
      exit(1) ;
    }
 
  if (!text_doc)
    parse_headers(FALSE) ;    /* Parse headers of mail or news article */
  init_setup() ;              /* Set values for remaining globals. */
 
/* Print the document */
 
  startpage() ;               /* Output initial definitions. */

  if (doc_type != DO_TEXT) show_headers(FALSE) ;
  while (!end_of_file)
    {
      if (folder && EQUAL(FROM_HDR))
        {
          linect = plen ;
          reset_headers() ;
          parse_headers(FALSE) ;
          show_headers(FALSE) ;
        }
      if (digest && (EQUAL(FROMHDR) || EQUAL(DATEHDR) || EQUAL(SUBJECTHDR)))
        {
          linect = plen ;
          parse_headers(TRUE) ;
          show_headers(TRUE) ;
        }
      textshow(nextline) ;
      readline() ;
    }    
  if (filofax || timeman) endfile() ;
  else endpage() ;
  FCLOSE(fp) ;
}


show_trailer()
{
  FPUTS("%%Trailer\n", stdout) ;
  PRINTF("%%%%Pages: %1d\n", tpn) ;
}
