
/*  @(#)print.c 1.8 90/08/29
 *
 *  Copyright (c) Steve Holden and Rich Burridge.
 *                All rights reserved.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors inherent either
 *  to the comments or the code of this program, but if reported
 *  to me then an attempt will be made to fix them.
 */

#include "mp.h"
#include "extern.h"


boldshow(hdr, str)      /* Display a header all in bold. */
char *hdr, *str ;
{
  useline() ;
  FPUTS("BoldFont ", stdout) ;
  startline() ;
  expand(hdr) ;
  expand(str) ;
  endline() ;
}


endcol()
{
  linect = 0 ;
  PRINTF("endcol\n") ;
}


endfile()
{
  linect = 0 ;
  PRINTF("(%1d) endfile\n", pageno) ;
}


endline()
{
  PRINTF(") showline\n") ;
}


endpage()
{
  linect = 0 ;
  PRINTF("(%1d) endpage\n", pageno++) ;
}


expand(s)   /* Display a string with PostScript-sensitive characters escaped */
char *s ;
{
  for (; s && *s; s++)
    {
      switch (*s)
        {
          case '\\' : FPUTS("\\\\", stdout) ;
                      break ;
          case '('  : FPUTS("\\(", stdout) ;
                      break ;
          case ')'  : FPUTS("\\)", stdout) ;
                      break ;
          case '\b' : PUTC(*s, stdout) ;
                      break ;
          default   : if (isprint(*s)) PUTC(*s, stdout) ;
        }
    }
}


mixedshow(hdr, str)     /* Display a header in mixed bold/Roman. */
char *hdr, *str ;
{
  useline() ;
  FPUTS("BoldFont ", stdout) ;
  startline() ;
  expand(hdr) ;
  FPUTS(") show pf (", stdout) ;
  expand(str) ;
  endline() ;
}


psdef(name, def)        /* Do a PostScript define. */
char *name, *def ;
{
  PRINTF("/%s (", name) ;
  expand(def) ;
  PRINTF(") def\n") ;
}


romanshow(str)          /* Display a header all in Roman. */
char *str ;
{
  useline() ;
  FPUTS("pf ", stdout) ;
  startline() ;
  expand(str) ;
  endline() ;
}


void
set_defs()               /* Setup PostScript definitions. */
{
  int i ;

  if (article == TRUE)
    STRCPY(message_for, "Article from") ;             /* MailFor. */
  psdef("MailFor", message_for) ;

  if (article == TRUE && newsgroups != NULL)          /* User. */
    {
      for (i = 0; i < strlen(newsgroups); i++)
        if (newsgroups[i] == ',' ||
            newsgroups[i] == '\0') break ;
      owner = (char *) realloc(owner, (unsigned int) i) ;
      STRNCPY(owner, newsgroups, i) ;
      owner[i] = '\0' ;
    }
  psdef("User", owner) ;
 
  do_date() ;                                         /* TimeNow. */
 
  if (text_doc && cmdfiles) subject = curfname ;
  psdef("Subject",
        (gsubject != NULL) ? gsubject : subject) ;    /* Subject. */
}


/* Display the PostScript prologue file for mp */
                   
show_prologue(pro)
char *pro ;              /* Prologue file name */
{
  FILE *pf ;
  char buf[MAXLINE], tmpstr[MAXLINE] ;
  int t2 ;               /* Possible extract page or line length. */

  if ((pf = fopen(pro, "r")) == NULL)                                
    {
      FPRINTF(stderr,"%s: Prologue file %s not found.\n",progname, pro) ;
      exit(1) ;
    }
  while (fgets(buf, MAXLINE, pf) != NULL)
    {
      FPUTS(buf, stdout) ;
 
/* Check for new line or page length. */
 
      SSCANF(buf, "%s %d", tmpstr, &t2) ;
      if (strcmp(tmpstr, "%%PageLength") == 0)
        plen = t2 ;               /* Change the page length. */
      else if (strcmp(tmpstr, "%%LineLength") == 0)
        llen = t2 ;               /* Change the line length. */
    }
  FCLOSE(pf) ;
}


startline()
{
  PRINTF("(") ;
}


startpage()
{
  PRINTF("%%%%Page: ? %1d\n", ++tpn) ;
  set_defs() ;
}


textshow(s)
char *s ;
{
  useline() ;
  FPUTS("sf ", stdout) ;
  startline() ;
  expand(s) ;
  endline() ;
}


useline()   /* Called in order to ready a line for printing. */
{
  if (++linect > plen || end_of_page == TRUE)
    {
      if (landscape && colct == 0)
        {
          colct++ ;
          endcol() ;
          return ;
        }
      colct = 0 ;
      endpage() ;
      linect = 0 ;
      startpage() ;
    }
}
