.TH LWF 1-LOCAL "21 February 1988"
.UC
.SH NAME
lwf \- ASCII to PostScript filter
.SH SYNOPSIS
.B lwf
[-c#] [-d] [-i#] [-l] [-m] [-olist] [-p[str]]
.br
.ti +4
[-P filename] [-r] [-s#] [-S] [-t#] [-v] [file ...]
.SH DESCRIPTION
.I Lwf
takes one or more ASCII text files as input and produces PostScript
instructions that may be sent (see \fBlpr(1)\fR) to a PostScript printer
(e.g., an Apple LaserWriter) for printing.
If no files are given on the command line, the standard input is read.
The program correctly handles the form feed character and tabs and
understands backspacing; underscores followed by backspaces
may be used to underline.
Courier font is used.
The output conforms to the Adobe 2.0 file structuring conventions.
.PP
Note that flag arguments apply to all of the files in the argument list.
For example, using ``-s8'' prints each of the files in 8 point type.
.PP
Multiple copies of each page can be printed by immediately following the
.B -c
flag with the number of copies to make.
The pages are not collated.
.PP
Lines may be indented (shifted to the right) using the \fB-i\fR flag.
This flag is immediately followed by the distance in inches to shift
all text from the left edge of the paper instead of the default amount
(about 1/3 of an inch); the resolution is approximately 1/72 of an inch.
.PP
The
.B -l
flag indicates that landscape format is to be used instead of the default
portrait format.
.PP
Margins suitable for use with a three hole punch can be obtained using the
.B -m
flag.
This flag may be used with either portrait or landscape mode.
In portrait mode the
.B -m
flag and any indentation specified by a
.B -i
flag are additive.
.PP
The
.B -o
flag is immediately followed by a range specification that indicates
which pages are to be printed.
A range specification is a comma-separated list of numbers and ranges.
A number N selects the Nth page;
a range N:M selects the Nth through Mth pages, inclusive;
an initial :N selects from the beginning up to and including the
Nth page; and a final N: selects from the Nth page to the end.
The default, ``:'', is to print all pages.
.PP
The
.B -p
flag indicates that
.B pr(1)
is to be used to perform pagination and print page headers.
An argument string to be passed on to \fBpr(1)\fR can immediately
follow the flag.
The usual way of producing multicolumn output is to pass a
.B -n
flag to
\fBpr(1)\fR, where
.B n
is the number of columns to generate.
Note that this string must be properly quoted if it contains whitespace,
metacharacters, backslashes, etc.
\fILwf\fR passes on the number of lines and columns to
\fBpr(1)\fR so that multicolumn output is handled correctly.
When specifying multicolumns you are responsible for selecting
an appropriate point size and/or landscape format.
The formfeed character is handled incorrectly by some versions of
\fBpr(1)\fR when multiple columns have been specified.
Instead of starting a new column or page it simply passes formfeeds
through.
.B Lwf
filters out these formfeeds.
.PP
.I Lwf
normally includes a standard PostScript prologue in its output
(usually /usr/local/lib/lwf.prologue).
The argument following a
.B -P
flag specifies a prologue file to be substituted for the standard
system file.
.PP
The default is to not perform page reversal, which is correct for printers
like the NEC Silentwriter LC-890.
The
.B -r
flag enables page reversal so that the pages appear in
the correct sequence in the output tray of printers like the Apple
LaserWriter.
.PP
The
.B -s
flag, immediately followed by a 7, 8, 9, 10, 11, or 12 causes
the corresponding point size to be used.
The default point size is 10.
.PP
By default, the output of
.I lwf
is intended to go through a spooler that monitors the status of the
printer and separates jobs.
The
.B -S
flag indicates that such a monitor is not being used and that a
header page should be printed to separate jobs and end-of-file characters
should be inserted in the output.
.PP
The
.B -t
flag is immediately followed by a number indicating the distance between
tab stops.
The default value is 8 characters.
.PP
The
.B -d
and
.B -v
flags are used for debugging.
.SH EXAMPLES
The command
.sp 2
.ti +5
lwf -p-2 -i0.5 -s12 file1.c file2.c | lpr -Plw
.sp 2
would print the two files on printer 'lw' in portrait format with
page headings, indenting 0.5 inches from the left edge, using 12
point type.
Each file would be printed in two columns.
.sp 1
The command
.sp 2
.ti +5
lwf -l -s7 -p'-h foo' | lpr -Plw
.sp 2
would print the standard input with page headings in landscape format
using 7 point type.
The filename for the header line would be 'foo'.
.sp 1
The command
.sp 2
.ti +5
lwf -p'-h foo .login -h bar .cshrc' | lpr -Plw
.sp 2
would print the file ``.login'' with a header title ``foo'' and ``.cshrc''
with the header title ``bar''.
.sp 1
A useful csh alias is:
.sp 2
.ti +5
alias prlw 'lwf -s7 -t4 -l -p-2 \\!* | lpr -Plw'
.sp 2
which, when invoked as
.sp 2
.ti +5
prlw foo1 foo2
.sp 2
prints foo1 and foo2, two columns per page, on printer 'lw'.
.SH FILES
/tmp/lwfXXXXXX		\- temporary file used for page reversal
.SH SEE ALSO
pr(1), lpr(1)
.SH LIMITATIONS
The maximum input line length is 1024 characters.
This should not present a problem since the corresponding output line
length would be too long to be printed.
The program quits and prints a message if an input line is too long.
Output lines that are too long are normally silently truncated by the
printer.
.sp 2
.I Lwf
can be compiled such that there is a limit on the number of pages it can
produce.
.SH BUGS
It might be argued that flags should be allowed to be interspersed between
file arguments.
.sp 2
The character '\\001' (SOH) should not appear in the input as it is used
within the program to delimit columns.
The first time the program reads this character it determines the number
of columns being printed; all subsequent lines are expected to
have this number of columns or be ``single column''.
.sp 2
A \fB-s\fR flag should not be passed on to \fBpr(1)\fR since
.I lwf
uses it.
.sp 2
The program can only handle the 6 different point sizes and the single
font.
.sp 2
So much for metric.
.SH AUTHOR
Barry Brachman
.br
Dept. of Computer Science
.br
University of British Columbia

