/* Program:        lj2ps
** File:	   transform.c
**
** Author:	   Christopher Lishka
** Organization:   Wisconsin State Laboratory of Hygiene
**		   Data Processing Dept.
**
** Copyright (C) 1990 by Christopher Lishka.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static char * ModuleID = "Module transform: v1.0.1.2, production";

  /* Include files
  */
#include <stdio.h>
#include "trans.h"
#include "scan.h"
#include "lj2ps.h"
#include "lj.h"

  /* External definitions
  */

  /* Global variables
  */

  /* Global function list
  */
extern void  transform();

  /* Local constants
  */

  /* Local structures and types
  */

  /* Local variables
  */

  /* Local macro definitions
  */
#define report(x)  fprintf(output_file, "%s", x);

  /* Local function list
  */

  /* Function bodies
  */

  /* transform() reads text mixed with laserjet commands from its input
  ** and "magically" changes it to postscript on its output.  The magic
  ** is performed in a tight while-loop which acts as a simple decision
  ** table: for each token type (command, text, parameter) the appropriate
  ** action is done (which usually involves writing to stdout or calling
  ** an emulation function).
  */
void
transform(input_file, output_file)
    FILE *input_file, *output_file;
{

    /* Reset the scanner to read from the input */
  scan_init(input_file);

    /* While the input stream still has tokens, handle each token through
    ** the switch() jump table.
    */
  scan_state = SS_TEXT;    		/* Set the initial scan state */
  while( scan() ){
#ifdef DEBUG
    if( debug ) fprintf(stderr, "{TOKEN:%d}", curr_token.code);
#endif
    switch( curr_token.code ){
    case TEXT_CHAR:
      if( (page_height - current_y) > (text_height + margin_top + LJ_ERROR) ){
	lj_page_end(output_file);
	lj_page_begin(output_file);
      }
      lj_text_add(output_file, text);
      break;
    case TEXT_NULL:		/* Ignore nulls */
      warning("encountered a null; ignoring", "");
      break;
    case TEXT_lp:
      lj_text_add(output_file, "\\(");
      break;
    case TEXT_rp:
      lj_text_add(output_file, "\\)");
      break;
    case TEXT_bslash:
      lj_text_add(output_file, "\\\\");
      break;
    case TEXT_NEWLINE:
      if( (page_height - current_y) > (text_height + margin_top + LJ_ERROR) ){
	lj_page_end(output_file);
	lj_page_begin(output_file);
      }
      lj_nl(output_file);	/* Write out a newline */
      current_line++;
      break;
    case TEXT_FORMFEED:
      lj_page_end(output_file);
      /* XXX insert page counting mechanism here! */
      lj_page_begin(output_file);
      break;
    case TEXT_TAB:
        /* XXX This should check for either font_p or font_s, and not assume
	**     font_p automatically!
	*/
      if( font_p.spacing == LJ_SP_PROPORTIONAL )
	warning("a tab is being used with a proportional font!", "");
      lj_text_end(output_file);
      fputs("TAB ", output_file);
      lj_text_begin();
      break;
    case TEXT_SH_IN:
      warning("shift-in is not yet supported -- ignoring", "");
      break;
    case TEXT_SH_OUT:
      warning("shift-out is not yet supported -- ignoring", "");
      break;
    case CMD_UNDEF:	ljcmd_undefined(input_file, output_file);   break;
    case CMD_E:		ljcmd_E(output_file);                       break;
    case CMD_Y:		ljcmd_Y(output_file);	                    break;
    case CMD_Z:		ljcmd_Z(output_file);	                    break;
    case CMD_9:		ljcmd_9(output_file);	                    break;
    case CMD_eq:	ljcmd_eq(output_file);	                    break;
    case CMD_lp:	ljcmd_lp(input_file, output_file);	    break;
    case CMD_rp:	ljcmd_rp(input_file, output_file);	    break;
    case CMD_lp_s:	ljcmd_lp_s(input_file, output_file);	    break;
    case CMD_rp_s:	ljcmd_rp_s(input_file, output_file);	    break;
    case CMD_amp_a:	ljcmd_amp_a(input_file, output_file);	    break;
    case CMD_amp_d:	ljcmd_amp_d(input_file, output_file);	    break;
    case CMD_amp_f:	ljcmd_amp_f(input_file, output_file);	    break;
    case CMD_amp_k:     ljcmd_amp_k(input_file, output_file);       break;
    case CMD_amp_l:	ljcmd_amp_l(input_file, output_file);	    break;
    case CMD_amp_p:	ljcmd_amp_p(input_file, output_file);	    break;
    case CMD_amp_s:	ljcmd_amp_s(input_file, output_file);	    break;
    case CMD_star_b:    ljcmd_star_b(input_file, output_file);      break;
    case CMD_star_c:	ljcmd_star_c(input_file, output_file);	    break;
    case CMD_star_p:	ljcmd_star_p(input_file, output_file);	    break;
    case CMD_star_r:	ljcmd_star_r(input_file, output_file);	    break;
    case CMD_star_t:	ljcmd_star_t(input_file, output_file);	    break;
    case PARAM_CONTINUE:
    case PARAM_END:
      internal_error("(end)parameter found in transform()", variable);
      break;
    default:
      internal_error("illegal token encountered in transform()", "");
    } /* switch(...) */
  } /* while(...) */

} /* transform() */



