.\"  Program:		lj2ps 1.2, release
.\"  File:		lj2ps.l	(man page documentation)
.\"
.\"  Author:		Chris Lishka
.\"  Organization:	Wisconsin State Laboratory of Hygiene
.\"			Data Processing Section
.\"
.TH LJ2PS l "June 30th, 1990 (Revision 1.2)"
.SH NAME
\fBlj2ps\fR \- print \fILaserJet\fR files on a \fIPostScript\fR printer
.SH SYNOPSIS
\fBljlpr [ \fIoptions\fB ]  [ \fIfiles\fB ] \fR
.SH DESCRIPTION
.PP
\fBlj2ps\fR is a translator that reads in a file of text and
\fILaserJet PCL\fR commands and converts it to \fIPostScript.\fR
\fBlj2ps\fR can currently translate a subset of \fIPCL 4.\fR  It will
properly convert page motion, page setup, and primary font commands.
Left out are macros, position stack commands, secondary font support,
graphics (both bitmap and pattern/grayscale), and downloadable fonts.
.PP
\fBlj2ps\fR is set up to mimic a \fILaserJet Series II\fR with the
\fIHewlett Packard F\fR and \fIG\fR font cartridges plugged into the
left and right ports, respectively.  Command-line options are provided
that duplicate the functions in the main menu, accessible from the
front panel.
.PP
If \fIfiles\fR are listed on the command line, then \fBlj2ps\fR will
read each consecutively as if they were all one file.  If no files are
listed, then input will be read from the \fIstandard input.\fR  All
output is written to the \fIstandard output,\fR and errors to the
\fIstandard error.\fR
.SH OPTIONS
.PP
.IP "\fBLaserJet II Main Menu Options\fR" 2
.IP "\fB-c##\fR" 5
Sets the numbers of copies to \fB##\fR.  The default is one copy.
.IP "\fB-mf\fR" 5
Specifies that paper is to be fed in manually.  The default is to
automatically feed paper in from the tray.
.IP "\fB-fs?\fR" 5
Change the default font source to \fB?\fR, where \fB?\fR is \fBL\fR
(left cartridge), \fBR\fR (right cartridge), \fBI\fR (internal), or
\fBS\fR (soft font).  The default is \fBI\fR (internal).
.IP "\fB-fn##\fR" 5
Use font number \fB##\fR from the default font source.  The default is
font number zero.
.IP "\fB-fl##\fR" 5
Set the form length to \fB##\fR lines.  The default is 60 lines.
.IP "\fBPage Orientation\fR" 2
.IP "\fB-p\fR" 5
Print in portrait mode.  This is the default.
.IP "\fB-l\fR" 5
Print in landscape mode.
.IP "\fBPage Scaling and Offsets\fR" 2
.IP "\fB-xs##\fR" 5
Scale the width of the page by \fB##\fR.  The default is 1.0 (no
scaling). 
.IP "\fB-ys##\fR" 5
Scale the length of the page by \fB##\fR.  The default is 1.0 (no
scaling).
.IP "\fB-xo##\fR" 5
Offset the left margin by \fB##\fR inches.  The default is 0.0 inches. 
.IP "\fB-yo##\fR" 5
Offest the top margin by \fB##\fR inches.  The default is 0.0 inches.
.IP "\fBMiscellaneous\fR" 2
.IP "\fB-X\fR" 5
Print a list of all options recognized.
.IP "\fB-w\fR" 5
Do not print warning messages.
.SH "SEE ALSO"
Please refer to your local printing software to determine how to send
the \fIPostScript\fR output of \fBlj2ps\fR to your printer.
.SH RESTRICTIONS
Only a subset of \fIPCL 4\fR is currently recognized.
.SH DIAGNOSTICS
.PP
\fBljlpr\fR will return with exit code 0 if no errors are
encountered or exit code 1 if a fatal error occurs.
.PP
Four types of messages are printed:
.PP
\fBWarnings\fR are printed to inform the user of possible problems
with the output.  Although warnings are never serious, they do
indicate possible problems with the LaserJet commands, or features
being used that are not actually implemented in \fBlj2ps\fR.  Warnings
can be turned off with the \fB-w\fR option.
.PP
\fBErrors\fR indicate recoverable problems in the input or output that
should be corrected.  The program will continue running if an error is
encountered, although the output will likely be missing some features.
.PP
\fBFatal Errors\fR are non-recoverable errors, and will cause the
program to immediately terminate with a non-zero exit code.  Fatal
errors must be corrected before \fBlj2ps\fR will accept the entire
input file.
.PP
\fBInternal Errors\fR indicate that an internal consistency check has
failed, and will cause immediate termination of execution.  Please
contact the person maintaining \fBlj2ps\fR and describe the internal
error, so that she or he may fix it.
.SH BUGS
.PP
Tabs do not work properly with proportional fonts.  However, the
\fILaserJet\fR's scheme for handling tabs with proportional fonts is
badly botched, so you shouldn't be using proportional fonts anyway.
.PP
The behavior of the HMI command is different from the \fILaserJet\fR.
.PP
The \fIPostScript\fR file produced by \fBlj2ps\fR is not suitable as
\fIEncapsulated PostScript,\fR because initclip is used to reset the
right margin.


