/*
** Project:		lj2ps
** File:		scan.h
**
** Author:		Christopher Lishka
** Organization:	Wisconsin State Laboratory of Hygiene
**			Data Processing Dept.
**
** Copyright (C) 1990 by Christopher Lishka.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

  /* Global constants
  */
#define MAX_BUFFER  1024	/* The maximum size of the token buffer */
  /* Persistent scanner states */
#define SS_TEXT            1
#define SS_PARAM           2
  /* Tokens returned */
#define TEXT_lp          201	/* Normal text tokens */
#define TEXT_rp          202
#define TEXT_bslash      203
#define TEXT_NEWLINE     204
#define TEXT_FORMFEED	 205
#define TEXT_NULL        206
#define TEXT_CHAR	 207
#define TEXT_TAB         208
#define TEXT_SH_IN       209
#define TEXT_SH_OUT      210
#define CMD_UNDEF        300	/* Command tokens */
#define CMD_E		 301
#define CMD_Y		 302
#define CMD_Z		 303
#define CMD_9		 304
#define	CMD_eq	         305
#define CMD_lp	         306
#define CMD_rp	         307
#define CMD_lp_s	 308
#define CMD_rp_s	 309
#define CMD_amp_a	 310
#define CMD_amp_d	 311
#define CMD_amp_f	 312
#define CMD_amp_k	 313
#define CMD_amp_l	 314
#define CMD_amp_p	 315
#define CMD_amp_s	 316
#define CMD_star_b       317
#define CMD_star_c	 318
#define CMD_star_p	 319
#define CMD_star_r	 320
#define CMD_star_t	 321
#define PARAM_CONTINUE   401	/* Parameter tokens */
#define PARAM_END        402
#define PARAM_UNDEF      403
  /* Position codes */
#define POS_ABSOLUTE     501
#define POS_REL_POSITIVE 502
#define POS_REL_NEGATIVE 503

  /* Global structure and type definitions
  */
typedef struct {		/* Input buffer */
  int   code;			/* The token code */
  int   length;			/* Number of characters put back */
  char  storage[MAX_BUFFER];	/* Storage for characters in the buffer */
} token;

  /* Global variables
  */
extern int    scan_state;	/* Controls which scanner is being used */
extern char  *text;		/* Text read in for text tokens */
extern char  *command;		/* Command read in */
extern char   variable[];	/* Command parameter */
extern char   number[];		/* Command numeric argument */
extern int    pos_code;		/* Command numeric position code */
extern token  curr_token;	/* Where to hold the scanned token */

  /* Global macro definitions
  */

  /* Global functions
  */
extern int  scan();		/* The entry into the scanners */
extern void scan_init();	/* Reset the input for the scanner */
