/* Project:        lj2ps
** File:	   lj2ps.c
**
** Author:	   Christopher Lishka
** Organization:   Wisconsin State Laboratory of Hygiene
**		   Data Processing Dept.
**
** Copyright (C) 1990 by Christopher Lishka.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static char *ModuleID = "Module lj2ps: 1.2, release";
static char *RCSid = "$Header: lj2ps.c,v 1.2 90/07/07 11:03:46 lishka Production $";

  /* Include files
  */
#include <stdio.h>
#include <math.h>
#include "lj2ps.h"
#include "lj.h"
#include "trans.h"
#include "errors.h"

  /* External definitions
  */

  /* Global variables
  */
#ifdef DEBUG
int    debug;			/* True if debugging is on */
#endif
int    warnings;		/* True if warnings are printed */

  /* Global function list
  */
extern int   main();

  /* Local constants
  */
#define MAX_NAME 256

  /* Local structures and types
  */

  /* Local variables
  */

  /* Local macro definitions
  */
#define option(x)    (!(strncmp(x, argv[counter], strlen(x))))
#define argument(x)  (&(argv[counter][strlen(x)]))
#define file()       (argv[counter][0] != '-')

  /* Local function list
  */
static void  syntax();

  /* Function bodies
  */

  /* syntax() prints the legal syntax of this program to stderr
  */
static void
syntax(stream)
     FILE *stream;
{

  fprintf(stream, "%s %s (%s): the correct syntax is\n",
	  PROGRAM, VERSION, STATUS);
  fprintf(stream, "     %s [options] [files]\n", PROGRAM);
  fputs("\
If no files are listed, input is taken from stdin.\n\
The following options are recognized (## indicates an argument):\n\
\n\
    LaserJet II Front Panel Selections:                      Default:\n\
        -c##     Number of copies                              1 copy\n\
        -mf      Manual feed                                   Automatic feed\n\
        -fs##    Font source (left, right, internal, or soft)  Internal\n\
        -fn##    Font number                                   Font 0\n\
        -fl##    Form length                                   60 lines\n\
    Page Orientation:\n\
        -p       Portrait mode                                 Portrait mode\n\
        -l       Landscape mode                                Portrait mode\n\
    Page Scaling and Offsets:\n\
        -xs##    Scale the width (x axis)                      1.0\n\
        -xo##    Offset of left margin (x axis)                0.0\n\
        -ys##    Scale the length (y axis)                     1.0\n\
        -yo##    Offset of top margin (y axis)                 0.0\n\
    Miscellaneous:\n\
        -X       Print this syntax list\n\
        -w       Do not print warning messages                 Print warnings\n\
", stream);
#ifdef DEBUG
  fputs("\
        -d##     Debug level (0 = off)                         Off (0)\n\
", stream);
#endif

} /* syntax() */


  /* main() hands off the work to the appropriate functions, as needed.
  */
int
main(argc, argv)
    int argc; char *argv[];
{
  int   arguments;		/* True while still reading the arguments */
  int   counter;		/* Generic counter */
  FILE *input_file;		/* Current file being read */
  FILE *output_file;		/* The file where stuff should be written */
  int   tmp_form;		/* Temporary storage for panel_form */

    /* Turn warnings on */
  warnings = 1;

    /* Only stdout is being written to */
  output_file = stdout;

    /* Set the "factory defaults" */
  lj_factory_setup();		/* Like you just took it out of the box! */

    /* Parse the command line */
  tmp_form = -1;
  arguments = 1;
  for( counter = 1; arguments && (counter < argc); counter++ ){

    if( option("-X") ){  syntax(stdout); exit(0);  }

#ifdef DEBUG
      /* -d: debug */
    else if( option("-d") ){
      warning("debugging mode is on", "");
      debug = atoi(argument("-d"));
    }
#endif

      /* -w: turn off warnings */
    else if( option("-w") ){  warnings = 0; }

      /* -c: number of copies */
    else if( option("-c") ){  panel_copies = atoi(argument("-c"));  }

      /* -mf: manual feed */
    else if( option("-mf") ){ panel_manual_feed = LJ_PS_MANUAL;  }

      /* -fs: font source */
    else if( option("-fs") ){
      if(   (strcmp(argument("-fs"), "L") == 0)
	 || (strcmp(argument("-fs"), "l") == 0)
	 || (strcmp(argument("-fs"), "Left") == 0)
	 || (strcmp(argument("-fs"), "left") == 0)
	 || (strcmp(argument("-fs"), "LEFT") == 0) ){
	panel_font_source = LJ_FS_LEFT;
      }
      else if(   (strcmp(argument("-fs"), "R") == 0)
	      || (strcmp(argument("-fs"), "r") == 0)
	      || (strcmp(argument("-fs"), "Right") == 0)
	      || (strcmp(argument("-fs"), "right") == 0)
	      || (strcmp(argument("-fs"), "RIGHT") == 0) ){
	panel_font_source = LJ_FS_RIGHT;
      }
      else if(   (strcmp(argument("-fs"), "I") == 0)
	      || (strcmp(argument("-fs"), "i") == 0)
	      || (strcmp(argument("-fs"), "Internal") == 0)
	      || (strcmp(argument("-fs"), "internal") == 0)
	      || (strcmp(argument("-fs"), "INTERNAL") == 0) ){
	panel_font_source = LJ_FS_INTERNAL;
      }
      else if(   (strcmp(argument("-fs"), "S") == 0)
	      || (strcmp(argument("-fs"), "s") == 0)
	      || (strcmp(argument("-fs"), "Soft") == 0)
	      || (strcmp(argument("-fs"), "soft") == 0)
	      || (strcmp(argument("-fs"), "SOFT") == 0) ){
	panel_font_source = LJ_FS_SOFT;
      }
      else{
	syntax(stderr);
	fatal_error("unrecognized font source", argument("-fs"));
      }
    } /* if( -fs ) */

      /* -fn: font number */
    else if( option("-fn") ){ panel_font_number = atoi(argument("-fn")); }

      /* -p: portrait mode */
    else if( option("-p") ){  panel_orientation = LJ_OR_PORTRAIT;  }

      /* -l: landscape mode */
    else if( option("-l") ){  panel_orientation = LJ_OR_LANDSCAPE; }

      /* -fl: text length (i.e. lines per page) */
    else if( option("-fl") ){ tmp_form = atoi(argument("-fl"));    }

      /* -xs: scale in the x direction */
    else if( option("-xs") ){ ps_scale_x = atof(argument("-xs"));  }

      /* -ys: scale in the y direction */
    else if( option("-ys") ){ ps_scale_y = atof(argument("-ys"));  }

      /* -xo: offset in the x direction */
    else if( option("-xo") ){ ps_offset_x = atof(argument("-xo")); }

      /* -yo: offset in the y direction */
    else if( option("-yo") ){ ps_offset_y = -(atof(argument("-yo"))); }

      /* File argument */
    else if( file() ){
      arguments = 0;
      break;
    } /* if( file ) */

    else{ syntax(stdout); fatal_error("unrecognized option", argv[counter]); }
    
  } /* for(...) */

    /* Adjust the default text length to the orientation */
  if( tmp_form > 0 ){
    panel_form = tmp_form;
  }
  else{
    if( panel_orientation == LJ_OR_LANDSCAPE ){
      panel_form = 45;
    }
  }

    /* Initialize the postscript file */
  lj_startup(output_file);
  lj_page_begin(output_file);

    /* Transform the input */
  if( arguments ){
    transform(stdin, output_file);
  } /* if */
  else{
    for( ; counter < argc; counter ++ ){
      if( (input_file = fopen(argv[counter], "r")) == (FILE *) NULL ){
	fatal_error("unable to open input file", argv[counter]);
      }
      transform(input_file, output_file); /* Transform LJ PCL -> Postscript */
      if( fclose(input_file) == EOF ){
	internal_error("unable to close input file", argv[counter]);
      }
    } /* for */
  } /* else */

    /* Finish up the postscript job */
  lj_page_end(output_file);
  lj_shutdown(output_file);

    /* To shut lint and tcc up! */
  return( 0 );

} /* main() */
