/* Project:        lj2ps, LaserJet PCL to PostScript translator
** File:	   errors.c
**
** Author:	   Christopher Lishka
** Organization:   Wisconsin State Laboratory of Hygiene
**		   Data Processing Dept.
**
** Copyright (C) 1990 by Christopher Lishka.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static char * ModuleID = "Module errors: v1.0, production";

#include <stdio.h>
#include "errors.h"
#include "lj2ps.h"


  /* Functions */
extern void  warning();
extern void  error();
extern void  fatal_error();
extern void  internal_error();



  /* warning() prints a message to stderr about a minor problem.
  */
void
warning(message, argument)
    char *message, *argument;
{

  if( warnings ){
    fprintf(stderr, "%s %s (%s): WARNING\n", PROGRAM, VERSION, STATUS);
    fprintf(stderr, "%s", message);
    if( argument[0] != '\0' ) fprintf(stderr, " (%s)\n\n", argument);
    else                      fprintf(stderr, "\n\n");
  }

} /* warning() */



  /* error() prints a message to stderr about a major but recoverable problem.
  */
void
error(message, argument)
    char *message, *argument;
{

  fprintf(stderr, "%s %s (%s): ERROR\n", PROGRAM, VERSION, STATUS);
  fprintf(stderr, "%s", message);
  if( argument[0] != '\0' ) fprintf(stderr, " (%s)\n\n", argument);
  else                      fprintf(stderr, "\n\n");

} /* error() */



  /* fatal_error() prints a message to stderr about a major and
  ** unrecoverable problem, then exits gracelessly.
  */
void
fatal_error(message, argument)
    char *message, *argument;
{

  fprintf(stderr, "%s %s (%s): FATAL ERROR\n", PROGRAM, VERSION, STATUS);
  fprintf(stderr, "%s", message);
  if( argument[0] != '\0' ) fprintf(stderr, " (%s)\n\n", argument);
  else                      fprintf(stderr, "\n\n");

  exit(1);

} /* fatal_error() */



  /* internal_error() reports an inconsistency in the program itself.
  ** After the error message is reported, the program is killed
  ** gracelessly.
  */
void
internal_error(message, argument)
    char *message, *argument;
{

  fprintf(stderr, "%s %s (%s): INTERNAL ERROR\n", PROGRAM, VERSION, STATUS);
  fprintf(stderr, "%s", message);
  if( argument[0] != '\0' ) fprintf(stderr, " (%s)\n\n", argument);
  else                      fprintf(stderr, "\n\n");

  exit(2);

} /* internal_error() */

