/*
        HPGL to PostScript converter
   Copyright (C) 1988 (and following) Federico Heinz

yahp2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone
for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the Free Software Foundation's General Public License for full details.

Everyone is granted permission to copy, modify and redistribute yahp2ps,
but only under the conditions described in the GNU General Public
License.  A copy of this license is supposed to have been given to you
along with yahp2ps so you can know your rights and responsibilities.  It
should be in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.

In other words, go ahead and share yahp2ps, but don't try to stop
anyone else from sharing it farther.  Help stamp out software hoarding!

yahp2ps is TOTALLY unrelated to GNU or the Free Software Foundation,
it is only released under the same conditions.

    For bug reports, wishes, etc. send e-mail to

    ...!mcvax!unido!tub!actisb!federico  (from Europe)
    ...!uunet!pyramid!actisb!federico    (from anywhere else)

    For Physical mail:

    Federico Heinz
    Beusselstr. 21
    1000 Berlin 21

    Tel. (+49 30) 396 77 92

*/
/**********************************************************************

   Number multiplication & division.

**********************************************************************/


#include "defs.h"


/*

  Make both operands positive, return True if result will be negative.

*/

static Boolean makePositive(a, b)

Number *a, *b;

{ Boolean negative;

  if (negative = (*a < Zero)) *a = -*a;
  if (*b < Zero)
  { *b = -*b;
    negative = !negative;
  }
  return(negative);
}



/*

  Return a * b.

  Algorithm: multiply (m 10^4 + n) (p 10^4 + q) , then divide by 10^4
  to realign the decimal point.

  [ m 10^4 p 10^4 + m 10^4 q + n p 10^4 + n q ] / 10^-4 =
  m p 10^4 + m q + n p + n q 10-4
  
  Since I keep 4 decimal digit precision, only digits overflowing
  9999 in the term (n q 10^-4) are taken into account.

*/

Number mulNum(a, b)

Number a, b;

{ Number n, p, q;
  Boolean negative;
  Number result, carry;

  negative = makePositive(&a, &b);  
  n = a % One;
  p = b / One; q = b % One;
  result = (a / One) * (p * One + q) + n * p + ((n * q) / One);
  return(negative ? -result : result);
}



/*

  Return a / b.

  Algorithm: In case b has no dec places, then simply divide a by (b/10^4).
    Otherwise, a must be multiplyed by 10^4 before the division in order
    to get the decimals places right. But that can lead to overflow.
    So let a = m 10^4 + n
    
  [(m 10^4 + n) 10^4 ] / b = (m 10^8) / b + (n 10^4) / b
  
  [(n 10^4) / b] is easily computed. Now let (m 10^4) = (q b + r).
  Then,
  
  (m 10^8) / b = [(q b + r) 10^4] / b = [(q b 10^4) / b] + [(r 10^4) / b] =
  (q 10^4) + [(r 10^4) / b]
  
  Where both terms are easily computed. The complete formula is then
  
  a / b = q 10^4 + (r 10^4) / b + (n 10^4) / b =
          q 10^4 + [(r + n) 10^4] / b

  [ Phew! ]

*/

Number divNum(a, b)

Number a, b;

{ Number q, m, result;
  Boolean negative;

  if (!(b % One))		/* Easy case: no decimals in divisor */
    return(a / (b / One));
  negative = makePositive(&a, &b);
  m = trunc(a);
  q = m / b;
  result = q * One + (((m - q * b) + (a % One)) * One) / b;
  return(negative ? -result : result);
}
