/*
        HPGL to PostScript converter
   Copyright (C) 1988 (and following) Federico Heinz

yahp2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone
for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the Free Software Foundation's General Public License for full details.

Everyone is granted permission to copy, modify and redistribute yahp2ps,
but only under the conditions described in the GNU General Public
License.  A copy of this license is supposed to have been given to you
along with yahp2ps so you can know your rights and responsibilities.  It
should be in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.

In other words, go ahead and share yahp2ps, but don't try to stop
anyone else from sharing it farther.  Help stamp out software hoarding!

yahp2ps is TOTALLY unrelated to GNU or the Free Software Foundation,
it is only released under the same conditions.

    For bug reports, wishes, etc. send e-mail to

    ...!mcvax!unido!tub!actisb!federico  (from Europe)
    ...!uunet!pyramid!actisb!federico    (from anywhere else)

    For Physical mail:

    Federico Heinz
    Beusselstr. 21
    1000 Berlin 21

    Tel. (+49 30) 396 77 92

*/
/**************************************************************************

  Input/Output definitions.

***************************************************************************/

#ifndef EOF

#define EOF     (-1)

#endif

/* Check whether char can be beginning of a number */

#define isNumeric(x) (isdigit(x) || ((x) == '+') || \
			((x) == '-') || ((x) == '.'))

/* One-char lookahead buffer */

extern int LookAhead;


extern void    skipSeparator(); /* Skip over one or more HPGL separators   */
extern void    skipTerminator();/* Skip over one or more HPGL terminators  */
extern int     getChar();       /* Get the next char from the input stream */
extern void    putChar();	/* Put a char to the output stream         */
extern Boolean getNumber();     /* Get a Number from the input stream      */
extern Boolean ASCIIToNumber(); /* Get a Number from an alpha string       */
extern Boolean getInteger();    /* Get an Integer from the in stream       */
                                /* Get a CoordinatePair from the in stream */
extern Boolean getCoordinatePair();
extern void    endCommand();    /* Check for excess parameters & skip Term.*/
extern void    writeNumber();   /* Put a Number to the output stream       */
                                /* Put a CoordinatePair to the out stream  */
extern void    writeCoordinatePair();
extern void    writeString();   /* Put a string to the output stream       */

extern Boolean setInput();      /* Reassign the input stream              */
extern Boolean setOutput();     /* Reassign the output stream             */

