/*
        HPGL to PostScript converter
   Copyright (C) 1988 (and following) Federico Heinz

yahp2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone
for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the Free Software Foundation's General Public License for full details.

Everyone is granted permission to copy, modify and redistribute yahp2ps,
but only under the conditions described in the GNU General Public
License.  A copy of this license is supposed to have been given to you
along with yahp2ps so you can know your rights and responsibilities.  It
should be in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.

In other words, go ahead and share yahp2ps, but don't try to stop
anyone else from sharing it farther.  Help stamp out software hoarding!

yahp2ps is TOTALLY unrelated to GNU or the Free Software Foundation,
it is only released under the same conditions.

    For bug reports, wishes, etc. send e-mail to

    ...!mcvax!unido!tub!actisb!federico  (from Europe)
    ...!uunet!pyramid!actisb!federico    (from anywhere else)

    For Physical mail:

    Federico Heinz
    Beusselstr. 21
    1000 Berlin 21

    Tel. (+49 30) 396 77 92

*/
/************************************************************************

   Commands affecting the virtual plotter's global state.

************************************************************************/

#include "defs.h"
#include "dispatch.h"
#include "io.h"
#include "mchinery.h"
#include "penctrl.h"
#include "circle.h"
#include "shade.h"
#include "tick.h"
#include "global.h"
#include "char.h"


/*

  Set the default values for the parameters controlled by this module.

*/

void globalInit()

{ resetWindow();
  turnScalingOff();
}


/*

  Restore default values of all modules.

*/

void restoreDefaults()

{ globalInit();
  basicInit();
  shadeInit();
  tickInit();
  charInit();
}


/*

  Reset default values for plotter opeartion.

*/

CommandImplementation setDefaults()

{ restoreDefaults();
  endCommand();
}


/*

  Restart plotter.

*/

CommandImplementation initialize()

{ penctrlInit();
  restoreDefaults();
  endCommand();
}


CommandImplementation inputP1P2()

{ CoordinatePair newPlotterP1, newPlotterP2;

  if (isTerminator(LookAhead))
    resetP1P2();
  else if (getCoordinatePair(newPlotterP1))
  { if (isTerminator(LookAhead) || !getCoordinatePair(newPlotterP2))
    { newPlotterP2[X] += newPlotterP1[X] - PlotterP1[X];
      newPlotterP2[Y] += newPlotterP1[Y] - PlotterP1[Y];
    }
    changeP1P2(newPlotterP1, newPlotterP2);
  }
  endCommand();
}



/*

  Set the clipping rectangle.

*/

CommandImplementation inputWindow()

{ CoordinatePair corner1, corner2;

  if (isTerminator(LookAhead) || !getCoordinatePair(corner1) ||
      !getCoordinatePair(corner2))
    resetWindow();
  else 
  { corner1[X] = trunc(corner1[X]);
    corner1[Y] = trunc(corner1[Y]);
    corner2[X] = trunc(corner2[X]);
    corner2[Y] = trunc(corner2[Y]);
    setWindow(corner1,corner2);
  }
  endCommand();
}



CommandImplementation setPaperSize()

{ Number temp;

  if (getInteger(&temp))
    if (temp < PaperSizeLimit)
      warning("Sorry, only DIN A4 paper currently supported.");
}



/*

  Rotate the coordinate system.

*/

CommandImplementation rotateCoordSys()

{ Number angle;

  if (isTerminator(LookAhead))
    unRotate();
  else if (getNumber(&angle))
    if (angle == Zero)
      unRotate();
    else if (angle == OneSquare)
      rotate();
    else
      warning("Erroneous rotation angle.");
  endCommand();
}



CommandImplementation setScale()

{ CoordinatePair newUserP1, newUserP2;

  if (isTerminator(LookAhead))
    turnScalingOff();
  else if (getNumber(&newUserP1[X]) && getNumber(&newUserP2[X]) &&
           getNumber(&newUserP1[Y]) && getNumber(&newUserP2[Y]))
    turnScalingOn(newUserP1, newUserP2);
  endCommand();
}




