/*
        HPGL to PostScript converter
   Copyright (C) 1988 (and following) Federico Heinz

yahp2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone
for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the Free Software Foundation's General Public License for full details.

Everyone is granted permission to copy, modify and redistribute yahp2ps,
but only under the conditions described in the GNU General Public
License.  A copy of this license is supposed to have been given to you
along with yahp2ps so you can know your rights and responsibilities.  It
should be in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.

In other words, go ahead and share yahp2ps, but don't try to stop
anyone else from sharing it farther.  Help stamp out software hoarding!

yahp2ps is TOTALLY unrelated to GNU or the Free Software Foundation,
it is only released under the same conditions.

    For bug reports, wishes, etc. send e-mail to

    ...!mcvax!unido!tub!actisb!federico  (from Europe)
    ...!uunet!pyramid!actisb!federico    (from anywhere else)

    For Physical mail:

    Federico Heinz
    Beusselstr. 21
    1000 Berlin 21

    Tel. (+49 30) 396 77 92

*/
/***************************************************************************

   Edge drawing stuff.

***************************************************************************/


#include <ctype.h>
#include "defs.h"
#include "dispatch.h"
#include "io.h"
#include "circle.h"
#include "penctrl.h"




/**************************************************************************

    Rectangle functions: absolute & relative.

**************************************************************************/

/*

  Draw a rectangle with one corner at current position and the opposite
  at the specified absolute CoordinatePair.

*/


static void doRectangle(oppositeCorner)

CoordinatePair oppositeCorner;

{ CoordinatePair thisCorner;
  Boolean penWasUp;

  penWasUp = PenIsUp;
  lowerPen();
  thisCorner[X] = PenPosition[X]; thisCorner[Y] = PenPosition[Y];
  doLine(thisCorner[X], oppositeCorner[Y]);
  doLine(oppositeCorner[X], oppositeCorner[Y]);
  doLine(oppositeCorner[X], thisCorner[Y]);
  doLine(thisCorner[X], thisCorner[Y]);
  if (penWasUp) liftPen();
}




/*

  Draw a rectangle, interprete the coordinates as absolute.

*/

CommandImplementation rectangleAbsolute()

{ CoordinatePair corner;

  if (getCoordinatePair(corner))
    doRectangle(corner);
  endCommand();
}




/*

  Draw a rectangle, interprete the coordinates relative to PenPosition

*/

CommandImplementation rectangleRelative()

{ CoordinatePair corner;

  if (getCoordinatePair(corner))
  { corner[X] = PenPosition[X] + corner[X];
    corner[Y] = PenPosition[Y] + corner[Y];
    doRectangle(corner);
  }
  endCommand();
}




/***************************************************************************

     Curve functions: wedge, circle and arc

***************************************************************************/



/*

  Move the pen along an arc. The pen must already be at the start
  of the arc. The chordAngle should divide the sweepAngle and (of course)
  be != 0. If it does not divide the sweepAngle, then the last chord
  will be shorter.

*/

void doArc(center, radius, startAngle, sweepAngle, chordAngle)

CoordinatePair center;
Number radius, startAngle, sweepAngle, chordAngle;

{ Number currentAngle, endAngle;
  CoordinatePair thisPoint;
  int times;

  times = sweepAngle / chordAngle;
  if (times < 0)
  { chordAngle = -chordAngle;
    times = -times;
  }
  currentAngle = startAngle;
  while (times--)
  { currentAngle = currentAngle + chordAngle;
    polarToCartesian(thisPoint, center, radius, currentAngle);
    doLine(thisPoint[X], thisPoint[Y]);
  }
  if (sweepAngle % chordAngle)
  { polarToCartesian(thisPoint, center, radius, startAngle + sweepAngle);
    doLine(thisPoint[X], thisPoint[Y]);
  }
}



/*

  Draw a wedge with center at PenPosition.

*/

CommandImplementation wedge()

{ CoordinatePair wedgeCenter, beginOfArc;
  Number radius, startAngle, sweepAngle, chordAngle;
  Boolean penWasUp;

  if (getNumber(&radius) &&
      getInteger(&startAngle) &&
      getInteger(&sweepAngle))
  { penWasUp = PenIsUp;
    fixUpStartAndSweep(&startAngle, &sweepAngle);
    getChordAngle(&chordAngle, sweepAngle, MinimumChordForWedge);
    if (chordAngle > MaximumChordAngle)
      warning("Chord angle out of range.");
    else
    { wedgeCenter[X] = PenPosition[X];
      wedgeCenter[Y] = PenPosition[Y];
      polarToCartesian(beginOfArc, wedgeCenter, radius, startAngle);
      lowerPen();
      doLine(beginOfArc[X],beginOfArc[Y]);
      doArc(wedgeCenter, radius, startAngle, sweepAngle, chordAngle);
      doLine(wedgeCenter[X], wedgeCenter[Y]);
    }
    if (penWasUp) liftPen();
    endCommand();
  }
}



CommandImplementation circle()

{ CoordinatePair center, beginOfArc;
  Number radius, chordAngle;
  Boolean penWasUp;

  if (getNumber(&radius))
  { getChordAngle(&chordAngle, FullCircle, Zero);
    center[X] = PenPosition[X];
    center[Y] = PenPosition[Y];
    penWasUp = PenIsUp;
    liftPen();
    if (chordAngle)
    { polarToCartesian(beginOfArc, center, radius, Zero);
      doLine(beginOfArc[X],beginOfArc[Y]);
      lowerPen();
      doArc(center, radius, Zero, FullCircle, chordAngle);
      liftPen();
    }
    else /* smoothest circle */
    { doHRArc(center, radius, Zero, FullCircle);
      stroke();
    }
    doLine(center[X], center[Y]);
    if (!penWasUp) lowerPen();
  }
  endCommand();
}



/*

  Draw an arc using Absolute coordinates.

*/

static void doAbsoluteArc(center, sweepAngle, chordAngle)

CoordinatePair center;
Number chordAngle, sweepAngle;

{ Number radius, startAngle;
  CoordinatePair delta;

  delta[X] = PenPosition[X] - center[X];
  delta[Y] = PenPosition[Y] - center[Y];
  cartesianToPolar(&radius, &startAngle, delta);
  fixUpStartAndSweep(&startAngle, &sweepAngle);
  if (chordAngle)
    doArc(center, radius, startAngle, sweepAngle, chordAngle);
  else /* smoothest circle */
  { if (!PenIsUp)
      doHRArc(center, radius, startAngle, sweepAngle);
    polarToCartesian(PenPosition, center, radius, startAngle + sweepAngle);
  }
}



/*

  Arc Absolute command

*/

CommandImplementation arcAbsolute()

{ CoordinatePair center;
  Number sweepAngle, chordAngle;
  
  if (getCoordinatePair(center) &&
      getInteger(&sweepAngle))
  { getChordAngle(&chordAngle, sweepAngle, Zero);
    doAbsoluteArc(center, sweepAngle, chordAngle);
  }
  endCommand();
}



/*

  Arc Relative command

*/

CommandImplementation arcRelative()

{ CoordinatePair center;
  Number sweepAngle, chordAngle;
  
  if (getCoordinatePair(center) &&
      getInteger(&sweepAngle))
  { getChordAngle(&chordAngle, sweepAngle, Zero);
    center[X] = PenPosition[X] + center[X];
    center[Y] = PenPosition[Y] + center[Y];
    doAbsoluteArc(center, sweepAngle, chordAngle);
  }
  endCommand();
}
