/*
        HPGL to PostScript converter
   Copyright (C) 1988 (and following) Federico Heinz

yahp2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone
for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the Free Software Foundation's General Public License for full details.

Everyone is granted permission to copy, modify and redistribute yahp2ps,
but only under the conditions described in the GNU General Public
License.  A copy of this license is supposed to have been given to you
along with yahp2ps so you can know your rights and responsibilities.  It
should be in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.

In other words, go ahead and share yahp2ps, but don't try to stop
anyone else from sharing it farther.  Help stamp out software hoarding!

yahp2ps is TOTALLY unrelated to GNU or the Free Software Foundation,
it is only released under the same conditions.

    For bug reports, wishes, etc. send e-mail to

    ...!mcvax!unido!tub!actisb!federico  (from Europe)
    ...!uunet!pyramid!actisb!federico    (from anywhere else)

    For Physical mail:

    Federico Heinz
    Beusselstr. 21
    1000 Berlin 21

    Tel. (+49 30) 396 77 92

*/
/**************************************************************************

  Define the HPGL Command data type

***************************************************************************/


#define Command int

extern Command getCommand();    /* Get the next Command from the in stream */


/* These are the valid Commands */

#define NotImplemented          0       /* Useless functions in PostScript */
#define Interactive             1       /* Fuctions requiring Plotter-
                                           -Computer interaction */
#define ArcAbsolute             2
#define ArcRelative             3
#define SetAlternateChar        4
#define Circle                  5
#define CharacterPlot           6
#define SetStandardChar         7
#define SetDefaults             8
#define SetAbsoluteDirection    9
#define SetRelativeDirection    10
#define SetLabelTerminator      11
#define RectangleAbsolute       12
#define RectangleRelative       13
#define Wedge                   14
#define SetFillType             15
#define Initialize              16
#define InputP1P2               17
#define InputWindow             18
#define PutASCIILabel           19
#define SetLineType             20
#define SetAbsolutePlot         21
#define PenDown                 22
#define SetRelativePlot         23
#define SetPaperSize            24
#define PenUp                   25
#define ShadeRectAbsolute       26
#define RotateCoordSys          27
#define ShadeRectRelative       28
#define SelectAlternate         29
#define SetScale                30
#define SetAbsoluteCharSize     31
#define SetAbsoluteCharSlant    32
#define SetSymbolMode           33
#define SelectPen               34
#define SetRelativeCharSize     35
#define SelectStandard          36
#define SetTickLength           37
#define UserChar                38
#define ShadeWedge              39
#define XTick                   40
#define YTick                   41
#define PenThickness		42

#define NumberOfCommands        43



/***************************************************************************

   Define the CommandImplementation type.

***************************************************************************/

typedef void CommandImplementation;



/****************************************************************************

    These functions implement each command

****************************************************************************/

extern CommandImplementation notImplemented();
extern CommandImplementation interactive();
extern CommandImplementation arcAbsolute();
extern CommandImplementation arcRelative();
extern CommandImplementation setAlternateChar();
extern CommandImplementation circle();
extern CommandImplementation characterPlot();
extern CommandImplementation setStandardChar();
extern CommandImplementation setDefaults();
extern CommandImplementation setAbsoluteDirection();
extern CommandImplementation setRelativeDirection();
extern CommandImplementation setLabelTerminator();
extern CommandImplementation rectangleAbsolute();
extern CommandImplementation rectangleRelative();
extern CommandImplementation wedge();
extern CommandImplementation setFillType();
extern CommandImplementation initialize();
extern CommandImplementation inputP1P2();
extern CommandImplementation inputWindow();
extern CommandImplementation putASCIILabel();
extern CommandImplementation setLineType();
extern CommandImplementation setAbsolutePlot();
extern CommandImplementation penDown();
extern CommandImplementation setRelativePlot();
extern CommandImplementation setPaperSize();
extern CommandImplementation penUp();
extern CommandImplementation shadeRectAbsolute();
extern CommandImplementation rotateCoordSys();
extern CommandImplementation shadeRectRelative();
extern CommandImplementation selectAlternate();
extern CommandImplementation setScale();
extern CommandImplementation setAbsoluteCharSize();
extern CommandImplementation setAbsoluteCharSlant();
extern CommandImplementation setSymbolMode();
extern CommandImplementation selectPen();
extern CommandImplementation setRelativeCharSize();
extern CommandImplementation selectStandard();
extern CommandImplementation setTickLength();
extern CommandImplementation userChar();
extern CommandImplementation shadeWedge();
extern CommandImplementation xTick();
extern CommandImplementation yTick();
extern CommandImplementation penThickness();
