/*
        HPGL to PostScript converter
   Copyright (C) 1988 (and following) Federico Heinz

yahp2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone
for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the Free Software Foundation's General Public License for full details.

Everyone is granted permission to copy, modify and redistribute yahp2ps,
but only under the conditions described in the GNU General Public
License.  A copy of this license is supposed to have been given to you
along with yahp2ps so you can know your rights and responsibilities.  It
should be in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.

In other words, go ahead and share yahp2ps, but don't try to stop
anyone else from sharing it farther.  Help stamp out software hoarding!

yahp2ps is TOTALLY unrelated to GNU or the Free Software Foundation,
it is only released under the same conditions.

    For bug reports, wishes, etc. send e-mail to

    ...!mcvax!unido!tub!actisb!federico  (from Europe)
    ...!uunet!pyramid!actisb!federico    (from anywhere else)

    For Physical mail:

    Federico Heinz
    Beusselstr. 21
    1000 Berlin 21

    Tel. (+49 30) 396 77 92

*/
/***********************************************************************

   Draw vertical or horizontal ticks.

***********************************************************************/


#include "defs.h"
#include "dispatch.h"
#include "io.h"
#include "mchinery.h"
#include "penctrl.h"
#include "tick.h"


			/* Percentages of P2-P1 */
static Number PositiveTick, NegativeTick;

			/* Lengths of the corresponding ticks */
static Number PositiveXTick, NegativeXTick,
              PositiveYTick, NegativeYTick;



/*

  Adjust tick parameters to a new environment.

*/

void updateTicks()

{ Number deltaX, deltaY;

  if ((deltaX = PlotterP2[X] - PlotterP1[X]) < 0) deltaX = -deltaX;
  if ((deltaY = PlotterP2[Y] - PlotterP1[Y]) < 0) deltaY = -deltaY;
  PositiveXTick = mulNum(PositiveTick, deltaY / 100);
  NegativeXTick = mulNum(NegativeTick, deltaY / 100);
  PositiveYTick = mulNum(PositiveTick, deltaX / 100);
  NegativeYTick = mulNum(NegativeTick, deltaX / 100);
}



/*

  Reset tick parameters to default values.

*/

void tickInit()

{ PositiveTick = InitialTick;
  NegativeTick = InitialTick;
  updateTicks();
}



/*

  Change the relative tick length.

*/

CommandImplementation setTickLength()

{ if (isTerminator(LookAhead) || !getInteger(&PositiveTick))
    tickInit();
  else
  { if (isTerminator(LookAhead) || !getInteger(&NegativeTick))
      NegativeTick = Zero;
    updateTicks();
  }
  endCommand();
}



/*

  Do a X-axis tick.

*/

CommandImplementation xTick()

{ doXTick(PositiveXTick, NegativeXTick);
  endCommand();
}



/*

  Do a Y-axis tick.

*/

CommandImplementation yTick()

{ doYTick(PositiveYTick, NegativeYTick);
  endCommand();
}




