/*
        HPGL to PostScript converter
   Copyright (C) 1988 (and following) Federico Heinz

yahp2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone
for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the Free Software Foundation's General Public License for full details.

Everyone is granted permission to copy, modify and redistribute yahp2ps,
but only under the conditions described in the GNU General Public
License.  A copy of this license is supposed to have been given to you
along with yahp2ps so you can know your rights and responsibilities.  It
should be in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.

In other words, go ahead and share yahp2ps, but don't try to stop
anyone else from sharing it farther.  Help stamp out software hoarding!

yahp2ps is TOTALLY unrelated to GNU or the Free Software Foundation,
it is only released under the same conditions.

    For bug reports, wishes, etc. send e-mail to

    ...!mcvax!unido!tub!actisb!federico  (from Europe)
    ...!uunet!pyramid!actisb!federico    (from anywhere else)

    For Physical mail:

    Federico Heinz
    Beusselstr. 21
    1000 Berlin 21

    Tel. (+49 30) 396 77 92

*/
/************************************************************************

  Shaded figures.

************************************************************************/


#include "defs.h"
#include "dispatch.h"
#include "mchinery.h"
#include "io.h"
#include "penctrl.h"
#include "circle.h"
#include "shade.h"

static Number FillType;            /* Kind of area filling pattern   */
static Number FillSpacing;         /* Spacing betwen lines */
static Number FillAngle;           /* Angle at which to draw pattern */
static Number PenWidth;            /* User-set pen width */


/*

  Set the default parameter values for this module.

*/

void shadeInit()

{ FillType = DefaultFillType;
  FillSpacing = P1P2Diagonal / 100;
  FillAngle = Zero;
  PenWidth = DefaultPenWidth;
}

/*

  Set the pen's width.

*/

CommandImplementation penThickness()

{ Number temp;

  if (isTerminator(LookAhead) || !getNumber(&temp))
    PenWidth = DefaultPenWidth;
  else if ((temp < MinPenWidth) || (temp > MaxPenWidth))
    warning("Illegal pen thickness.");
  else
    PenWidth = temp;
  endCommand();
}


/*

  Set the area fill parameters.

*/

CommandImplementation setFillType()

{ Number temp;

  if (isTerminator(LookAhead))
    FillType = DefaultFillType;
  else if (getInteger(&FillType))
    if (!isTerminator(LookAhead) && getNumber(&temp))
    { if (!temp) FillSpacing = PenWidth * PlotterUnitsFactor;
      else if (UserMode) FillSpacing = plotterXCoord(temp);
      if (!isTerminator(LookAhead) && getInteger(&temp))
        if (!(temp % (OneSquare / 2))) FillAngle = temp;
    }
  endCommand();
}



/*

  Shade a rectangle defined in absolute coordinates.

*/

CommandImplementation shadeRectAbsolute()

{ CoordinatePair corner;

  if (getCoordinatePair(corner))
    doShadeRectangle(corner, FillType, FillSpacing, FillAngle);
  endCommand();
}



/*

  Shade a rectangle defined in relative coordinates.

*/

CommandImplementation shadeRectRelative()

{ CoordinatePair corner;

  if (getCoordinatePair(corner))
  { corner[X] = PenPosition[X] + corner[X];
    corner[Y] = PenPosition[Y] + corner[Y];
    doShadeRectangle(corner);
  }
  endCommand();
}



/*

  Shade a circle wedge.

*/

CommandImplementation shadeWedge()

{ Number radius, startAngle, sweepAngle, chordAngle;

  if (getNumber(&radius) &&
      getInteger(&startAngle) &&
      getInteger(&sweepAngle))
  { fixUpStartAndSweep(&startAngle, &sweepAngle);
    getChordAngle(&chordAngle, sweepAngle, MinimumChordForWedge);
    if (chordAngle > MaximumChordAngle)
      warning("Chord angle out of range.");
    else
      doShadeWedge(PenPosition, radius, startAngle, sweepAngle, chordAngle,
                   FillType, FillSpacing, FillAngle);
    endCommand();
  }
}







