/*
        HPGL to PostScript converter
   Copyright (C) 1988 (and following) Federico Heinz

yahp2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone
for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the Free Software Foundation's General Public License for full details.

Everyone is granted permission to copy, modify and redistribute yahp2ps,
but only under the conditions described in the GNU General Public
License.  A copy of this license is supposed to have been given to you
along with yahp2ps so you can know your rights and responsibilities.  It
should be in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.

In other words, go ahead and share yahp2ps, but don't try to stop
anyone else from sharing it farther.  Help stamp out software hoarding!

yahp2ps is TOTALLY unrelated to GNU or the Free Software Foundation,
it is only released under the same conditions.

    For bug reports, wishes, etc. send e-mail to

    ...!mcvax!unido!tub!actisb!federico  (from Europe)
    ...!uunet!pyramid!actisb!federico    (from anywhere else)

    For Physical mail:

    Federico Heinz
    Beusselstr. 21
    1000 Berlin 21

    Tel. (+49 30) 396 77 92

*/
/**************************************************************************

   Ideal interface to the graphics hardware.

**************************************************************************/

/* Paper sizes */

#define A	0
#define A4	1
#define B	2
#define A3	3

/* Constants for A paper */

#define MaxXA		103650000L
#define MaxYA		 79620000L

#define InitialP1XA        2500000L
#define InitialP1YA        5960000L
#define InitialP2XA      102500000L
#define InitialP2YA       77960000L

#define InitialP1XAR       1540000L
#define InitialP1YAR       2440000L
#define InitialP2XAR      73540000L
#define InitialP2YAR     102440000L


/* Constants for DIN A4 paper (Default) */

#define MaxXA4          110400000L
#define MaxYA4           77210000L

#define InitialP1XA4        6030000L
#define InitialP1YA4        5210000L
#define InitialP2XA4      106030000L
#define InitialP2YA4       77210000L

#define InitialP1XA4R         00000L
#define InitialP1YA4R       6100000L
#define InitialP2XA4R      72000000L
#define InitialP2YA4R     106100000L


/* Constants for B paper */

#define MaxXB		166400000L
#define MaxYB		103650000L

#define InitialP1XB         5220000L
#define InitialP1YB         2590000L
#define InitialP2XB       157220000L
#define InitialP2YB       102590000L

#define InitialP1XBR        2830000L
#define InitialP1YBR        9340000L
#define InitialP2XBR      102830000L
#define InitialP2YBR      161340000L


/* Constants for A3 paper */

#define MaxXA3		161580000L
#define MaxYA3		110400000L

#define InitialP1XA3        1700000L
#define InitialP1YA3        6020000L
#define InitialP2XA3      153700000L
#define InitialP2YA3      106020000L

#define InitialP1XA3R       6070000L
#define InitialP1YA3R       7970000L
#define InitialP2XA3R     106070000L
#define InitialP2YA3R     159970000L


#define MaxPen	60000L

#define FullLine 70000L
#define DefaultPatternLength 40000L


extern CoordinatePair PenPosition;          /* Current pen coordinates      */
extern CoordinatePair PlotterP1, PlotterP2; /* Pn's coords in Plotter Space */
extern Number P1P2Diagonal;		    /* Distance between P1 and P2   */

extern Boolean PenIsUp;         /* Is the plotting pen up?                  */
extern Boolean UserMode;	/* Are we plotting in user coordinates?     */


/*

  Convert from user to plotter coordinates

*/

#define PlotterUnitsFactor 40

#define plotterXUnits(x) (UserMode ? \
                           trunc(mulNum(XScaleFactor, (x))) : \
                           trunc(x))
#define plotterYUnits(x) (UserMode ? \
                           trunc(mulNum(YScaleFactor, (x))) : \
                           trunc(x))

#define plotterXCoord(x) (UserMode ? \
                           (trunc(mulNum(XScaleFactor, (x))) + XOrigin) : \
                           trunc(x))
#define plotterYCoord(x) (UserMode ? \
                           (trunc(mulNum(YScaleFactor, (x))) + YOrigin) : \
                           trunc(x))


extern Number XScaleFactor, YScaleFactor;
extern Number XOrigin, YOrigin;


/* Change the location of the scaling points */

extern void changeP1P2();



/* Reset P1 and P2 to default values */

extern void resetP1P2();


/* Set the window to the whole plotting area */

extern void resetWindow();


/* Set the window to a new value */

extern void setWindow();


/* Reset the the pen control status to default values */

extern void penctrlInit();


/* Set the scaling parameters to reflex the current status */

extern void updateScaling();


/* Quit scaling coordinates */

extern void turnScalingOff();



/* From now on, everything will be scaled */

extern void turnScalingOn();



/* Rotate the coordinate system */

extern void rotate();



/* Return coordinate system to default orientation */

extern void unRotate();



/* Moves the pen in it's current state to the absolute coordinates
   indicated in User Space */

extern void doLine();



/* Raises the plotting pen */

extern void liftPen();



/* Puts plotting pen in contact with the paper */

extern void lowerPen();



/* Get a new pen */

extern void changePen();



/* Change the line pattern */

extern void setDash();
