/*
        HPGL to PostScript converter
   Copyright (C) 1988 (and following) Federico Heinz

yahp2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone
for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the Free Software Foundation's General Public License for full details.

Everyone is granted permission to copy, modify and redistribute yahp2ps,
but only under the conditions described in the GNU General Public
License.  A copy of this license is supposed to have been given to you
along with yahp2ps so you can know your rights and responsibilities.  It
should be in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.

In other words, go ahead and share yahp2ps, but don't try to stop
anyone else from sharing it farther.  Help stamp out software hoarding!

yahp2ps is TOTALLY unrelated to GNU or the Free Software Foundation,
it is only released under the same conditions.

    For bug reports, wishes, etc. send e-mail to

    ...!mcvax!unido!tub!actisb!federico  (from Europe)
    ...!uunet!pyramid!actisb!federico    (from anywhere else)

    For Physical mail:

    Federico Heinz
    Beusselstr. 21
    1000 Berlin 21

    Tel. (+49 30) 396 77 92

*/
/***************************************************************************

        Yet Another HPGL to PostScript Converter.


***************************************************************************/


/**************************************************************************

	System-dependent constants.

**************************************************************************/

#define	DEFAULT_PRELUDE "/usr/lib/yahp2ps.pre" /* default prelude file */


/**************************************************************************

   Define the Number data type. It represents the Scaled Decimal
   format of HPGL. In order to get a Number out of a normal integer,
   multiply it by the constant One.

**************************************************************************/



#define Number  long int

#define IntPlaces 5
#define DecPlaces 4


/* A CoordinatePair contains an X and a Y component */

#define X       0
#define Y       1

typedef Number  CoordinatePair[2];


extern Number RelativeCharWidth;   /* Width of each char          */
extern Number RelativeCharHeigth;  /* Heigth of each char         */
extern Number CharacterDirection;  /* Text writing angle          */
extern Number CharacterSlant;      /* Textual slant angle         */

extern Number TN; /* Temporary storage for avoiding side effects
                        in Number-handling macros */


/* Some constants in our numbering system */

#define One             10000L
#define Zero            0L

/* Divide a Number by another (a Number may be divided by an integer the
   usual way) */


extern Number divNum();


/* Multiply a Number by another (again, multiplication by an integer is
   as usual) */


extern Number mulNum();


/* Truncate a number according to the HPGL rules */

#define trunc(x)        (((TN = (x)) % One) ? \
                            ((TN = (TN/One) * One) < 0 ? \
                                (TN - One) : TN) : TN)


/***************************************************************************

   Define the Boolean data type.

***************************************************************************/


#define Boolean int

#define True  1
#define False 0






/* Special character predicates */

#define isSeparator(x)  (((x) == ',') || ((x) == ' '))
#define isTerminator(x) (((x) == ';') || ((x) == '\n'))



/***************************************************************************

  Error handling functions.

***************************************************************************/

extern void warning();
extern void error();




