/*
        HPGL to PostScript converter
   Copyright (C) 1988 (and following) Federico Heinz

yahp2ps is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone
for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the Free Software Foundation's General Public License for full details.

Everyone is granted permission to copy, modify and redistribute yahp2ps,
but only under the conditions described in the GNU General Public
License.  A copy of this license is supposed to have been given to you
along with yahp2ps so you can know your rights and responsibilities.  It
should be in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.

In other words, go ahead and share yahp2ps, but don't try to stop
anyone else from sharing it farther.  Help stamp out software hoarding!

yahp2ps is TOTALLY unrelated to GNU or the Free Software Foundation,
it is only released under the same conditions.

    For bug reports, wishes, etc. send e-mail to

    ...!mcvax!unido!tub!actisb!federico  (from Europe)
    ...!uunet!pyramid!actisb!federico    (from anywhere else)

    For Physical mail:

    Federico Heinz
    Beusselstr. 21
    1000 Berlin 21

    Tel. (+49 30) 396 77 92

*/
/***********************************************************************

  Basical pen movement.

***********************************************************************/

#include <ctype.h>
#include "defs.h"
#include "penctrl.h"
#include "io.h"
#include "dispatch.h"
#include "basic.h"


static Boolean     RelativePlot;         /* Are we plotting relative points? */
static char        SymbolChar;           /* Plot chars at end of vectors?    */


/*

  Reset this module's private status.

*/

void basicInit()

{ RelativePlot = False;
  setDash(FullLine, P1P2Diagonal / 25);
  SymbolChar = '\0';
}



/*

  Follow a Polyline given as CoordinatePairs.

*/

static void followPolyLine()

{ CoordinatePair target;

  while (isNumeric(LookAhead))
  { if (!getCoordinatePair(target))
    { endCommand();
      return;
    }
    if (RelativePlot)
    { target[X] = PenPosition[X] + target[X];
      target[Y] = PenPosition[Y] + target[Y];
    }
    doLine(target[X], target[Y]);
    if (SymbolChar)
      /* symbol mode stuff here */ ;
  }
  if (isTerminator(LookAhead))
    endCommand();
}


/***********************************************************************

  User-controlled pen lifting, lowering and selecting.
  
***********************************************************************/


/*

  Select a new pen.

*/

CommandImplementation selectPen()

{ Number pen;

  if (isNumeric(LookAhead) && getNumber(&pen))
    changePen(pen);
  else
    changePen(Zero);
  endCommand();
}



/*

  Lift the pen and follow the CoordinatePair list.

*/

CommandImplementation penUp()

{ liftPen();
  followPolyLine();
}



/*

  Lower the pen and follow the CoordinatePair list.

*/

CommandImplementation penDown()

{ lowerPen();
  followPolyLine();
}



/************************************************************************

     Mode switching (absolute/relative, symbol/no symbol)
  
************************************************************************/



/*

  Handle symbol mode switching.

*/

CommandImplementation setSymbolMode()

{ SymbolChar = isTerminator(LookAhead) ? '\0' : getChar();
  endCommand();
}
  


/*

  Start plotting with absolute coordinates.

*/

CommandImplementation setAbsolutePlot()

{ RelativePlot = False;
  followPolyLine();
}



/*

  Start plotting with relative coordinate 

*/

CommandImplementation setRelativePlot()

{ RelativePlot = True;
  followPolyLine();
}




/*

  Change the line type.

*/

CommandImplementation setLineType()

{ Number pattern, patternLength;

  if (isTerminator(LookAhead))
    setDash(FullLine, DefaultPatternLength);
  else if (getInteger(&pattern))
    if (isTerminator(LookAhead))
      setDash(pattern, DefaultPatternLength);
    else if (getInteger(&patternLength))
      setDash(pattern, patternLength);
  endCommand();
}

