/*
 *	Global defines.
 *	See "cif2ps.c" for authors' names and addresses.
 *	Please honor the authors by not removing their attributions.
 */

#include <stdio.h>

/* The following dimensions are all in points (1/72 in.) */
#define PAGEMARGIN	36
#define PAGEWIDTH	( 8.5 * 72 - 2 * PAGEMARGIN)
#define PAGELENGTH	(11.0 * 72 - 2 * PAGEMARGIN)
#define DEFPOINTS	6	/* default points size of text */

#define BIGINT	0x7FFFFF
#define false 0
#define true 1

#define MAXTOKEN		64
#define MAXSYMBOLS	256
#define MAXLINE		1024
#define LNAMELEN	7
#define MAXLAYERS	32
#define MAXNINETY_FOUR	64

#define DSTYPE		1
#define BOXTYPE		2
#define CALLTYPE	3
#define NINETY_FOURTYPE	4
#define NGONTYPE	5
#define ROUNDTYPE	6
#define WIRETYPE	7

#define WHITE	' '
#define COMMA	','

typedef	struct	{
	int	x, y;
	}	pointpairtype;

typedef struct	{
	int	layer;
	int	llx,lly,urx,ury;
	}	boxtype;

typedef struct	{
	int	layer;
	int	numPoints;
	int	*ptrPoints;
	}	ngontype;

typedef struct	{
	int	layer;
	int	x,y,r;
	}	roundtype;

typedef struct	{
	int	layer;
	int	numPoints;
	int	*ptrPoints;
	int	width;
	}	wiretype;

typedef struct	{
	int	name, a, b;
	}	dstype;

typedef struct	{
	char	name[MAXNINETY_FOUR];
	int	x, y, layer;
	}	ninety_fourtype;

typedef struct	{
	int	symbol;
	float	matrix[3][3];
	}	calltype;

typedef	struct	symboldumb	{
	struct	symboldumb	*next;
	int	typer;
	union	{
		boxtype	*box;
		dstype	*ds;
		calltype	*call;
		ninety_fourtype	*ninety_four;
		ngontype	*ngon;
		roundtype	*round;
		wiretype	*wire;
		}	primitive;
	}	symboltype;

typedef	struct	{
	int	symbol, a, b;
	char	name[MAXTOKEN];
	symboltype	*pointer;
	pointpairtype	ll, ur;
	}	tabletype;

typedef	struct	{
    	char	*name;
	char	*style;
	}	layertype;

symboltype	*allocsymbol();

tabletype	symbol_table[MAXSYMBOLS];
FILE	*ciffile;
int	no_lines;
layertype	layers[MAXLAYERS];
int	order[MAXLAYERS];
int	layer, numlayers;
int	last_symbol, current_symbol_index;
symboltype	*present_symbol;
char *cur_style;
float	scale, trans_x, trans_y, a_over_b;
float	matrix[3][3], top_matrix[3][3];
int	pagex,pagey;
int	length,width;
int	totpages;
int	font_points;	/* point-size of label font */

char *psheader[];
char *style_lookup();
