/*
 *	Output generation code.
 *	See "cif2ps.c" for authors' names and addresses.
 *	Please honor the authors by not removing their attributions.
 */

#include "define.h"

plot_box(box)
boxtype	*box;
{
	pointpairtype ll, ur;
	int dx, dy;

	if (box->layer != layer) return;
	get_pair(box->llx, box->lly, &ll);
	get_pair(box->urx, box->ury, &ur);
	dx = ur.x - ll.x;
	dy = ur.y - ll.y;
	printf("%d %d %d %d B %s\n",
	       dx, dy, ll.x, ll.y, cur_style);
}	/*plot_box*/

plot_ngon(ngon)
ngontype	*ngon;
{
	pointpairtype point;
	int n = ngon->numPoints;
	int *a = ngon->ptrPoints;

	if (ngon->layer != layer) return;
	get_pair(a[0], a[1], &point);
	printf("%d %d moveto %% P %d\n", point.x, point.y, n);
	n--; a += 2;
	do {
		get_pair(a[0], a[1], &point);
		printf("%d %d lineto\n", point.x, point.y);
		n--; a += 2;
	} while (n);
	printf("closepath %s\n", cur_style);
}	/* plot_ngon */

plot_round(round)
roundtype	*round;
{
	pointpairtype center;

	if (round->layer != layer) return;
	get_pair(round->x, round->y, &center);
	printf("newpath %d %d %d 0 360 arc closepath %s\n",
	       (int) center.x, (int) center.y,
	       (int) round->r, cur_style);
}	/* plot_round */

plot_wire(wire)
wiretype	*wire;
{
	pointpairtype point;
	int n = wire->numPoints;
	int *a = wire->ptrPoints;

	if (wire->layer != layer) return;
	printf("/WW %d 2 div def ",wire->width);
	get_pair(a[0], a[1], &point);
	printf("%d %d %% W %d\n", point.x, point.y, n);
	n--; a += 2;
	do {
		get_pair(a[0], a[1], &point);
		printf("%d %d Wto %s\n",
		       point.x, point.y, cur_style);
		n--; a += 2;
	} while (n);
	printf("pop pop\n");
}	/* plot_wire */

plot_text(ninety_four)
ninety_fourtype	*ninety_four;
{
	pointpairtype	pair;

	get_pair(ninety_four->x, ninety_four->y, &pair);
	plot_string(pair.x, pair.y, ninety_four->name);
}	/*plot_text*/

plot_string(x, y, stringer)
int x, y;
char	*stringer;
{
	printf("%d %d moveto (%s) show\n", x, y, stringer);
}	/*plot_string*/


void printStrings(p)
char **p;
{
	while(*p) puts(*p++);
}


putHeader()	/* goes before first page */
{
	/* Uses globals: psheader */

	puts("%!PS-Adobe-1.0");
	puts("%%Creator: cif2ps");
	puts("%%DocumentFonts: Helvetica");
	puts("%%Pages: (atend)");
	puts("%%EndComments");
	printStrings(psheader);
	puts("%%EndProlog\n");
}


putTrailer()		/* goes after last page */
{
	/* Uses global: totpages */

	puts("%%Trailer");
	printf("%%%%Pages: %d\n", totpages);
}


startPage()
{
	printf("%%%%Page: %d:%d\n", pagex, pagey);
	printf("%d dup translate %% margins\n", (int) PAGEMARGIN);

	if ( (width > 1) || (length > 1)) {
		/* multi-page plot: print the page number */
		printf("/Helvetica findfont ");
		printf("%d scalefont setfont\n", (int)DEFPOINTS);
		printf("0 %d moveto (Page %d,%d) show\n",
		       (int)(-DEFPOINTS), pagex, pagey);
	}
	printf("/Helvetica findfont %d ", font_points);
	printf("%g div scalefont setfont\n", scale);
	printf("%g dup scale %% points/centi-micron\n", scale);
	printf("%g %g translate %% cell_origin\n", trans_x, trans_y);
	if (pagex || pagey) {
		printf("%g %g translate %% page_origin\n",
			(float)(-pagex * PAGEWIDTH / scale),
			(float)(-pagey * PAGELENGTH / scale));
	}
}


finishPage()
{
	printf("showpage\n");
	totpages++;
}	/*epilog*/
