#include <stdio.h>

#define BIGINT	1000000
#define FOREVER while(1)
#define false 0
#define true 1

#define PAGEWIDTH 7.9
#define PAGELENGTH 10.5

/* defines for cmos-pw technology */
#define CW   1
#define CS   2
#define CD   3
#define CP   4
#define CM   5
#define CC   6
#define CM2  7
#define CC2  8
#define CZ   9
#define CG  10

/* defines for SCMOS technology */
#define CWP  1
#define CSP  2
#define CAA  3
#define CPG  4
#define CMF  5
#define CCP  6
#define CCA  7
#define CMS  8
#define CVA  9

#define MAXNAME		50
#define MAXSYMBOLS	200
#define MAXLINE		200
#define LAYERNAME	10
#define MAXLAYERS	11
#define MAXNINETY_FOUR	80

#define DSTYPE		1
#define BOXTYPE		2
#define CALLTYPE	3
#define NINETY_FOURTYPE	4
#define WHITE	' '
#define COMMA	','

typedef	struct	{
	int	x, y;
	}	pointpairtype;

typedef struct	{
	int	layer;
	int	loc[4];
	}	boxtype;

typedef struct	{
	int	name, a, b;
	}	dstype;

typedef struct	{
	char	name[MAXNINETY_FOUR];
	int	x, y, layer;
	}	ninety_fourtype;

typedef struct	{
	int	symbol;
	float	matrix[3][3];
	}	calltype;

typedef	struct	symboldumb	{
	struct	symboldumb	*next;
	int	typer;
	union	{
		boxtype	*box;
		dstype	*ds;
		calltype	*call;
		ninety_fourtype	*ninety_four;
		}	primitive;
	}	symboltype;

typedef	struct	{
	int	symbol, a, b;
	char	name[MAXNAME];
	symboltype	*pointer;
	pointpairtype	ll, ur;
	}	tabletype;

typedef	struct	{
    	char	name[LAYERNAME];
	}	layertype;


symboltype	*allocsymbol();

tabletype	symbol_table[MAXSYMBOLS];
FILE	*ciffile, *plotfile;
int	no_lines;
layertype	layers[MAXLAYERS];
int	clip[MAXLAYERS];
int	layer, numlayers;
int	last_symbol, current_symbol_index;
symboltype	*present_symbol;
float	scale, trans_x, trans_y, a_over_b;
float   scale2, scale2x, scale2y;
float	matrix[3][3];
float	slope;
float	step;
int	pagex,pagey;
int	length,width;
int	totpages;
int	size_font;
int	cmos_pw;
