/*
	cif2ps is based on the program 'cifp' originally written by
	Arthur Simoneau, The Aerospace Corporation, El Segundo, Calif

	Changes to 'cifp' include support of cmos-pw layers, scaling
	factors to spread output over several pages of 8.5 x 11 paper,
	printing multiple layers.

	Modified by Marc Lesure, Arizona State University, Tempe, AZ

	Please honor the authors by not removing names from the source codes.
*/
#include "define.h"

plot_box(box)
boxtype	*box;
{
	float		llx, urx, lly, ury, deltax, deltay;
	pointpairtype	pair;

	get_pair(box->loc[0], box->loc[1], &pair);
	llx = (pair.x + trans_x) * scale;
	lly = (pair.y + trans_y) * scale;
	get_pair(box->loc[2], box->loc[3], &pair);
	urx = (pair.x + trans_x) * scale;
	ury = (pair.y + trans_y) * scale;

	deltax = urx - llx;
	if (deltax < 0)
		{
		llx = llx + deltax;
		deltax = - deltax;
		}
	deltay = ury - lly;
	if (deltay < 0)
		{
		lly = lly + deltay;
		deltay = - deltay;
		}

	if (clip[layer])
		{
		if (inarea(llx, lly, deltax, deltay)) {
			clipper(llx, lly, deltax, deltay);
			fill_box(llx, lly, deltax, deltay);
		}
		}
	else
		{
		if (inarea(llx, lly, deltax, deltay)) 
			box_plotter(llx, lly, deltax, deltay);
   		}
}	/*plot_box*/


inarea(llx, lly, deltax, deltay)
float	llx, lly, deltax, deltay;
{
	float	left, bottom, top, right;
	float	maxx, maxy, minx, miny;

	minx = pagex * PAGEWIDTH;
	maxx = (pagex + 1) * PAGEWIDTH;
	miny = pagey * PAGELENGTH;
	maxy = (pagey + 1) * PAGELENGTH;
	left = llx;
	bottom = lly;
	right = llx + deltax;
	top = lly + deltay;
	if (left > maxx)
		return(0);
	if (top < miny)
		return(0);
	if (right < minx)
		return(0);
	if (bottom > maxy)
		return(0);
	return(1);
}



fill_box(llx, lly, deltax, deltay)
float	llx, lly, deltax, deltay;
{
	float	left, bottom, top, right;
	float	x, y, xx, yy;
	float	b, b_start;
	float	slope_x, inv_slope_y, slope_xx, inv_slope_yy, b_div_slope;
	float	minx,maxx,miny,maxy;
	float	trunc();
	int	toggle_top = 1, toggle_left = 1;

	minx = pagex * PAGEWIDTH;
	maxx = (pagex + 1) * PAGEWIDTH;
	miny = pagey * PAGELENGTH;
	maxy = (pagey + 1) * PAGELENGTH;
	left = llx;
	bottom = lly;
	right = llx + deltax;
	top = lly + deltay;

	if (slope <= 0)
		{
		b = top - (slope * right);
		x = right;
		}
	else
		{
		b = top - (slope * left);
		x = left;
		}

	b_start = trunc(b);
	while (b_start <= b)
		b_start += step;
	b_start -= step;	/*went one too far*/

	b_div_slope = b_start / slope;
	slope_x = slope * x;
	y = slope_x + b_start;
	inv_slope_y = y / slope;

	yy = top;
	inv_slope_yy = yy / slope;
	xx = inv_slope_yy - b_div_slope;
	slope_xx = slope * xx;

	b = b_start;
	FOREVER
		{
		b_div_slope = b / slope;
		if (toggle_left)
			{
			y = slope_x + b;
			if (y < bottom)
				{
				toggle_left = 0;
				y = bottom;
				inv_slope_y = y / slope;
				}
			}
		if ( !toggle_left)
			{
			x = inv_slope_y - b_div_slope;

			if (slope <= 0)
				{
				if (x <= left)
					return;
				}
			else
				{
				if (x >= right)
					return;
				}
			}

		if (toggle_top)
			{
			xx = inv_slope_yy - b_div_slope;
			if (slope <= 0)
 				{
				if (xx < left)
					{
					toggle_top = 0;
					xx = left;
					slope_xx = slope * xx;
					}
				}
			else
 				{
				if (xx > right)
					{
					toggle_top = 0;
					xx = right;
					slope_xx = slope * xx;
					}
				}
			}
		if ( !toggle_top)
			yy = slope_xx + b;

		if ((x < left) || (x > right) || (xx < left) || (xx > right))
			{
#ifdef DEBUG
			start_text();
			plot_string(x, y, "start error");
			plot_string(xx, yy, "end error");
			fprintf(stderr, "\nError....in x\n");
			fprintf(stderr, "x\t%f y\t%f xx\t%f yy\t%f\n",
				(float) x, (float) y, (float) xx, (float) yy);
			fprintf(stderr, "left\t%f bot\t%f right\t%f top \t%f\n",
						(float) left, (float) bottom,
						(float) right, (float) top);
			fprintf(stderr, "step %f ", (float) step);
			fprintf(stderr, "b %f, b start %f\n", b, b_start);
			return;
#endif
			}
		else if ((y < bottom) || (y > top) || (yy < bottom) || (yy > top))
			{
#ifdef DEBUG
			start_text();
			plot_string(x, y, "start error");
			plot_string(xx, yy, "end error");
			fprintf(stderr, "\nError....in y\n");
			fprintf(stderr, "x\t%f y\t%f xx\t%f yy\t%f\n",
				(float) x, (float) y, (float) xx, (float) yy);
			fprintf(stderr, "left\t%f bot\t%f right\t%f top \t%f\n",
						(float) left, (float) bottom,
						(float) right, (float) top);
			fprintf(stderr, "step %f ", (float) step);
			fprintf(stderr, "b %d, b start %d\n", b, b_start);
			return;
#endif	/*debug*/
			}
		else
			if ((inrange(minx,maxx,x) && inrange(miny,maxy,y)) ||
			    (inrange(minx,maxx,xx) && inrange(miny,maxy,yy)))
			{
				drawline(x, y, xx, yy);
			}

		b -= step;
		}	/*FOREVER*/
}	/*fill_box*/


inrange(min,max,value)
float min,max,value;
{
	return(min <= value && value <= max);
}


float
trunc(in)
float	in;
{
	long	temp;
	float	bar;

	temp = in;
	bar = temp;
	if (bar > 0)
		return(bar);
	else
		return(bar - 1);
}	/*trunc*/


plot_text(ninety_four)
ninety_fourtype	*ninety_four;
{
	float		x, y;
	pointpairtype	pair;

	get_pair(ninety_four->x, ninety_four->y, &pair);
	x = (pair.x + trans_x) * scale;
	y = (pair.y + trans_y) * scale;

	plot_string(x, y, ninety_four->name);
}	/*plot_text*/


plot_change_layer(layer_in)
int	layer_in;
{

	if ((layer_in >= 0) && (layer_in < numlayers))
		{
		if (!clip[layer])
			end_box();
		}
	if (cmos_pw == 1) {
		switch(layer_in)
			{
		case 0:
			break;
		case CW:
			fprintf(plotfile, "0.9 setgray\n");
			break;
		case CM2:
			fprintf(plotfile, "0.2 setgray\n");
			break;
		case CM:
			fprintf(plotfile, "0.3 setgray\n");
			break;
		case CP:
			fprintf(plotfile, "0.4 setgray\n");
			break;
		case CD:
			fprintf(plotfile, "0.5 setgray\n");
			break;
		case CZ:
		case CC:
		case CC2:
			fprintf(plotfile, "0 setgray\n");
			break;
		case CS:
			fprintf(plotfile, "0.8 setgray\n");
			break;
		case CG:
			fprintf(plotfile, "0.7 setgray\n");
			break;
		default:
			fprintf(stderr, "Error in plot_change_layer %d\n", layer_in);
			return;
			}
	}
	else {
		switch(layer_in)
			{
		case 0:
			break;
		case CWP:
			fprintf(plotfile, "0.9 setgray\n");
			break;
		case CMS:
			fprintf(plotfile, "0.2 setgray\n");
			break;
		case CMF:
			fprintf(plotfile, "0.3 setgray\n");
			break;
		case CPG:
			fprintf(plotfile, "0.4 setgray\n");
			break;
		case CAA:
			fprintf(plotfile, "0.5 setgray\n");
			break;
		case CCA:
		case CCP:
		case CVA:
			fprintf(plotfile, "0 setgray\n");
			break;
		case CSP:
			fprintf(plotfile, "0.8 setgray\n");
			break;
		default:
			fprintf(stderr, "Error in plot_change_layer %d\n", layer_in);
			return;
			}
	}
	if (layer_in != 0)
		fprintf(plotfile, "%% %s\n", layers[layer_in].name);

	layer = layer_in;
	if (clip[layer])
		start_clipping();
	else
		start_box();
}	/*plot_change_layer*/


start_box()
{
	fprintf(plotfile, "newpath\n");
}	/*start_box*/

end_box()
{
	fprintf(plotfile, "closepath\n");
}	/*end_box*/


start_clipping()
{
	fprintf(plotfile, "0 setgray  newpath\n");

	if (cmos_pw == 1) {
		switch(layer)
			{
		case CP:
			step = .5;
			slope = 5.0;
			break;
		case CM:
			step = .2;
			slope = 1.0;
			break;
		case CM2:
			step = .2;
			slope = -1.0;
			break;
		default:
			fprintf(stderr, "Hit default in start clipping %d\n", layer);
			break;
			}	/*switch*/
	}
	else {
		switch(layer)
			{
		case CPG:
			step = .5;
			slope = 5.0;
			break;
		case CMF:
			step = .2;
			slope = 1.0;
			break;
		case CMS:
			step = .2;
			slope = -1.0;
			break;
		default:
			fprintf(stderr, "Hit default in start clipping %d\n", layer);
			break;
			}	/*switch*/
	}
}	/*start_clipping*/





start_text()
{
	float	scalefont;

	fprintf(plotfile, "closepath\n");
	scalefont = scale * width * PAGEWIDTH * 20;
	fprintf(plotfile, "0 setgray\n");
	fprintf(plotfile, "/Helvetica findfont %f scalefont setfont\n",
								scalefont);
}	/*start_text*/


drawline(x, y, xx, yy)
float	x, y, xx, yy;
{
	fprintf(plotfile, "%f %f moveto %f %f lineto stroke\n", x, y, xx, yy);
}	/*drawline*/



box_plotter(llx, lly, deltax, deltay)
float	llx, lly, deltax, deltay;
{
	fprintf(plotfile, "%f %f %f %f box\n", llx, lly, deltax, deltay);
}	/*box_plotter*/


clipper(llx, lly, deltax, deltay)
float	llx, lly, deltax, deltay;
{
	fprintf(plotfile, "%f %f %f %f clipper\n", llx, lly, deltax, deltay);
}	/*clipper*/



plot_string(x, y, stringer)
float x, y;
char	*stringer;
{
	fprintf(plotfile, "%f %f moveto (%s) show\n", x, y, stringer);
}	/*plot_string*/


prolog()
{
	fprintf(plotfile, "%%!\n");
	fprintf(plotfile, "/area {/dely exch def /delx exch def moveto\n");
	fprintf(plotfile, "\tdelx 0 rlineto 0 dely rlineto delx neg 0 rlineto 0 dely neg rlineto} def\n");
	fprintf(plotfile, "/box {area fill} def\n");
	fprintf(plotfile, "/clipper {area stroke} def\n");
}	/*prolog*/

#ifdef DEBUG
foobar(ll, ur)
pointpairtype	*ll, *ur;

{
	float	deltax, deltay;

	if (cmos_pw == 1)
		plot_change_layer(CM);
	else
		plot_change_layer(CMS);
	deltax = ur->x - ll->x;
	deltay = ur->y - ll->y;
	fprintf(stderr, "ll %f %f \tdelta %f %f\n",
			(float) ll->x, (float) ll->y, deltax, deltay);
	box_plotter((float) ll->x, (float) ll->y, deltax, deltay);
}
#endif

prelog()
{
	fprintf(plotfile, "gsave\n");
	fprintf(plotfile, "/inch {72 mul} def\n");
	fprintf(plotfile, "%% small correction for full page printing\n");
	fprintf(plotfile, "20 20 translate\n");
	fprintf(plotfile, "%% undo unit scaling when printing full page\n");
	fprintf(plotfile, "/unitscale { 1 inch %f mul dup scale } def\n",
								scale/scale2);
	fprintf(plotfile, "0.001 setlinewidth\n");
	fprintf(plotfile, "%f dup scale\n", scale2/scale);
        fprintf(plotfile, "%3.3f 0.0 %3.3f %3.3f unitscale\n", 
						.5*scale2x, scale2x, scale2y);
	fprintf(plotfile,"%f %f translate\n",
		-pagex*PAGEWIDTH, -pagey*PAGELENGTH);
}


epilog()
{
	fprintf(plotfile, "0 setgray\n");
	fprintf(plotfile, "gsave\n");
	fprintf(plotfile, "0 setgray\n");
	fprintf(plotfile, "/Helvetica findfont 0.075 scalefont setfont\n");
	/* fprintf(plotfile, "%f %f moveto (%d,%d) show\n",
		pagex * PAGEWIDTH, pagey * PAGELENGTH, pagex, pagey); */
	fprintf(plotfile, "grestore\n");
	fprintf(plotfile, "grestore\n");
	fprintf(plotfile, "showpage\n");
	totpages++;
	fflush(plotfile);
}	/*epilog*/



init()
{
	int	i;

	no_lines = 0;
	layer = 0;
	last_symbol = -1;
	ds("DS 0", DSTYPE);
	nine("9 top_level");
	identity_matrix(matrix);

	(void) strcpy(layers[0].name, "FOOBAR");
	if (cmos_pw == 1) {
		(void) strcpy(layers[CW].name, "CW");
		(void) strcpy(layers[CM2].name, "CM2");
		(void) strcpy(layers[CM].name, "CM");
		(void) strcpy(layers[CP].name, "CP");
		(void) strcpy(layers[CD].name, "CD");
		(void) strcpy(layers[CC].name, "CC");
		(void) strcpy(layers[CS].name, "CS");
		(void) strcpy(layers[CC2].name, "CC2");
		(void) strcpy(layers[CZ].name, "CZ");
		(void) strcpy(layers[CG].name, "CG");
		numlayers = 11;
	}
	else {
 		(void) strcpy(layers[CWP].name, "CWP");
 		(void) strcpy(layers[CMS].name, "CMS");
 		(void) strcpy(layers[CMF].name, "CMF");
 		(void) strcpy(layers[CPG].name, "CPG");
 		(void) strcpy(layers[CAA].name, "CAA");
 		(void) strcpy(layers[CCA].name, "CCA");
 		(void) strcpy(layers[CCP].name, "CCP");
 		(void) strcpy(layers[CSP].name, "CSP");
 		(void) strcpy(layers[CVA].name, "CVA");
 		numlayers = 10;
	}

	for (i = 1; i < numlayers; i++)
		clip[i] = 0;

	if (cmos_pw == 1) {
		clip[CP] = 1;
		clip[CM] = 1;
		clip[CM2] = 1;
	}
	else {
 		clip[CPG] = 1;
 		clip[CMF] = 1;
 		clip[CMS] = 1;
	}

}	/*init*/
