/*
	cif2ps is based on the program 'cifp' originally written by
	Arthur Simoneau, The Aerospace Corporation, El Segundo, Calif

	Changes to 'cifp' include support of cmos-pw layers, scaling
	factors to spread output over several pages of 8.5 x 11 paper,
	printing multiple layers.

	Modified by Marc Lesure, Arizona State University, Tempe, AZ

	Please honor the authors by not removing names from the source codes.
*/
#include "define.h"

#define DELTA_A	'a' - 'A'

char	*malloc();

init_cif()
{
	layer = 0;
}	/*init_cif*/


get_next_cifline(stringer)
char	*stringer;

{
int	i;
char	c;

	for(i = 0; i < MAXLINE; i++)
		{
		c = fgetc(ciffile);
		if (c == ';')
			{
			stringer[i] = '\0';
			return(i);
			}
		else if (c == '\n')
			{
			stringer[i] = ' ';
			no_lines++;
			}
		else if (c == EOF)
			{
			stringer[i] = '\0';
			return(EOF);
			}
		else if (c == '(')
			{
			while (fgetc(ciffile) != ')') ;
			}
		else
			stringer[i] = c;
		}

	fprintf(stderr, "Cifline exceeded bounds\n");
	stringer[i] = '\0';
	output_cif(stderr, stringer);
	exit(1);
}	/*get_next_cifline*/



output_cif(filer, cif)
FILE	*filer;
char	*cif;

{
	fprintf(filer, "%s\t\t(*near line %d*)\n", cif, no_lines);
}	/*output_cif*/


trim_cif(cif)
char	*cif;

{
int	i, j, toggle_white;

	i = 0;
	j = 0;
	toggle_white = 1;		/*so no white at beginning*/
	for (i = 0; i < MAXLINE; i++)
		{
		if (cif[i] == COMMA)
			{
				cif[i] = WHITE;
			}
		if (cif[i] == '\0')
			{
			cif[j] = '\0';
			return;
			}
		else if (white(cif[i]))
			{
			if ( !toggle_white)	/*makes one white space*/
				{
				cif[j++] = ' ';
				toggle_white = 1;
				}
			}
		else
			{
			cif[j++] = cif[i];
			if (toggle_white) toggle_white = 0;
			}
		}	/*for*/
}	/*trim_cif*/


white(chr)
char	chr;

{
	switch(chr)
		{
	case ' ':
	case '\t':
		return(1);
	default:
		return(0);
		}
}	/*white*/


#ifdef DEBUG
output_symbol(filer, sym)
FILE	*filer;
int	sym;

{
	fprintf(filer, "For symbol index %d\n", sym);
	fprintf(filer, "\tsymbol %d", symbol_table[sym].symbol);
	fprintf(filer, "\t(%s)", symbol_table[sym].name);
	fprintf(filer, "\ta %d\tb %d\n", symbol_table[sym].a, symbol_table[sym].b);
	fprintf(filer, "\tll %d, %d ur %d, %d\n",
			symbol_table[sym].ll.x, symbol_table[sym].ll.y,
			symbol_table[sym].ur.x,symbol_table[sym].ur.y);
}	/*output_symbol*/
#endif


equal_strings(s1, s2)
char	*s1, *s2;

{
int	temp;

	while( (((temp = (*s1 - *s2)) == 0) || (abs(temp) == DELTA_A))
	   && (*s1 != '\0') && (*s2 != '\0'))
		{
		*s1++;	*s2++;
		}

	if (*s1 == *s2)			/*and therefore = '\0'*/
		return(1);
	else
		return(0);
}	/*equal_strings*/




	symboltype
*allocsymbol()
{
unsigned	size = sizeof(symboltype);
symboltype	*symbol;

	symbol =(symboltype *) malloc(size);
	symbol->typer = 0;
	symbol->primitive.box = NULL;
	symbol->next = NULL;

	return(symbol);
}	/*allocsymbol*/


	boxtype
*allocbox()
{
unsigned	size = sizeof(boxtype);
boxtype	*box;
int	i;

	box =(boxtype *) malloc(size);
	box->layer = 0;
	for(i = 0; i < 4; i++)
		box->loc[i] = 0;

	return(box);
}	/*allocbox*/



	int
get_index(num)
int	num;

{
int	i;

	for(i = 0; i <= last_symbol; i++)
		{
		if (symbol_table[i].symbol == num) return(i);
		}

	return(-1);
}	/*get_index*/



output_all_symbolnums(filer)
FILE	*filer;

{
int	i;

	fprintf(filer, "Symbols are:\n");
	for(i = 0; i <= last_symbol; i++)
		fprintf(filer, "%d\t%s\n", symbol_table[i].symbol,
							symbol_table[i].name);
}	/*output_all_symbolnums*/



do_cif()
{
char	cif[MAXLINE];

	while(get_next_cifline(cif) != EOF)
		{
#ifdef DEBUG
	fprintf(stderr,"trim before %d\n",cif[0]);
#endif
		trim_cif(cif);
#ifdef DEBUG
	fprintf(stderr,"trim after %d\n",cif[0]);
#endif

		switch(cif[0])
			{
		case 'D':
			switch(cif[1])
				{
			   case 'S':
				ds(cif, DSTYPE);
				break;
			   case 'F':
				df();
				break;
			   default:
				fprintf(stderr, "Unknown command in CIF\n");
				output_cif(stderr, cif);
				break;
				}	/*switch(cif[1]*/
			break;
		case '9':
			switch(cif[1])
				{
			   case WHITE:
				nine(cif);
				break;
			   case '4':
				ninety_four(cif);
				break;
			   default:
				fprintf(stderr, "Unknown command in CIF\n");
				output_cif(stderr, cif);
				break;
				}	/*switchcif[1]*/
			break;
		case 'B':
			box_cif(cif);
			break;
		case 'L':
			cif_change_layer(cif);
			break;
		case 'C':
			call_symbol(cif);
			break;
		case 0:
			break;
		default:
			fprintf(stderr, "Warning the following wasn't understood...ignoring\n");
			output_cif(stderr, cif);
			break;
			}	/*switch*/
		}
}	/*do_cif*/


ds(cif, typer)
char	*cif;
int	typer;

{
int	last_read, symnum, temp_index;
char	token[MAXNAME];
symboltype	*symbol;

	last_read = get_token(cif, 3, token);
	if (last_read == -1)
		{
		fprintf(stderr, "no symbol in DS\n");
		output_cif(stderr, cif);
		return;
		}
	(void) sscanf(token, "%d", &symnum);

	temp_index = get_index(symnum);
	if (temp_index == -1)
		{
		if (++last_symbol == MAXSYMBOLS)
			{
			fprintf(stderr, "Exceeded the number of allowed symbols\n");
			exit(1);
			}
		temp_index = last_symbol;
		}

	symbol_table[temp_index].symbol = symnum;
	symbol_table[temp_index].ll.x = BIGINT;
	symbol_table[temp_index].ll.y = BIGINT;
	symbol_table[temp_index].ur.x = -BIGINT;
	symbol_table[temp_index].ur.y = -BIGINT;
	symbol_table[temp_index].name[0] = '\0';
	symbol_table[temp_index].a = 1;
	symbol_table[temp_index].b = 1;
	a_over_b = 1;

	symbol = allocsymbol();
	if (typer == DSTYPE)
		{
		current_symbol_index = temp_index;
		present_symbol = symbol;
		}
	symbol->typer = DSTYPE;

	symbol_table[temp_index].pointer = symbol;
	*symbol_table[temp_index].name = '\0';

	last_read = get_token(cif, last_read, token);
	if (last_read == -1) return;
	(void) sscanf(token, "%d", &(symbol_table[temp_index].a));

	if (symbol_table[temp_index].a == 0)
		{
		fprintf(stderr, "read a 0 for A in DS\n");
		output_cif(stderr, cif);
		symbol_table[temp_index].a = 1;
		}

	last_read = get_token(cif, last_read, token);
	if (last_read == -1)
		{
		fprintf(stderr, "A but no B in DS\n");
		output_cif(stderr, cif);
		a_over_b = ((float) symbol_table[temp_index].a) /
					((float) symbol_table[temp_index].b);
		return;
		}
	(void) sscanf(token, "%d", &(symbol_table[temp_index].b));

	if (symbol_table[temp_index].b == 0)
		{
		fprintf(stderr, "read a 0 for B in DS\n");
		output_cif(stderr, cif);
		symbol_table[temp_index].b = 1;
		}
	a_over_b = ((float) symbol_table[temp_index].a) /
					((float) symbol_table[temp_index].b);
}	/*ds*/


	int
get_token(cif, from, token)
char	*cif;
int	from;
char	*token;

{
int	i;

	if ((from > 0) && (cif[from - 1] == '\0'))
		return(-1);

	for (i = 0; ((cif[i+from] != WHITE) && (cif[i+from] != COMMA));i++)
		{
		if (cif[i + from] == '\0')
			break;
		token[i] = cif[i + from];
		}

	token[i] = '\0';
	if (i == 0)
		return(-1);
	else
		return(i + from + 1);
}	/*get_token*/


df()
{
	current_symbol_index = 0;
	present_symbol = symbol_table[current_symbol_index].pointer;
}	/*df*/


box_cif(cif)
char	*cif;

{
int	next_one, i;
int	temp[4];
char	token[MAXNAME];
boxtype	*box, *allocbox();

	bang_symbol();
	present_symbol->typer = BOXTYPE;
	box = allocbox();
	present_symbol->primitive.box = box;

	box->layer = layer;

	next_one = 2;
	for(i = 0; i < 4; i++)
		{
		next_one = get_token(cif, next_one, token);
		if (next_one == -1)
			{
			fprintf(stderr, "incomplete box\n");
			output_cif(stderr, cif);
			return;
			}
		(void) sscanf(token, "%d", &(temp[i]));
		}

	box->loc[0] = a_over_b * (temp[2] - (temp[0]/2));
	box->loc[2] = a_over_b * (temp[2] + (temp[0]/2));
	box->loc[1] = a_over_b * (temp[3] - (temp[1]/2));
	box->loc[3] = a_over_b * (temp[3] + (temp[1]/2));
}	/*box_cif*/



cif_change_layer(cif)
char	*cif;

{
int	foobar, i;
char	token[MAXNAME];

	foobar = get_token(cif, 2, token);
	if (foobar == -1)
		{
		fprintf(stderr, "Error in layer command\n");
		output_cif(stderr, cif);
		return;
		}

	for(i = 0; i < numlayers; i++)
		{
		if (equal_strings(token, layers[i].name))
			{
			layer = i;
			return;
			}
		}

	fprintf(stderr, "layer not found\n");
	output_cif(stderr, cif);
	fprintf(stderr, "\nLayers are:\n");
	for(i = 0; i < numlayers; i++)
		fprintf(stderr, "\t%s\n", layers[i].name);
}	/*cif_change_layers*/


nine(cif)
char	*cif;

{
int	foobar;
char	token[MAXNAME];

	foobar = get_token(cif, 2, token);
	if (foobar == -1)
		{
		fprintf(stderr, "Error in 9 command\n");
		output_cif(stderr, cif);
		return;
		}

	(void) sscanf(token, "%s", symbol_table[current_symbol_index].name);
}	/*nine*/




#ifdef DEBUG
output_symboldef(filer, sym)
FILE	*filer;
int	sym;

{
symboltype	*symbol;

	output_symbol(stdout, sym);
	symbol = symbol_table[sym].pointer;
	while(symbol != NULL)
		{
		output_symbolsub(filer, symbol);
		symbol = symbol->next;
		}
}	/*output_symboldef*/


output_symbolsub(filer, symbol)
FILE	*filer;
symboltype	*symbol;

{
	fprintf(filer, "\ttype ");
	switch(symbol->typer)
		{
	case DSTYPE:
		fprintf(filer, "symbol\n");
		break;
	case BOXTYPE:
		output_box(filer, symbol->primitive.box);
		break;
	case CALLTYPE:
		output_call(filer, symbol->primitive.call);
		break;
	case NINETY_FOURTYPE:
		output_ninety_four(filer, symbol->primitive.ninety_four);
		break;
	default:
		fprintf(filer, "ERROR Not known %d\n", symbol->typer);
		return;
		}
}	/*output_symbolsub*/
#endif



bang_symbol()
{
	present_symbol->next = allocsymbol();
	present_symbol = present_symbol->next;
}	/*bang_symbol*/



#ifdef DEBUG
output_box(filer, box)
FILE	*filer;
boxtype	*box;

{
int	i;

	fprintf(filer, "\tBox ");
	for(i = 0; i < 4; i++)
		fprintf(filer, "%d ", box->loc[i]);

	fprintf(filer, "\t layer %s\n", layers[box->layer].name);
}	/*output_box*/
#endif



ninety_four(cif)
char	*cif;

{
int	last_read;
char	token[MAXNAME];
ninety_fourtype	*ninety_four, *allocninety_four();

	bang_symbol();
	present_symbol->typer = NINETY_FOURTYPE;
	ninety_four = allocninety_four();
	present_symbol->primitive.ninety_four = ninety_four;

	last_read = get_token(cif, 3, token);
	if (last_read == -1)
		{
		fprintf(stderr, "no text in ninety_four\n");
		output_cif(stderr, cif);
		return;
		}
	(void) sscanf(token, "%s", ninety_four->name);

	last_read = get_token(cif, last_read, token);
	if (last_read == -1)
		{
		fprintf(stderr, "no x in ninety_four\n");
		output_cif(stderr, cif);
		return;
		}
	(void) sscanf(token, "%d", &(ninety_four->x));
	ninety_four->x *= a_over_b;

	last_read = get_token(cif, last_read, token);
	if (last_read == -1)
		{
		fprintf(stderr, "no y in ninety_four\n");
		output_cif(stderr, cif);
		return;
		}
	(void) sscanf(token, "%d", &(ninety_four->y));
	ninety_four->y *= a_over_b;

	last_read = get_token(cif, last_read, token);
	if (last_read != -1)	/*don't need layer on 94*/
		ninety_four->layer = get_layer_num(token);
}	/*ninety_four*/


#ifdef DEBUG
output_ninety_four(filer, ninety_four)
FILE	*filer;
ninety_fourtype	*ninety_four;

{
	fprintf(filer, "\t94 %s, x %d y %d ", ninety_four->name,
					ninety_four->x, ninety_four->y);
	if ((ninety_four->layer < 0) || (ninety_four->layer >= numlayers))
		fprintf(stderr, "error in layer in 94 %d\n", ninety_four->layer);
	else
		fprintf(filer, "layer %s\n", layers[ninety_four->layer].name);
}	/*output_ninety_four*/
#endif


	int
get_layer_num(lay)
char	*lay;

{
int	i;

	for(i = 1; i < numlayers; i++)
		{
		if (equal_strings(lay, layers[i].name)) return(i);
		}

	fprintf(stderr, "layer **%s** not found in get layer\n", lay);
	return(0);
}	/*get_layer_num*/


	calltype
*alloccall()
{
unsigned	size = sizeof(calltype);
calltype	*call;

	call =(calltype *) malloc(size);
	call->symbol = -999;
	identity_matrix(call->matrix);

	return(call);
}	/*alloccall*/



	ninety_fourtype
*allocninety_four()
{
unsigned	size = sizeof(ninety_fourtype);
ninety_fourtype	*ninety_four;

	ninety_four =(ninety_fourtype *) malloc(size);
	ninety_four->layer = 0;
	ninety_four->x = 0;
	ninety_four->y = 0;
	ninety_four->name[0] = '\0';

	return(ninety_four);
}	/*allocninety_four*/


#ifdef DEBUG
output_call(filer, call)
FILE	*filer;
calltype	*call;

{
	fprintf(filer, "\tCall ");
	fprintf(filer, " %d (%s)\n", symbol_table[call->symbol].symbol,
					symbol_table[call->symbol].name);
	output_matrix(filer, call->matrix);
}	/*output_call*/
#endif
