/*
	cif2ps is based on the program 'cifp' originally written by
	Arthur Simoneau, The Aerospace Corporation, El Segundo, Calif

	Changes to 'cifp' include support of cmos-pw layers, scaling
	factors to spread output over several pages of 8.5 x 11 paper,
	printing multiple layers.

	Modified by Marc Lesure, Arizona State University, Tempe, AZ

	Please honor the authors by not removing names from the source codes.
*/
#include <ctype.h>
#include "define.h"

int	maxwidth = 5;
int	maxlength = 5;

main(argc, argv)
int	argc;
char	*argv[];

{
	char *s,*cifname,*plotname;

	length = width = 1;
	totpages = 0;
	size_font = false;
	cmos_pw = 1;
	while (argc-- > 1 && (*++argv)[0] == '-') {
		s = argv[0] + 1;
		switch (*s) {

			case 'w':
				width = atoi(*++argv);
				argc--;
				break;

			case 'h':
				length = atoi(*++argv);
				argc--;
				break;

			case 's':
				size_font = true;
				break;

			case 'T':
				cmos_pw++;
				break;

			default:
				printf("cif2ps: unknown flag - %s\n",*s);
				exit(0);
		}
	}
	if (argc != 2) {
		printf("Usage: cif2ps [-w width] [-h height] input output\n");
		exit(0);
	}
	cifname = *argv++;
	if ((ciffile = fopen(cifname, "r")) == NULL)
	{
		fprintf(stderr, "can't open %s\n", cifname);
		exit(1);
	}
	plotname = *argv;
	if ((plotfile = fopen(plotname, "w")) == NULL)
	{
		fprintf(stderr, "can't open %s\n", plotname);
		exit(1);
	}
	if (width <= 0) {
		printf("-w exceeds lower limit - setting to 1\n");
		width = 1;
	}
	if (length <= 0) {
		printf("-l exceeds lower limit - setting to 1\n");
		length = 1;
	}
	if (width > maxwidth) {
		printf("-w exceeds upper limit - setting to %d\n",maxwidth);
		width = maxwidth;
	}
	if (length > maxlength) {
		printf("-l exceeds upper limit - setting to %d\n",maxlength);
		length = maxlength;
	}
	init();
	do_cif();
	plotcif();
	printf("Complete plot contains %d pages\n",totpages);
#ifdef DEBUG
output_all_symbols(stderr);
#endif
}	/*main*/



#ifdef DEBUG
output_all_symbols(filer)
FILE	*filer;

{
int	i;

	for (i = 0; i <= last_symbol; i++)
		output_symboldef(filer, i);
}	/*output_all_symbols*/
#endif


plotcif()
{
int	symbol_num, i, plotted_one;
char	namein[MAXNAME];
pointpairtype	ll, ur;

	plotted_one = 0;
	FOREVER
		{
		if (ciffile == stdin)
			symbol_num = 0;	/*top_level*/
		else
			{
			FOREVER
				{
				fprintf(stderr, "What symbol do you want to plot?\n");
				i = 0;
				while ((namein[i] = getchar()) != '\n')
					{
					if (namein[i] == EOF)
						{
						if (( !plotted_one) &&
							(plotfile == stdout))
							{
							namein[0] = '0';
							i = 1;
							break;
							}
						else
							return;
						}
					i++;
					}
				namein[i] = '\0';
				if (i == 0)	/*terminate run*/
					return;

				symbol_num = get_index_char(namein);
				if (symbol_num != -1)
					break;

				fprintf(stderr, "couldn't find that symbol\n");
				output_all_symbolnums(stderr);
				}	/*FOREVER*/
			}

		plotted_one++;
		ll.x = BIGINT;
		ur.x = -BIGINT;
		ll.y = BIGINT;
		ur.y = -BIGINT;
		get_bounds(symbol_num, &ll, &ur);
		if ((ll.x == BIGINT) || (ll.y == BIGINT))
			{
			fprintf(stderr, "Error in bounds %d %d and %d %d\n",
						ll.x, ll.y, ur.x, ur.y);
			return;
			}

		if (plotted_one == 1) {
			get_window(&ll, &ur);
			init_cif();
		}
		prolog();
		for(pagey=0; pagey < length; pagey++)
			for(pagex=0; pagex < width; pagex++) {
				prelog();
				plot_boxes(symbol_table[symbol_num].pointer);
				plot_textes(symbol_table[symbol_num].pointer);
				epilog();
			}
		if (ciffile == stdin)
			return;
		}	/*FOREVER*/
}	/*plotcif*/


	int
get_index_char(foobar)
char	*foobar;

{
int	i, bar;

	for(i = 0; i <= last_symbol; i++)
		{
		if (equal_strings(symbol_table[i].name, foobar))
			return(i);
		}

	for(i = 0; i < MAXNAME; i++)
		{
		if (foobar[i] == '\0')
			{
			(void) sscanf(foobar, "%d", &bar);
			return(get_index(bar));
			}
		else if ( !isdigit(foobar[i]))
			return(-1);
		}

	return(-1);
}	/*get_index_char*/



get_window(ll, ur)
pointpairtype	*ll, *ur;

{
float	scalex, scaley;
float   deltax, deltay;
int	newlength, newwidth;

	trans_x = - ll->x;
	trans_y = - ll->y;

	scalex = (width * PAGEWIDTH) /  (deltax = (ur->x - ll->x));
	scaley = (length * PAGELENGTH) / (deltay = (ur->y - ll->y));
	if (scalex < scaley)
		{
		scale = scalex;
		scale2 = 1.0/deltax;
		scale2y = deltay/deltax;
		scale2x = 1.0;
		newlength = ((deltay * scale) / PAGELENGTH) + 1;
		if (newlength != length) {
			printf("output size changed to %d by %d\n",
				width,newlength);
			length = newlength;
		}
		}
	else
		{
		scale = scaley; 
		scale2 = 1.0/deltay;
		scale2y = 1.0;
		scale2x = deltax/deltay;
		newwidth = ((deltax * scale) / PAGEWIDTH) + 1;
		if (newwidth != width) {
			printf("output size changed to %d by %d\n",
				newwidth,length);
			width = newwidth;
		}
		}
#ifdef DEBUG
fprintf(stderr, "scale %f, scalex %f, scaley %f, deltax %f, deltay %f\n",
	scale, scalex, scaley, deltax, deltay);
#endif
}	/*get_window*/



plot_boxes(symbol)
symboltype	*symbol;

{
int	i, num_clip, plot_boxes_sub();

	num_clip = 0;
	for (i = 1; i < numlayers; i++)
		{
		plot_change_layer(i);
		num_clip = 0;
		num_clip = plot_boxes_sub(symbol, num_clip);
		}	/*for loop*/
	plot_change_layer(0);
}	/*plot_boxes*/




	int
plot_boxes_sub(symbol, num_clip)
symboltype	*symbol;
int	num_clip;

{
boxtype		*box;
float	temp_matrix[3][3];

	while(symbol != NULL)
		{
		switch(symbol->typer)
			{
		case BOXTYPE:
			box = symbol->primitive.box;
			if (box->layer == layer)
				{
				plot_box(box);
				if (clip[layer] && (++num_clip > 50))
					{
					num_clip = 0;
					start_clipping();
					}
				}
			break;
		case CALLTYPE:
			copy_matrix(matrix, temp_matrix);
			hit_matrix(matrix,
				symbol->primitive.call->matrix, matrix);
			num_clip = plot_boxes_sub(
				symbol_table[symbol->primitive.call->symbol].pointer, num_clip);

			copy_matrix(temp_matrix, matrix);
			break;
		case DSTYPE:
		case NINETY_FOURTYPE:
			break;
		default:
			fprintf(stderr, "ERROR Not known %d in plot boxes\n",
							symbol->typer);
			break;
			}

		symbol = symbol->next;
		}

	return(num_clip);
}	/*plot_boxes_sub*/



plot_textes(symbol)
symboltype	*symbol;

{
ninety_fourtype		*ninety_four;

	start_text();
	while(symbol != NULL)
		{
		switch(symbol->typer)
			{
		case CALLTYPE:
		case DSTYPE:
		case BOXTYPE:
			break;
		case NINETY_FOURTYPE:
			ninety_four = symbol->primitive.ninety_four;
			plot_text(ninety_four);
			break;
		default:
			fprintf(stderr, "ERROR Not known %d in plot text\n",
							symbol->typer);
			break;
			}

		symbol = symbol->next;
		}
}	/*plot_textes*/



get_bounds(sym, ll, ur)
int	sym;
pointpairtype	*ll, *ur;

{
int		local_sym;
symboltype	*symbol;
boxtype		*box;
pointpairtype	local_ll, local_ur;

	symbol = symbol_table[sym].pointer;
	while(symbol != NULL)
		{
		switch(symbol->typer)
			{
		case DSTYPE:
		case NINETY_FOURTYPE:
			break;
		case BOXTYPE:
			box = symbol->primitive.box;
			if (box->loc[0] < ll->x)
				ll->x = box->loc[0];
			if (box->loc[2] > ur->x)
				ur->x = box->loc[2];
			if (box->loc[1] < ll->y)
				ll->y = box->loc[1];
			if (box->loc[3] > ur->y)
				ur->y = box->loc[3];
			break;
		case CALLTYPE:
			local_sym = symbol->primitive.call->symbol;
			if (symbol_table[local_sym].ll.x == BIGINT)
				{
				get_bounds(local_sym,
					&(symbol_table[local_sym].ll),
					&(symbol_table[local_sym].ur));
				}
			copy_matrix(symbol->primitive.call->matrix, matrix);
			get_pair(symbol_table[local_sym].ll.x,
				symbol_table[local_sym].ll.y, &local_ll);
			get_pair(symbol_table[local_sym].ur.x,
				symbol_table[local_sym].ur.y, &local_ur);

			identity_matrix(matrix);
			if (local_ll.x < ll->x)
				ll->x = local_ll.x;
			if (local_ur.x < ll->x)
				ll->x = local_ur.x;
			if (local_ll.x > ur->x)
				ur->x = local_ll.x;
			if (local_ur.x > ur->x)
				ur->x = local_ur.x;
			if (local_ll.y < ll->y)
				ll->y = local_ll.y;
			if (local_ur.y < ll->y)
				ll->y = local_ur.y;
			if (local_ll.y > ur->y)
				ur->y = local_ll.y;
			if (local_ur.y > ur->y)
				ur->y = local_ur.y;
			break;
		default:
			fprintf(stderr, "ERROR Not known %d in get_bounds\n",
							symbol->typer);
			break;
			}

		symbol = symbol->next;
		}
}	/*get_bounds*/


get_pair(x, y, pair)
int	x, y;
pointpairtype	*pair;

{
	pair->x = (x * matrix[0][0]) + (y * matrix[0][1]) + matrix[0][2];
	pair->y = (x * matrix[1][0]) + (y * matrix[1][1]) + matrix[1][2];
}	/*get_pair*/



call_symbol(cif)
char	*cif;

{
int	last_read, callnum;
char	token[MAXNAME];
char	ciftemp[MAXLINE];
int	rotate_x, rotate_y;
float	multi_matrix[3][3];
float	temp_a_over_b, translate_x, translate_y;
calltype	*call, *alloccall();

	bang_symbol();
	present_symbol->typer = CALLTYPE;
	call = alloccall();
	present_symbol->primitive.call = call;

	last_read = get_token(cif, 2, token);
	if (last_read == -1)
		{
		fprintf(stderr, "no symbol in CALL\n");
		output_cif(stderr, cif);
		return;
		}
	(void) sscanf(token, "%d", &callnum);
	call->symbol = get_index(callnum);
	if (call->symbol == -1)
		{
		sprintf(ciftemp, "DS %d", callnum);
		temp_a_over_b = a_over_b;
		ds(ciftemp, CALLTYPE);
		a_over_b = temp_a_over_b;

		call->symbol = get_index(callnum);
		if (call->symbol == -1)
			{
			fprintf(stderr, "Error in call cif\n");
			output_cif(stderr, cif);
			}
		}

	identity_matrix(multi_matrix);
	FOREVER
		{
		last_read = get_token(cif, last_read, token);
		if (last_read == -1) break;

		if (token[0] == 'M')
			{
			switch(token[1])
				{
			case 'X':
				multi_matrix[0][0] = -1;
				hit_matrix(multi_matrix, call->matrix,
								call->matrix);
				multi_matrix[0][0] = 1;
				break;
			case 'Y':
				multi_matrix[1][1] = -1;
				hit_matrix(multi_matrix, call->matrix,
								call->matrix);
				multi_matrix[1][1] = 1;
				break;
			default:
				fprintf(stderr, "Error in mirror %c\n", token[1]);
				output_cif(stderr, cif);
				break;
				}	/*switch mirror*/
			}	/*if mirror*/
		else if (token[0] == 'R')
			{
			last_read = get_token(cif, last_read, token);
			if (last_read == -1)
				{
				fprintf(stderr, "error in rotate\n");
				output_cif(stderr, cif);
				break;
				}
			(void) sscanf(token, "%d", &rotate_x);
			rotate_x = sign(rotate_x);
			last_read = get_token(cif, last_read, token);
			if (last_read == -1)
				{
				fprintf(stderr, "error2 in rotate\n");
				output_cif(stderr, cif);
				break;
				}
			(void) sscanf(token, "%d", &rotate_y);
			rotate_y = sign(rotate_y);
			switch(rotate_x)
				{
			case 1:
				if (rotate_y != 0)
					fprintf(stderr, "Bad rotation x %d y %d\n",
							rotate_x, rotate_y);
				break;
			case -1:
				if (rotate_y != 0)
					{
					fprintf(stderr, "Bad rotation x %d y %d\n",
							rotate_x, rotate_y);
					break;
					}
				multi_matrix[0][0] = -1;
				multi_matrix[1][1] = -1;
				hit_matrix(multi_matrix, call->matrix, call->matrix);
				identity_matrix(multi_matrix);
				break;
			case 0:
				switch(rotate_y)
					{
				case 1:
					multi_matrix[0][0] = 0;
					multi_matrix[1][1] = 0;
					multi_matrix[0][1] = -1;
					multi_matrix[1][0] = 1;
					hit_matrix(multi_matrix, call->matrix,
								call->matrix);
					identity_matrix(multi_matrix);
					break;
				case -1:
					multi_matrix[0][0] = 0;
					multi_matrix[1][1] = 0;
					multi_matrix[0][1] = 1;
					multi_matrix[1][0] = -1;
					hit_matrix(multi_matrix, call->matrix,
								call->matrix);
					identity_matrix(multi_matrix);
					break;
				default:
					fprintf(stderr, "Bad rotation x %d y %d\n",
							rotate_x, rotate_y);
					break;
					}	/*switch y*/
				break;
			default:
				fprintf(stderr, "Bad rotation x %d y %d\n",
							rotate_x, rotate_y);
				break;
				}	/*switch rotation*/
			}	/*if rotate*/
		else if (token[0] == 'T')
			{
			last_read = get_token(cif, last_read, token);
			if (last_read == -1)
				{
				fprintf(stderr, "error in translate\n");
				output_cif(stderr, cif);
				break;
				}
			(void) sscanf(token, "%f", &translate_x);
			translate_x *= a_over_b;

			last_read = get_token(cif, last_read, token);
			if (last_read == -1)
				{
				fprintf(stderr, "error2 in translate\n");
				output_cif(stderr, cif);
				break;
				}
			(void) sscanf(token, "%f", &translate_y);
			translate_y *= a_over_b;

			if ((translate_x != 0) || (translate_y != 0))
				{
				multi_matrix[0][2] = translate_x;
				multi_matrix[1][2] = translate_y;
				hit_matrix(multi_matrix, call->matrix, call->matrix);
				identity_matrix(multi_matrix);
				}
			}	/*if translate*/
		else
			{
			fprintf(stderr, "error---out of calls\n");
			output_cif(stderr, cif);
			fprintf(stderr, "\ttoken %s\n", token);
			break;
			}
		}	/*FOREVER*/

}	/*call_symbol*/

sign(x)
int x;
{
	int z;

	z = 0;
	if (x > 0) z = 1;
	if (x < 0) z = -1;
	return(z);
}


#ifdef DEBUG
output_matrix(filer, matrix)
FILE	*filer;
float	matrix[3][3];

{
int	i, j;

	for(i = 0; i < 3; i++)
		{
		fprintf(filer, "[");
		for(j = 0; j < 3; j++)
			fprintf(filer, "\t%f", matrix[i][j]);
		fprintf(filer, "]\n");
		}
}	/*output_matrix*/
#endif


identity_matrix(matrix)
float	matrix[3][3];

{
	matrix[0][0] = 1;
	matrix[0][1] = 0;
	matrix[0][2] = 0;
	matrix[1][0] = 0;
	matrix[1][1] = 1;
	matrix[1][2] = 0;
	matrix[2][0] = 0;
	matrix[2][1] = 0;
	matrix[2][2] = 1;
}	/*identity_matrix*/



hit_matrix(left_matrix, right_matrix, to_matrix)
float	left_matrix[3][3], right_matrix[3][3], to_matrix[3][3];

{
int	i, j;
float	temp[3][3];

	for(i = 0; i < 3; i++)
		{
		for(j = 0; j < 3; j++)
			temp[i][j] = (left_matrix[i][0] * right_matrix[0][j]) +
					(left_matrix[i][1] * right_matrix[1][j]) +
					(left_matrix[i][2] * right_matrix[2][j]);
		}

	copy_matrix(temp, to_matrix);
}	/*hit_matrix*/



copy_matrix(from_matrix, to_matrix)
float	from_matrix[3][3], to_matrix[3][3];

{
int	i, j;

	for(i = 0; i < 3; i++)
		{
		for(j = 0; j < 3; j++)
			to_matrix[i][j] = from_matrix[i][j];
		}
}	/*copy_matrix*/
