#ifndef XDEFS_H
#define XDEFS_H

typedef unsigned short flag;


typedef struct cat_item CATITEM;

struct cat_item {
    char    *FileName;
    char    *Description;
    flag     Status;
    CATITEM *Next;
};


typedef struct song SONG;

struct song {
    char  *Count;
    char  *Title;
    flag   Status;
    SONG  *Next;
};

typedef struct {
    char   TapeType;
    char   NoiseReduction;
    char  *BackCode;
    char  *BackTl1;
    char  *BackTl2;
    SONG  *Side1;
    SONG  *Side2;
} CASS;



typedef struct {
    char *Text;
    int   Func;
} MLINE;



typedef struct {
    char  *MenuTitle;
    int    NEntries;
    MLINE *Entry;
} MENUITEM;

extern char	*NewString();
extern CATITEM	*NewCatItem();
extern CASS	*NewCass();
extern SONG	*NewSong();
extern SONG	*FindSong();

extern void	InDescription();
extern void	InTapeType();
extern void	InNoiseRed();
extern void	InBackCode();
extern void	RetCont();
extern void	ClearCass();
extern void	ClearScreen();
extern void	NLines();
extern void	AddCatItem();
extern void	Select();
extern void	ReadCover();
extern void	ListCovers();
extern void	SaveCover();
extern void	ShowGlobal();
extern void	ShowSongs();
extern void	ClearCurr();
extern void	UnSelect();
extern void	ShowGlobal();
extern void	NullEnd();
extern void	Panic();
extern void	Attention();

extern MENUITEM  MainMenu;
extern MENUITEM  TapeMenu;
extern MENUITEM  NoiseMenu;


extern CATITEM  *FirstCatIt;
extern CATITEM  *LastCatIt;
extern int       NCatItems;	
extern CASS	 CurCass[];
extern CATITEM	*CurIt;

extern char      LineBuf[];
extern char      Buf[];



/*
 * Now follow the declarations of all parameters concerning the layout
 */
extern int   CodeXPos;		/* Backcode parameter 1	*/
extern int   CodeYPos;		/* Backcode parameter 1	*/
extern int   CodeLen;		/* Backcode parameter 2	*/
extern char *CodeFont;		/* Backcode parameter 3	*/
extern int   CodeFSize;		/* Backcode parameter 4	*/

extern int   TsXPos;		/* Tapetype xpos, parameter 5	*/
extern int   TsYPos;		/* Tapetype ypos, parameter 5	*/
extern int   NrXPos;		/* NoiseRed xpos, parameter 6	*/
extern int   NrYPos;		/* NoiseRed ypos, parameter 6	*/
extern char *TsNrFont;		/* tapetype&NoiseRed font, p 7	*/
extern int   TsNrFSize;		/* ts & NoiseRed fontsize, p 8	*/

extern int   BT1XPos;		/* Backtitle 1 xpos, param  9	*/
extern int   BT1YPos;		/* Backtitle 1 ypos, param  9	*/
extern int   BT2XPos;		/* Backtitle 2 xpos, param  10	*/
extern int   BT2YPos;		/* Backtitle 2 ypos, param  10	*/
extern int   BTLen;		/* Backtitle Length, param  11	*/
extern char *BTFont;		/* Backtitle font, param 12	*/
extern int   BTFSize;		/* Backtitel fontsize, param 13	*/

extern int   FrAXPos;		/* Front A, xpos, param 14	*/
extern int   FrAYPos;		/* Front A, ypos, param 14	*/
extern int   FrBXPos;		/* Front B, xpos, param 15	*/
extern int   FrBYPos;		/* Front B, ypos, param 15	*/
extern char *FrABFont;		/* Front A&B, font, param 16	*/
extern int   FrABFSize;		/* Front A&B, fontsize, par 17	*/

extern int   FrTl1XPos;		/* Front title 1 xpos, par 18	*/
extern int   FrTl1YPos;		/* Front title 1 ypos, par 18	*/
extern int   FrTl2XPos;		/* Front title 2 xpos, par 19	*/
extern int   FrTl2YPos;		/* Front title 2 ypos, par 19	*/
extern char *FrTlFont;		/* Fronttitle font, param 20	*/
extern int   FrTlFSize;		/* Fronttitle fontsiz, param 21	*/

extern int   Tl1XPos;		/* Title 1 xpos, param 22	*/
extern int   Tl1YPos;		/* Title 1 ypos, param 22	*/
extern int   Tl2XPos;		/* Title 2 xpos, param 23	*/
extern int   Tl2YPos;		/* Title 2 ypos, param 23	*/
extern int   TlLen;		/* length of title, par 24	*/
extern int   TlLDist;		/* line spacing titles, par 25	*/
extern char *TlFont;		/* Title font, parameter 26	*/
extern int   TlFSize;		/* and fontsize, parameter 27	*/

extern int   CtTlXDist;		/* Dist between tl and ct,par28	*/
extern int   CtLen;		/* countlength, parameter 29	*/

extern int   FTlSepX1;		/* horizontal line front xfrom	*/
extern int   FTlSepX2;		/* horizontal line front xto	*/
extern int   FTlSepY;		/* horizontal line front y	*/

extern int   FVSepX;		/* front separation line x	*/
extern int   FVSepY1;		/* front separation line yfrom	*/
extern int   FVSepY2;		/* front separation line yto	*/




#endif XDEFS_H
