#include <stdio.h>
#include "defines.h"
#include "xdefs.h"

extern void SaveSongs();

void
Panic(s1, s2, s3, s4, s5, s6)
char *s1, *s2, *s3, *s4, *s5, *s6;
{
    ClearScreen();
    printf("ERROR: ");
    printf(s1, s2, s3, s4, s5, s6);
    printf("\n\n\n");
    exit(1);
}



void
Attention(s1, s2, s3, s4, s5)
char *s1, *s2, *s3, *s4, *s5;
{
    NLines((SCRLINES-3)/2 + 3);
    printf("ATTENTION: ");
    printf(s1, s2, s3, s4, s5);
    NLines((SCRLINES-3)/2);
    RetCont();
}





void
RetCont()
{
    char Buf[100];

    printf("Hit <RETURN> to continue ..."); fflush(stdout);
    gets(Buf);
    return;
}



Confirm()
{
    char Buf[80];
    char c;

    gets(Buf);
    c = Buf[0];
    if(c == 'y' || c == 'j'  || c == 'Y' || c == 'J' )
		return(1);
    return(0);
}



void
SaveCover(It, Cass)
CATITEM *It;
CASS    *Cass;
{
    FILE *Fp;

    if(It == (CATITEM *)0 || Cass == (CASS *)0) {
		Attention("There is no cover to save");
		return;
    }

    if(It->FileName == (char *)0 || *(It->FileName) == '\0') {
		Attention("There is no cover to save");
		return;
    }

    if((Fp = fopen(It->FileName, "w")) == NULL) {
		Attention("Can't write cover information to disk !!");
		return;
    }

    /*
     * Write magic string first
     */
    fprintf(Fp, "%s\n", CASSMAGIC);

    fprintf(Fp, "#S%c\n",  Cass->TapeType);
    fprintf(Fp, "#N%c\n",  Cass->NoiseReduction);
    fprintf(Fp, "#C%s\n",  Cass->BackCode);	/* String may be empty	*/
    fprintf(Fp, "#T1%s\n", Cass->BackTl1);
    fprintf(Fp, "#T2%s\n", Cass->BackTl2);

    SaveSongs(Fp, 1, Cass->Side1);
    SaveSongs(Fp, 2, Cass->Side2);

    fclose(Fp);
    return;
}



static void
SaveSongs(Fp, Side, SongP)
FILE *Fp;
int   Side;
SONG *SongP;
{
    while(SongP != (SONG *)0) {
		fprintf(Fp, "#c%d%s\n", Side, SongP->Count);
		fprintf(Fp, "#%d%s\n",  Side, SongP->Title);
		SongP = SongP->Next;
    }
    return;
}




/*
 * Return a pointer to a song PREVIOUS !!! to Num-est song
 * So Num may NOT be 0 or 1!
 */
SONG *
FindSong(Song, Num)
SONG *Song;
int   Num;
{
   
    if(Num == 0 || Num == 1)
	Panic("FindSong Num = %d\n", Num);

    --Num;
    while(--Num && Song != (SONG *)0) {
		Song = Song->Next;
    }
    return(Song);
}

CountSongs(Song)
SONG *Song;
{
    int Count = 0;
    while(Song != (SONG *)0) {
		Count++;
		Song = Song->Next;
    }
    return(Count);
}

void
ClearCurr()
{
    if(CurIt == (CATITEM *)0) return;
    ClearCass(CurCass);
    CurIt = (CATITEM *)0;
    return;
}


void
ClearCass(Cas)
CASS *Cas;
{
    SONG *SongP;
    SONG *List;

    free(Cas->BackCode);
    Cas->BackCode = (char *)0;

    free(Cas->BackTl1);
    Cas->BackTl1 = (char *)0;

    free(Cas->BackTl2);
    Cas->BackTl2 = (char *)0;

    /*
     * Clear songs of side 1
     */
    List = Cas->Side1;

    /*
     * While there are next songs ...
     */
    while(List != (SONG *)0 && List->Next != (SONG *)0) {
		SongP = List->Next;		/* SongP points to song to be freed */

		free(SongP->Count);		/* free count string */
		SongP->Count = (char *)0;

		free(SongP->Title);		/* free title string */
		SongP->Title = (char *)0;

		List->Next = SongP->Next;	/* Delete SongP from linked list .. */
		free(SongP);			/* And free song */
    }

    if(List != (SONG *)0) {
        /*
         * now free the last one
         */
        free(List->Count);
        List->Count = (char *)0;
        free(List->Title);
        List->Title = (char *)0;
        free(List);
        Cas->Side1 = (SONG *)0;
    }


    /*
     * Clear songs of side 2
     */
    List = Cas->Side2;

    /*
     * While there are next songs ...
     */
    while(List != (SONG *)0 && List->Next != (SONG *)0) {
		SongP = List->Next;		/* SongP points to song to be freed */

		free(SongP->Count);		/* free count string */
 		SongP->Count = (char *)0;
		free(SongP->Title);		/* free title string */
		SongP->Title = (char *)0;

		List->Next = SongP->Next;	/* Delete SongP from linked list .. */
		free(SongP);			/* And free song */
    }

    if(List != (SONG *)0) {
        /*
         * now free the last one
         */
        free(List->Count);
		List->Count = (char *)0;

        free(List->Title);
		List->Title = (char *)0;

        free(List);
        Cas->Side2 = (SONG *)0;
    }
    return;
}



void
ClearScreen()
{
    /*
     * Brrrr..
     */
    NLines(SCRLINES);
    return;
}



void
NLines(Count)
int Count;
{
    if(Count <= 0) {
	Attention("NLines(Count): Count <= 0!!!");
	return;
    }

    while(Count--)
	printf("\n");

    return;
}
